/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.service.palette;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.papyrus.diagram.common.service.palette.StereotypeRepresentation;
import org.eclipse.papyrus.diagram.common.service.palette.Value;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyRepresentation {
    private String propID;
    private ArrayList<Value> values;
    private Property UMLProperty;
    private boolean isRuntimeProperty = false;
    private StereotypeRepresentation stereotype;
    private String propertyQualifiedName;
    private String name;
    public static String separator = "|";

    public PropertyRepresentation(String stereotypeQualifiedName, String propertyQualifiedName) {
        this.propertyQualifiedName = propertyQualifiedName;
        this.propID = String.valueOf(stereotypeQualifiedName) + separator + propertyQualifiedName;
        this.values = new ArrayList();
    }

    public PropertyRepresentation(PropertyRepresentation propRep) {
        this.propertyQualifiedName = new String(propRep.getQualifiedName());
        this.propID = new String(propRep.getPropertyId());
        this.setUMLProperty(propRep.getUMLProperty());
        this.setRuntime(propRep.isRuntimeProperty);
        this.values = propRep.getValues();
    }

    public String getQualifiedName() {
        return this.propertyQualifiedName;
    }

    public void addValue(Value value) {
        value.setPropertyRepresentation(this);
        this.values.add(value);
    }

    public ArrayList<Value> getValues() {
        return this.values;
    }

    public Type getType() {
        Assert.isNotNull((Object)this.UMLProperty, (String)"The property has not been set!");
        return this.UMLProperty.getType();
    }

    public String getPropertyId() {
        return this.propID;
    }

    public int getUpperMultiplicity() {
        Assert.isNotNull((Object)this.UMLProperty, (String)"The property has not been set!");
        return this.UMLProperty.getUpper();
    }

    protected String getPropertyMultiplicity() {
        Assert.isNotNull((Object)this.UMLProperty, (String)"The property has not been set!");
        String multiplicity = "[" + this.UMLProperty.getLower() + "..";
        int upper = this.UMLProperty.getUpper();
        multiplicity = upper == -1 ? String.valueOf(multiplicity) + "*" : String.valueOf(multiplicity) + upper;
        multiplicity = String.valueOf(multiplicity) + "]";
        return multiplicity;
    }

    public String toString() {
        return this.propID;
    }

    protected String getValueToDisplay() {
        String label = null;
        ArrayList<Value> values = this.getValues();
        if (!values.isEmpty()) {
            label = values.toString();
        } else if (this.UMLProperty.isSetDefault()) {
            label = this.UMLProperty.getDefault();
        } else if (this.UMLProperty.isMultivalued()) {
            label = "[]";
        }
        return label;
    }

    public void setRuntime(boolean value) {
        this.isRuntimeProperty = value;
    }

    public boolean isRuntime() {
        return this.isRuntimeProperty;
    }

    public void setUMLProperty(Property property) {
        this.UMLProperty = property;
        this.name = property.getName();
    }

    public void setStereotype(StereotypeRepresentation ste) {
        this.stereotype = ste;
    }

    public void removeValue(Value value) {
        this.values.remove(value);
    }

    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    public StereotypeRepresentation getStereotypeRepresentation() {
        return this.stereotype;
    }

    public Property getUMLProperty() {
        Assert.isNotNull((Object)this.UMLProperty, (String)"The property has not been set!");
        return this.UMLProperty;
    }

    public String getLabel() {
        String label = this.name;
        String type = "";
        if (this.getType() != null) {
            type = this.getType().getLabel();
        }
        label = String.valueOf(label) + ": " + type + this.getPropertyMultiplicity() + " = " + this.getValueToDisplay();
        return label;
    }

    public ArrayList<String> getStringValue() {
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Value val : this.values) {
            stringValues.add(val.getValue());
        }
        return stringValues;
    }
}

