/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.service.palette;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.service.palette.AbstractAspectActionProvider;
import org.eclipse.papyrus.diagram.common.service.palette.IAspectAction;
import org.eclipse.papyrus.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.diagram.common.service.palette.StereotypePostAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StereotypeAspectActionProvider
extends AbstractAspectActionProvider {
    public static final String STEREOTYPE_ACTION_KEY = "org.eclipse.papyrus.postaction.applystereotype";
    public static final String FACTORY_ID = "org.eclipse.papyrus.applystereotypeactionprovider";

    public IAspectAction createAction(Node configurationNode) {
        StereotypePostAction action = new StereotypePostAction();
        action.init(configurationNode, this);
        return action;
    }

    public static NodeList createConfigurationNode(String stereotypeList) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element paletteDefElement = document.createElement("aspectTool");
            Element postActionNode = document.createElement("postAction");
            postActionNode.setAttribute("id", FACTORY_ID);
            postActionNode.setAttribute("stereotypesToApply", stereotypeList);
            paletteDefElement.appendChild(postActionNode);
            return paletteDefElement.getChildNodes();
        }
        catch (ParserConfigurationException e) {
            Activator.getDefault().logError("impossible to create the palette tree viewer content", e);
            return null;
        }
    }

    public boolean isEnable(IPaletteEntryProxy entryProxy) {
        return true;
    }
}

