/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.service.palette;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.papyrus.diagram.common.service.palette.PropertyRepresentation;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeRepresentation {
    private String stereotypeQualifiedName;
    private ArrayList<PropertyRepresentation> properties;
    private Stereotype stereotype;

    public StereotypeRepresentation(String qualifiedName) {
        this.stereotypeQualifiedName = qualifiedName;
        this.properties = new ArrayList();
        this.setUMLStereotype(null);
    }

    public StereotypeRepresentation(StereotypeRepresentation ste) {
        this.stereotypeQualifiedName = ste.getStereotypeQualifiedName();
        this.properties = new ArrayList();
        this.setUMLStereotype(ste.getUMLStereotype());
    }

    public void addProperty(PropertyRepresentation property) {
        property.setStereotype(this);
        this.properties.add(property);
    }

    public ArrayList<PropertyRepresentation> getPropertyRepresentations() {
        return this.properties;
    }

    public ArrayList<PropertyRepresentation> getPropertiesWithValues() {
        ArrayList<PropertyRepresentation> propertiesToSave = new ArrayList<PropertyRepresentation>();
        for (PropertyRepresentation prop : this.properties) {
            if (!prop.hasValues()) continue;
            propertiesToSave.add(prop);
        }
        return propertiesToSave;
    }

    public String getStereotypeQualifiedName() {
        return this.stereotypeQualifiedName;
    }

    public PropertyRepresentation getPropertyRepresentation(String stereotypeQualifiedName, String propertyQualifiedName) {
        for (PropertyRepresentation prop : this.properties) {
            if (!prop.getPropertyId().equals(String.valueOf(stereotypeQualifiedName) + PropertyRepresentation.separator + propertyQualifiedName)) continue;
            return prop;
        }
        return null;
    }

    public ArrayList<PropertyRepresentation> getRuntimeProperties() {
        ArrayList<PropertyRepresentation> propertiesToSave = new ArrayList<PropertyRepresentation>();
        for (PropertyRepresentation prop : this.properties) {
            if (!prop.isRuntime()) continue;
            propertiesToSave.add(prop);
        }
        return propertiesToSave;
    }

    public void setUMLStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    public Stereotype getUMLStereotype() {
        Assert.isNotNull((Object)this.stereotype, (String)"Stereotype has not been set!");
        return this.stereotype;
    }

    public boolean hasRuntimeProperties() {
        for (PropertyRepresentation prop : this.properties) {
            if (!prop.isRuntime()) continue;
            return true;
        }
        return false;
    }
}

