/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.sheet;

import java.util.LinkedList;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class UMLPropertySource
extends PropertySource {
    public UMLPropertySource(Object object, IItemPropertySource ips) {
        super(object, ips);
    }

    protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
        return new CustomPropertyDescriptor(this.object, itemPropertyDescriptor);
    }

    private class CustomPropertyDescriptor
    extends PropertyDescriptor {
        public CustomPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            super(object, itemPropertyDescriptor);
        }

        public CellEditor createPropertyEditor(Composite composite) {
            if (!this.itemPropertyDescriptor.canSetProperty(this.object)) {
                return null;
            }
            Object result = null;
            Object genericFeature = this.itemPropertyDescriptor.getFeature(this.object);
            if (genericFeature instanceof EReference && !((EReference)genericFeature).isMany()) {
                final ILabelProvider editLabelProvider = this.getEditLabelProvider();
                result = new ExtendedDialogCellEditor(composite, editLabelProvider){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(cellEditorWindow.getShell(), editLabelProvider);
                        dialog.setTitle("Element Selection");
                        dialog.setMessage("Select a String (* = any string, ? = any char):");
                        LinkedList<String> result = new LinkedList<String>();
                        result.add("");
                        result.addAll(CustomPropertyDescriptor.this.itemPropertyDescriptor.getChoiceOfValues(CustomPropertyDescriptor.this.object));
                        result.remove(null);
                        dialog.setElements(result.toArray());
                        Object toReturn = null;
                        if (dialog.open() == 0) {
                            toReturn = dialog.getFirstResult();
                            if ("".equals(toReturn)) {
                                toReturn = CustomPropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(null);
                            }
                        } else {
                            toReturn = CustomPropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(CustomPropertyDescriptor.this.object);
                        }
                        return toReturn;
                    }
                };
            } else {
                result = super.createPropertyEditor(composite);
            }
            return result;
        }
    }
}

