/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class InputDialog
extends Dialog {
    private final String title;
    private final String message;
    protected String initialValue = "";
    private String value = "";

    public InputDialog(Shell parentShell, String title, String message, String initialValue) {
        super(parentShell);
        this.title = title;
        this.message = message;
        if (initialValue != null) {
            this.initialValue = initialValue;
            this.value = initialValue;
        }
    }

    public String getValue() {
        return this.value;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        return composite;
    }

    protected void setValue(String newValue) {
        this.value = newValue;
    }
}

