/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.ui.helper;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.diagram.common.ui.helper.CustomPopupDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpDialog
extends CustomPopupDialog {
    private String description;
    private boolean parseTags;

    public HelpDialog(Shell parent, Point point, String title, String description) {
        super(parent, point, title);
        this.description = description;
        this.parseTags = false;
    }

    public HelpDialog(Shell parent, Point point, String title, String description, boolean parseTags) {
        super(parent, point, title);
        this.description = description;
        this.parseTags = parseTags;
    }

    @Override
    public void createSubsection() {
        FormText text = this.toolkit.createFormText(this.formHead.getBody(), false);
        text.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                try {
                    IWebBrowser externalBrowser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                    externalBrowser.openURL(new URL((String)e.getHref()));
                }
                catch (PartInitException e1) {
                    this.errorBrowser();
                    e1.printStackTrace();
                }
                catch (MalformedURLException e1) {
                    this.errorBrowser();
                    e1.printStackTrace();
                }
                catch (NullPointerException e1) {
                    this.errorBrowser();
                    e1.printStackTrace();
                }
            }

            private void errorBrowser() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"The browser can't be opened");
            }
        });
        text.setText(this.description, this.parseTags, true);
    }

    @Override
    protected Collection<Action> getActions() {
        return new LinkedList<Action>();
    }
}

