/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.ui.hyperlinkshell;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.helper.HyperlinkHelperFactory;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.DefaultHyperLinkTab;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkDiagram;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkException;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkManagerShell;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkTab;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkObject;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.LocalDefaultLinkDiagramTab;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedHLManager
extends HyperLinkManagerShell {
    protected DefaultHyperLinkTab defaultHyperLinkTab;
    protected LocalDefaultLinkDiagramTab defaultLinkDiagramTab;

    public AdvancedHLManager(IPageIconsRegistry editorFactoryRegistry, TransactionalEditingDomain domain, Element umlElement, View aview, Package model, HyperlinkHelperFactory hyperHelperFactory) {
        super(editorFactoryRegistry, domain, umlElement, aview, model, hyperHelperFactory);
        this.defaultHyperLinkTab = new DefaultHyperLinkTab(this.getcTabFolder(), this.allhypHyperlinkObjects);
        this.defaultHyperLinkTab.getMainComposite().addListener(22, new Listener(){

            public void handleEvent(Event event) {
                AdvancedHLManager.this.allhypHyperlinkObjects.clear();
                for (HyperLinkTab hyperLinkTab : AdvancedHLManager.this.tabList) {
                    AdvancedHLManager.this.allhypHyperlinkObjects.addAll(hyperLinkTab.getHyperlinkObjects());
                }
                AdvancedHLManager.this.defaultHyperLinkTab.setInput(AdvancedHLManager.this.allhypHyperlinkObjects);
            }
        });
        this.defaultLinkDiagramTab = new LocalDefaultLinkDiagramTab(this.getcTabFolder(), (EObject)umlElement);
    }

    protected ArrayList<HyperLinkDiagram> getCreatedHyperlinkDiagramsWithHeuristic(ICommand creationcommand) {
        CompositeCommand compositeCommand;
        Object value;
        ArrayList diagrams = new ArrayList();
        if (creationcommand instanceof CompositeCommand && (value = (compositeCommand = (CompositeCommand)creationcommand).getCommandResult().getReturnValue()) instanceof ArrayList) {
            diagrams.addAll((Collection)value);
        }
        ArrayList<HyperLinkDiagram> hyperLinkDiagrams = new ArrayList<HyperLinkDiagram>();
        int i = 0;
        while (i < diagrams.size()) {
            HyperLinkDiagram hyperLinkDiagram = new HyperLinkDiagram();
            hyperLinkDiagram.setDiagram((Diagram)diagrams.get(i));
            hyperLinkDiagram.setIsDefault(true);
            hyperLinkDiagram.setTooltipText(((Diagram)diagrams.get(i)).getName());
            hyperLinkDiagrams.add(hyperLinkDiagram);
            ++i;
        }
        return hyperLinkDiagrams;
    }

    @Override
    protected void executeOkButton() {
        ArrayList<HyperLinkDiagram> defaultdiagramsWithHeuristic = new ArrayList<HyperLinkDiagram>();
        if (this.defaultLinkDiagramTab.getDefaultHyperlinkComposite().isVisible()) {
            this.defaultLinkDiagramTab.okPressed();
            ICommand creationCommand = this.defaultLinkDiagramTab.getCommand();
            this.transactionalEditingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(this.defaultLinkDiagramTab.getCommand()));
            defaultdiagramsWithHeuristic.addAll(this.getCreatedHyperlinkDiagramsWithHeuristic(creationCommand));
        }
        this.transactionalEditingDomain.getCommandStack().execute((Command)HyperlinkHelperFactory.getEmptyAllHyperLinkCommand(this.transactionalEditingDomain, (EModelElement)this.view));
        this.allhypHyperlinkObjects.clear();
        for (HyperLinkTab hyperLinkTab : this.tabList) {
            this.allhypHyperlinkObjects.addAll(hyperLinkTab.getHyperlinkObjects());
        }
        for (HyperlinkObject hyperLink : this.allhypHyperlinkObjects) {
            hyperLink.setIsDefault(false);
        }
        int i = this.defaultHyperLinkTab.getDefaultHyperLinkObject().size() - 1;
        while (i >= 0) {
            HyperlinkObject hyperLinkObject = this.defaultHyperLinkTab.getDefaultHyperLinkObject().get(i);
            hyperLinkObject.setIsDefault(true);
            if (this.allhypHyperlinkObjects.contains(hyperLinkObject)) {
                this.allhypHyperlinkObjects.remove(hyperLinkObject);
                this.allhypHyperlinkObjects.add(0, hyperLinkObject);
            }
            --i;
        }
        i = 0;
        while (i < defaultdiagramsWithHeuristic.size()) {
            this.allhypHyperlinkObjects.add(0, (HyperlinkObject)defaultdiagramsWithHeuristic.get(0));
            ++i;
        }
        try {
            Command addHyperlinksCommand = this.hyperLinkHelperFactory.getAddHyperLinkCommand(this.transactionalEditingDomain, (EModelElement)this.view, this.allhypHyperlinkObjects);
            this.transactionalEditingDomain.getCommandStack().execute(addHyperlinksCommand);
        }
        catch (HyperLinkException error) {
            Activator.log.error((Throwable)error);
        }
        this.saveCorrespondingTab();
        this.tabList.clear();
        this.getHyperLinkShell().close();
    }

    @Override
    public void setInput(ArrayList<HyperlinkObject> hyperLinkObjectList) {
        super.setInput(hyperLinkObjectList);
        this.defaultHyperLinkTab.setInput(this.allhypHyperlinkObjects);
    }
}

