/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.ui.hyperlinkshell;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkContentProvider;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkLabelProvider;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkObject;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHyperLinkTab {
    protected TableViewer availableHyperLinkViewer;
    protected Button defaultHRight;
    protected Button defaultHleft;
    protected Button defaultHup;
    protected Button defaultHdown;
    protected TableViewer defaultHyperLinkViewer;
    protected ArrayList<HyperlinkObject> defaultHyperLinkObject = new ArrayList();
    protected ArrayList<HyperlinkObject> availableHyperLinkObject = new ArrayList();
    protected Composite defaultHyperlinkComposite;

    public ArrayList<HyperlinkObject> getDefaultHyperLinkObject() {
        return this.defaultHyperLinkObject;
    }

    public DefaultHyperLinkTab(CTabFolder tabFolder, ArrayList<HyperlinkObject> hyperLinkObjectList) {
        CTabItem tbtmDefaultsHyperlinks = new CTabItem(tabFolder, 0);
        tbtmDefaultsHyperlinks.setText("Defaults HyperLinks");
        this.defaultHyperlinkComposite = new Composite((Composite)tabFolder, 0);
        this.defaultHyperlinkComposite.setBackground(Display.getCurrent().getSystemColor(1));
        tbtmDefaultsHyperlinks.setControl((Control)this.defaultHyperlinkComposite);
        Label lblHyperlinks = new Label(this.defaultHyperlinkComposite, 0);
        lblHyperlinks.setBackground(Display.getCurrent().getSystemColor(1));
        lblHyperlinks.setForeground(Display.getCurrent().getSystemColor(2));
        lblHyperlinks.setBounds(23, 10, 71, 13);
        lblHyperlinks.setText("HyperLinks:");
        Label lblDefaultHyperlinksby = new Label(this.defaultHyperlinkComposite, 0);
        lblDefaultHyperlinksby.setBackground(Display.getCurrent().getSystemColor(1));
        lblDefaultHyperlinksby.setBounds(366, 10, 186, 13);
        lblDefaultHyperlinksby.setText("Default Hyperlinks (by double-click):");
        Table availableHyperLink = new Table(this.defaultHyperlinkComposite, 67584);
        availableHyperLink.setBounds(30, 29, 250, 177);
        this.defaultHRight = new Button(this.defaultHyperlinkComposite, 0);
        this.defaultHRight.setBounds(availableHyperLink.getBounds().x + availableHyperLink.getBounds().width + 20, availableHyperLink.getBounds().y + availableHyperLink.getBounds().height / 2 - 30, 30, 23);
        this.defaultHRight.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (DefaultHyperLinkTab.this.availableHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.availableHyperLinkViewer.getSelection() instanceof IStructuredSelection) {
                    HyperlinkObject hyperlinkObjectToMove = (HyperlinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.availableHyperLinkViewer.getSelection()).getFirstElement();
                    hyperlinkObjectToMove.setIsDefault(true);
                    DefaultHyperLinkTab.this.availableHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.add(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.defaultHleft = new Button(this.defaultHyperlinkComposite, 0);
        this.defaultHleft.setBounds(availableHyperLink.getBounds().x + availableHyperLink.getBounds().width + 20, availableHyperLink.getBounds().y + availableHyperLink.getBounds().height / 2, 30, 23);
        this.defaultHleft.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() instanceof IStructuredSelection) {
                    HyperlinkObject hyperlinkObjectToMove = (HyperlinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection()).getFirstElement();
                    hyperlinkObjectToMove.setIsDefault(false);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.availableHyperLinkObject.add(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        Table defaultHyperLink = new Table(this.defaultHyperlinkComposite, 67584);
        defaultHyperLink.setBounds(this.defaultHRight.getBounds().x + this.defaultHRight.getBounds().width + 20, 29, 250, 177);
        this.defaultHup = new Button(this.defaultHyperlinkComposite, 0);
        this.defaultHup.setBounds(defaultHyperLink.getBounds().x + defaultHyperLink.getBounds().width + 20, defaultHyperLink.getBounds().y + defaultHyperLink.getBounds().height / 2 - 30, 34, 23);
        this.defaultHup.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                HyperlinkObject hyperlinkObjectToMove;
                int index;
                if (DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() instanceof IStructuredSelection && (index = DefaultHyperLinkTab.this.defaultHyperLinkObject.indexOf(hyperlinkObjectToMove = (HyperlinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection()).getFirstElement())) > 0) {
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.add(index - 1, hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.defaultHdown = new Button(this.defaultHyperlinkComposite, 0);
        this.defaultHdown.setBounds(defaultHyperLink.getBounds().x + defaultHyperLink.getBounds().width + 20, defaultHyperLink.getBounds().y + defaultHyperLink.getBounds().height / 2, 34, 23);
        this.defaultHdown.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                HyperlinkObject hyperlinkObjectToMove;
                int index;
                if (DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() instanceof IStructuredSelection && (index = DefaultHyperLinkTab.this.defaultHyperLinkObject.indexOf(hyperlinkObjectToMove = (HyperlinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection()).getFirstElement())) < DefaultHyperLinkTab.this.defaultHyperLinkObject.size() - 1) {
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.add(index + 1, hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.defaultHdown.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.diagram.common", (String)"/icons/obj16/ArrowDown_16x16.gif").createImage());
        this.defaultHup.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.diagram.common", (String)"/icons/obj16/ArrowUp_16x16.gif").createImage());
        this.defaultHleft.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.diagram.common", (String)"/icons/obj16/ArrowLeft_16x16.gif").createImage());
        this.defaultHRight.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.diagram.common", (String)"/icons/obj16/ArrowRight_16x16.gif").createImage());
        IPageIconsRegistry editorRegistry = null;
        IMultiDiagramEditor papyrusEditor = EditorUtils.getMultiDiagramEditor();
        try {
            editorRegistry = (IPageIconsRegistry)papyrusEditor.getServicesRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        this.availableHyperLinkViewer = new TableViewer(availableHyperLink);
        this.availableHyperLinkViewer.setLabelProvider((IBaseLabelProvider)new HyperLinkLabelProvider(editorRegistry));
        this.availableHyperLinkViewer.setContentProvider((IContentProvider)new HyperLinkContentProvider());
        this.availableHyperLinkViewer.setInput(hyperLinkObjectList);
        this.defaultHyperLinkViewer = new TableViewer(defaultHyperLink);
        this.defaultHyperLinkViewer.setLabelProvider((IBaseLabelProvider)new HyperLinkLabelProvider(editorRegistry));
        this.defaultHyperLinkViewer.setContentProvider((IContentProvider)new HyperLinkContentProvider());
    }

    public Composite getMainComposite() {
        return this.defaultHyperlinkComposite;
    }

    protected void refresh() {
        this.availableHyperLinkViewer.setInput(this.availableHyperLinkObject);
        this.defaultHyperLinkViewer.setInput(this.defaultHyperLinkObject);
    }

    public void setInput(ArrayList<HyperlinkObject> hyperLinkObjectList) {
        this.defaultHyperLinkObject.clear();
        this.availableHyperLinkObject.clear();
        for (HyperlinkObject hyperlinkObject : hyperLinkObjectList) {
            if (hyperlinkObject.getIsDefault()) {
                this.defaultHyperLinkObject.add(hyperlinkObject);
                continue;
            }
            this.availableHyperLinkObject.add(hyperlinkObject);
        }
        this.refresh();
    }
}

