/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.ui.hyperlinkshell;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.core.editor.BackboneException;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.core.extension.NotFoundException;
import org.eclipse.papyrus.core.extension.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.core.extension.commands.CreationCommandRegistry;
import org.eclipse.papyrus.core.extension.commands.ICreationCommand;
import org.eclipse.papyrus.core.extension.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.core.utils.DiResourceSet;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.AbstractLookForDiagramShell;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.CustomAdapterFactoryContentProvider;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class EditorLookForDiagram
extends AbstractLookForDiagramShell {
    private final IPageIconsRegistry editorRegistry;
    private final String SEP = " - ";
    protected AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    protected Diagram selectedDiagram;
    protected Package model;
    protected Menu diagramMenuButton;
    protected TreeViewer diagramListTreeViewer;
    protected TreeViewer treeViewer;

    protected Diagram getSelectedDiagram() {
        return this.selectedDiagram;
    }

    protected void setSelectedDiagram(Diagram selectedDiagram) {
        this.selectedDiagram = selectedDiagram;
    }

    public EditorLookForDiagram(IPageIconsRegistry editorFactoryRegistry, Package amodel) {
        this.editorRegistry = editorFactoryRegistry;
        this.model = amodel;
        this.createLookforShell();
        this.treeViewer = this.getModeFilteredTree().getViewer();
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory){

            public Image getImage(Object object) {
                if (object instanceof Diagram) {
                    return EditorLookForDiagram.this.editorRegistry.getEditorIcon(object);
                }
                return super.getImage(object);
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new CustomAdapterFactoryContentProvider(this.adapterFactory));
        this.treeViewer.setInput((Object)this.model.eResource());
        this.diagramListTreeViewer = this.getDiagramfilteredTree().getViewer();
        this.diagramListTreeViewer.setUseHashlookup(true);
        this.diagramListTreeViewer.setLabelProvider((IBaseLabelProvider)new ObjectLabelProvider(null));
        this.diagramListTreeViewer.setContentProvider((IContentProvider)new DiagramListContentProvider());
        this.diagramListTreeViewer.setInput((Object)" ");
        this.diagramMenuButton = new Menu((Control)this.getNewDiagrambutton());
        this.getNewDiagrambutton().setMenu(this.diagramMenuButton);
        CreationCommandRegistry commandRegistry = CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.core");
        for (CreationCommandDescriptor desc : commandRegistry.getCommandDescriptors()) {
            MenuItem menuItem = new MenuItem(this.diagramMenuButton, 8);
            menuItem.addSelectionListener((SelectionListener)new DiagramCreateListener(desc, null, (ICreationCommandRegistry)commandRegistry));
            menuItem.setText(desc.getLabel());
        }
        this.getNewDiagrambutton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForDiagram.this.diagramMenuButton.setVisible(true);
            }
        });
        this.getRemoveDiagrambutton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection iSelection = (IStructuredSelection)EditorLookForDiagram.this.getModeFilteredTree().getViewer().getSelection();
                Iterator iterator = iSelection.iterator();
                while (iterator.hasNext()) {
                    IPageMngr pageMngr = EditorUtils.getIPageMngr();
                    pageMngr.removePage(iterator.next());
                }
                EditorLookForDiagram.this.getDiagramfilteredTree().getViewer().setInput(null);
                EditorLookForDiagram.this.getDiagramfilteredTree().getViewer().setInput((Object)"");
                EditorLookForDiagram.this.getModeFilteredTree().getViewer().setInput(null);
                EditorLookForDiagram.this.getModeFilteredTree().getViewer().setInput((Object)EditorLookForDiagram.this.model.eResource());
            }
        });
        this.getModeFilteredTree().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)EditorLookForDiagram.this.getModeFilteredTree().getViewer().getSelection()).getFirstElement();
                if (selection instanceof Diagram) {
                    EditorLookForDiagram.this.selectedDiagram = (Diagram)selection;
                }
            }
        });
        this.getDiagramfilteredTree().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)EditorLookForDiagram.this.getDiagramfilteredTree().getViewer().getSelection()).getFirstElement();
                if (selection instanceof Diagram) {
                    EditorLookForDiagram.this.selectedDiagram = (Diagram)selection;
                }
            }
        });
        this.getOKbutton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForDiagram.this.getLookforShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getCancelbutton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForDiagram.this.setSelectedDiagram(null);
                EditorLookForDiagram.this.getLookforShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void open() {
        Display display = Display.getCurrent();
        this.getLookforShell().setSize(700, 500);
        this.getLookforShell().pack();
        this.getLookforShell().setBounds(500, 500, 500, 300);
        this.getLookforShell().open();
        while (!this.getLookforShell().isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public class DiagramCreateListener
    extends SelectionAdapter {
        private final CreationCommandDescriptor commandDescriptor;
        private Element container;
        private final ICreationCommandRegistry iCreationCommandRegistry;

        public void widgetSelected(SelectionEvent e) {
            try {
                Element elt = (Element)((IStructuredSelection)EditorLookForDiagram.this.treeViewer.getSelection()).getFirstElement();
                this.setContainer(elt);
                ServicesRegistry servicesRegistry = EditorUtils.getServiceRegistry();
                DiResourceSet diResourceSet = (DiResourceSet)servicesRegistry.getService(DiResourceSet.class);
                ICreationCommand creationCommand = this.iCreationCommandRegistry.getCommand(this.commandDescriptor.getCommandId());
                creationCommand.createDiagram(diResourceSet, (EObject)this.container, null);
                EditorLookForDiagram.this.getDiagramfilteredTree().getViewer().setInput(null);
                EditorLookForDiagram.this.getDiagramfilteredTree().getViewer().setInput((Object)"");
                EditorLookForDiagram.this.getModeFilteredTree().getViewer().setInput(null);
                EditorLookForDiagram.this.getModeFilteredTree().getViewer().setInput((Object)EditorLookForDiagram.this.model.eResource());
            }
            catch (NotFoundException ex) {
                ex.printStackTrace();
            }
            catch (BackboneException ex) {
                ex.printStackTrace();
            }
            catch (ServiceException ex) {
                ex.printStackTrace();
            }
        }

        public DiagramCreateListener(CreationCommandDescriptor commandDescriptor, Element container, ICreationCommandRegistry iCreationCommandRegistry) {
            this.commandDescriptor = commandDescriptor;
            this.container = container;
            this.iCreationCommandRegistry = iCreationCommandRegistry;
        }

        public void setContainer(Element container) {
            this.container = container;
        }
    }

    public class DiagramListContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            try {
                IPageMngr iPageMngr = EditorUtils.getIPageMngr();
                Object[] result = iPageMngr.allPages().toArray();
                ArrayList<Object> res = new ArrayList<Object>();
                Object[] objectArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object current = objectArray[n2];
                    if (current != null && current instanceof Diagram) {
                        res.add(current);
                    }
                    ++n2;
                }
                return res.toArray();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ObjectLabelProvider
    implements ILabelProvider {
        protected String theImagePath;

        public ObjectLabelProvider(String imagePath) {
            this.theImagePath = imagePath;
        }

        public Image getImage(Object element) {
            if (element instanceof Diagram) {
                return EditorLookForDiagram.this.editorRegistry.getEditorIcon(element);
            }
            return null;
        }

        public String getText(Object element) {
            String out = "";
            if (!(element instanceof Diagram)) {
                return element.toString();
            }
            out = ((Diagram)element).getName();
            return out;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

