/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.ui.hyperlinkshell;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.helper.HyperlinkHelperFactory;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.AbstractHyperLinkManagerShell;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkException;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkTab;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkObject;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkManagerShell
extends AbstractHyperLinkManagerShell {
    private static final String HYPER_LINK_SHELL_MEMENTO = "HYPER_LINK_SHELL_MEMENTO";
    private static final String LAST_TAB_USE_MEMENTO = "LAST_TAB_USE_MEMENTO";
    protected static final String LAST_GLOBAL_TAB_USED = "LAST_USED_MEMENTO";
    protected ArrayList<HyperlinkObject> allhypHyperlinkObjects = new ArrayList();
    protected View view;
    protected Package amodel;
    protected TransactionalEditingDomain transactionalEditingDomain;
    protected HyperlinkHelperFactory hyperLinkHelperFactory;

    public void setInput(ArrayList<HyperlinkObject> hyperLinkObjectList) {
        this.allhypHyperlinkObjects.clear();
        this.allhypHyperlinkObjects.addAll(hyperLinkObjectList);
        for (HyperLinkTab hyperLinkTab : this.tabList) {
            hyperLinkTab.setInput(this.allhypHyperlinkObjects);
        }
    }

    public HyperLinkManagerShell(IPageIconsRegistry editorFactoryRegistry, TransactionalEditingDomain domain, Element umlElement, View aview, Package model, HyperlinkHelperFactory hyperHelperFactory) {
        this.hyperLinkHelperFactory = hyperHelperFactory;
        this.view = aview;
        this.amodel = model;
        this.transactionalEditingDomain = domain;
        this.createHyperLinkShell();
        for (AbstractHyperLinkHelper abstractHyperLinkHelper : hyperHelperFactory.getHyperLinkHelpers()) {
            this.initializeFolder(abstractHyperLinkHelper);
        }
        this.getCancelButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperLinkManagerShell.this.tabList.clear();
                HyperLinkManagerShell.this.getHyperLinkShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        SelectionListener okListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperLinkManagerShell.this.executeOkButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.getOkButton().addSelectionListener(okListener);
    }

    protected void executeOkButton() {
        this.transactionalEditingDomain.getCommandStack().execute((Command)HyperlinkHelperFactory.getEmptyAllHyperLinkCommand(this.transactionalEditingDomain, (EModelElement)this.view));
        this.allhypHyperlinkObjects.clear();
        for (HyperLinkTab hyperLinkTab : this.tabList) {
            this.allhypHyperlinkObjects.addAll(hyperLinkTab.getHyperlinkObjects());
        }
        try {
            this.transactionalEditingDomain.getCommandStack().execute(this.hyperLinkHelperFactory.getAddHyperLinkCommand(this.transactionalEditingDomain, (EModelElement)this.view, this.allhypHyperlinkObjects));
        }
        catch (HyperLinkException error) {
            Activator.log.error((Throwable)error);
        }
        this.saveCorrespondingTab();
        this.tabList.clear();
        this.getHyperLinkShell().close();
    }

    public void initializeFolder(final AbstractHyperLinkHelper abstractHyperLinkHelper) {
        final HyperLinkTab hyperLinkTab = new HyperLinkTab(this.getcTabFolder(), abstractHyperLinkHelper, this.allhypHyperlinkObjects);
        this.tabList.add(hyperLinkTab);
        hyperLinkTab.getRemoveHyperLinkButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (hyperLinkTab.getTableViewer().getTable().getSelection().length != 0) {
                    for (Object object : (IStructuredSelection)hyperLinkTab.getTableViewer().getSelection()) {
                        hyperLinkTab.getHyperlinkObjects().remove(object);
                        hyperLinkTab.getTableViewer().setInput(hyperLinkTab.getHyperlinkObjects());
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        hyperLinkTab.getUpHyperLinkButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (hyperLinkTab.getTableViewer().getTable().getSelection().length != 0) {
                    Object elt = ((IStructuredSelection)hyperLinkTab.getTableViewer().getSelection()).getFirstElement();
                    if (hyperLinkTab.getHyperlinkObjects().indexOf(elt) == 0) {
                        return;
                    }
                    for (HyperlinkObject currentHyperLinkDoc : (IStructuredSelection)hyperLinkTab.getTableViewer().getSelection()) {
                        int index = hyperLinkTab.getHyperlinkObjects().indexOf(currentHyperLinkDoc);
                        hyperLinkTab.getHyperlinkObjects().remove(currentHyperLinkDoc);
                        hyperLinkTab.getHyperlinkObjects().add(index - 1, currentHyperLinkDoc);
                        hyperLinkTab.getTableViewer().setInput(hyperLinkTab.getHyperlinkObjects());
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        hyperLinkTab.getDownHyperLinkButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (hyperLinkTab.getTableViewer().getTable().getSelection().length != 0) {
                    Object[] block = ((IStructuredSelection)hyperLinkTab.getTableViewer().getSelection()).toArray();
                    if (hyperLinkTab.getHyperlinkObjects().indexOf(block[block.length - 1]) == hyperLinkTab.getHyperlinkObjects().size() - 1) {
                        return;
                    }
                    int i = block.length - 1;
                    while (i >= 0) {
                        HyperlinkObject currentobject = (HyperlinkObject)block[i];
                        int index = hyperLinkTab.getHyperlinkObjects().indexOf(currentobject);
                        hyperLinkTab.getHyperlinkObjects().remove(currentobject);
                        hyperLinkTab.getHyperlinkObjects().add(index + 1, currentobject);
                        hyperLinkTab.getTableViewer().setInput(hyperLinkTab.getHyperlinkObjects());
                        --i;
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        hyperLinkTab.getNewHyperLinkbutton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                abstractHyperLinkHelper.executeNewMousePressed(hyperLinkTab.getHyperlinkObjects(), HyperLinkManagerShell.this.amodel);
                hyperLinkTab.setInput(hyperLinkTab.getHyperlinkObjects());
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        hyperLinkTab.getModifyHyperLinkButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (hyperLinkTab.getTableViewer().getTable().getSelection().length != 0) {
                    HyperlinkObject hyperLinkObject = (HyperlinkObject)((IStructuredSelection)hyperLinkTab.getTableViewer().getSelection()).getFirstElement();
                    abstractHyperLinkHelper.executeEditMousePressed(hyperLinkTab.getHyperlinkObjects(), hyperLinkObject, HyperLinkManagerShell.this.amodel);
                    hyperLinkTab.setInput(hyperLinkTab.getHyperlinkObjects());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    public void open() {
        Display display = Display.getCurrent();
        this.getHyperLinkShell().pack();
        this.getHyperLinkShell().setBounds(500, 500, 700, 300);
        this.getHyperLinkShell().open();
        this.selectLastTab();
        while (!this.getHyperLinkShell().isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void saveCorrespondingTab() {
        IMemento rootMemento = HyperLinkManagerShell.getExistingHPMemento();
        IMemento memento = HyperLinkManagerShell.getLastTabUseMemento(rootMemento);
        EObject element = this.view.getElement();
        if (element != null) {
            int selectionIndex = this.getcTabFolder().getSelectionIndex();
            memento.putInteger(element.eClass().getInstanceTypeName(), selectionIndex);
            memento.putInteger(LAST_GLOBAL_TAB_USED, selectionIndex);
        }
        HyperLinkManagerShell.saveMemento((XMLMemento)rootMemento, HYPER_LINK_SHELL_MEMENTO);
    }

    protected void selectLastTab() {
        IMemento rootMemento = HyperLinkManagerShell.getExistingHPMemento();
        EObject element = this.view.getElement();
        Integer lastIndexUsed = null;
        if (element != null) {
            lastIndexUsed = HyperLinkManagerShell.getLastTabUseMemento(rootMemento, element.eClass().getInstanceTypeName());
        }
        if (lastIndexUsed == null && (lastIndexUsed = HyperLinkManagerShell.getLastTabUseMemento(rootMemento, LAST_GLOBAL_TAB_USED)) == null) {
            lastIndexUsed = 0;
        }
        try {
            this.getcTabFolder().setSelection(lastIndexUsed.intValue());
        }
        catch (IndexOutOfBoundsException e) {
            this.getcTabFolder().setSelection(0);
        }
    }

    public static void saveMemento(XMLMemento xmlMemento, String key) {
        StringWriter writer = new StringWriter();
        try {
            xmlMemento.save((Writer)writer);
            if (HyperLinkManagerShell.getPreferenceStore() != null) {
                HyperLinkManagerShell.getPreferenceStore().setValue(key, writer.toString());
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError("input/ouput exception", e);
        }
    }

    public static IMemento getExistingHPMemento() {
        String sValue = HyperLinkManagerShell.getPreferenceStore().getString(HYPER_LINK_SHELL_MEMENTO);
        try {
            if (sValue != null && !sValue.equals("")) {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            return XMLMemento.createWriteRoot((String)HYPER_LINK_SHELL_MEMENTO);
        }
        catch (WorkbenchException e) {
            Activator.getDefault().logError("Impossible to read preferences", e);
            return null;
        }
    }

    public static Integer getLastTabUseMemento(IMemento rootMemento, String elementSemanticHint) {
        IMemento lastTabUsedMemento = HyperLinkManagerShell.getLastTabUseMemento(rootMemento);
        if (lastTabUsedMemento != null) {
            return lastTabUsedMemento.getInteger(elementSemanticHint);
        }
        return null;
    }

    protected static IMemento getLastTabUseMemento(IMemento memento) {
        IMemento lastTabUsedMemento = memento.getChild(LAST_TAB_USE_MEMENTO);
        if (lastTabUsedMemento == null) {
            lastTabUsedMemento = memento.createChild(LAST_TAB_USE_MEMENTO);
        }
        return lastTabUsedMemento;
    }

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

