/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.ui.hyperlinkshell;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkContentProvider;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkLabelProvider;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkObject;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkTab {
    protected CTabItem hyperlinksTab;
    protected Table hyperLinkListTable;
    protected Button newHyperLinkbutton;
    protected Button modifyHyperLinkButton;
    protected Button removeHyperLinkButton;
    protected Button upHyperLinkButton;
    protected Button downHyperLinkButton;
    protected TableViewer tableViewer;
    protected ArrayList<HyperlinkObject> hyperlinkObjects = new ArrayList();
    protected AbstractHyperLinkHelper hyperLinkHelper;
    private HyperLinkContentProvider contentProvider;

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public ArrayList<HyperlinkObject> getHyperlinkObjects() {
        return this.hyperlinkObjects;
    }

    public void setHyperlinkObjects(ArrayList<HyperlinkObject> hyperlinkObjects) {
        this.hyperlinkObjects = hyperlinkObjects;
    }

    public HyperLinkTab(CTabFolder cTabFolder, AbstractHyperLinkHelper hyperLinkHelper, ArrayList<HyperlinkObject> hyperlinkObjects) {
        this.hyperLinkHelper = hyperLinkHelper;
        this.contentProvider = new HyperLinkContentProvider();
        CTabItem cTabItem2 = new CTabItem(cTabFolder, 0);
        cTabItem2.setText(String.valueOf(hyperLinkHelper.getNameofManagedHyperLink()) + " hyperlinks");
        Composite diagramComposite = new Composite((Composite)cTabFolder, 0);
        cTabItem2.setControl((Control)diagramComposite);
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 2;
        GridData gridData1 = new GridData();
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalSpan = 6;
        gridData1.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        diagramComposite.setBackground(Display.getCurrent().getSystemColor(1));
        diagramComposite.setLayout((Layout)gridLayout);
        CLabel listLabel = new CLabel(diagramComposite, 32);
        listLabel.setText("List of " + hyperLinkHelper.getNameofManagedHyperLink() + " hyperlinks:");
        listLabel.setEnabled(false);
        listLabel.setBackground(Display.getCurrent().getSystemColor(1));
        Label filler = new Label(diagramComposite, 0);
        this.hyperLinkListTable = new Table(diagramComposite, 2050);
        this.tableViewer = new TableViewer(this.hyperLinkListTable);
        this.newHyperLinkbutton = new Button(diagramComposite, 0);
        this.newHyperLinkbutton.setText("");
        this.newHyperLinkbutton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.diagram.common", (String)"/icons/obj16/Add_16x16.gif").createImage());
        this.newHyperLinkbutton.setLayoutData((Object)gridData4);
        this.hyperLinkListTable.setHeaderVisible(false);
        this.hyperLinkListTable.setToolTipText("set of " + hyperLinkHelper.getNameofManagedHyperLink() + "hyperlinks ");
        this.hyperLinkListTable.setLayoutData((Object)gridData1);
        this.hyperLinkListTable.setLinesVisible(false);
        this.modifyHyperLinkButton = new Button(diagramComposite, 0);
        this.modifyHyperLinkButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.diagram.common", (String)"/icons/obj16/Modify.gif").createImage());
        this.removeHyperLinkButton = new Button(diagramComposite, 0);
        this.removeHyperLinkButton.setText("");
        this.removeHyperLinkButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.diagram.common", (String)"/icons/obj16/Delete_16x16.gif").createImage());
        this.upHyperLinkButton = new Button(diagramComposite, 0);
        this.upHyperLinkButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.diagram.common", (String)"/icons/obj16/ArrowUp_16x16.gif").createImage());
        this.upHyperLinkButton.setLayoutData((Object)gridData2);
        this.downHyperLinkButton = new Button(diagramComposite, 0);
        this.downHyperLinkButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.diagram.common", (String)"/icons/obj16/ArrowDown_16x16.gif").createImage());
        this.downHyperLinkButton.setLayoutData((Object)gridData3);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        IPageIconsRegistry editorRegistry = null;
        IMultiDiagramEditor papyrusEditor = EditorUtils.getMultiDiagramEditor();
        try {
            editorRegistry = (IPageIconsRegistry)papyrusEditor.getServicesRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        this.hyperlinkObjects = hyperLinkHelper.getFilteredObject(hyperlinkObjects);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new HyperLinkLabelProvider(editorRegistry));
        this.getTableViewer().setInput(this.hyperlinkObjects);
    }

    public CTabItem getHyperlinksTab() {
        return this.hyperlinksTab;
    }

    public Table getHyperLinkListTable() {
        return this.hyperLinkListTable;
    }

    public Button getNewHyperLinkbutton() {
        return this.newHyperLinkbutton;
    }

    public Button getModifyHyperLinkButton() {
        return this.modifyHyperLinkButton;
    }

    public Button getRemoveHyperLinkButton() {
        return this.removeHyperLinkButton;
    }

    public Button getUpHyperLinkButton() {
        return this.upHyperLinkButton;
    }

    public Button getDownHyperLinkButton() {
        return this.downHyperLinkButton;
    }

    public void setInput(List<HyperlinkObject> hyperlinkObjects) {
        this.hyperlinkObjects = this.hyperLinkHelper.getFilteredObject(hyperlinkObjects);
        this.getTableViewer().setInput(this.hyperlinkObjects);
    }
}

