/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.util.IObjectWithContributorId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionPointParser {
    private Class<Object>[] classes = null;
    private Object enclosingInstance = null;
    private String extensionPointID = null;

    public ExtensionPointParser(String extensionPointID, Class<Object>[] classes) {
        this.classes = classes;
        this.extensionPointID = extensionPointID;
    }

    public ExtensionPointParser(String extensionPointID, Class<Object>[] classes, Object enclosingInstance) {
        this.classes = classes;
        this.extensionPointID = extensionPointID;
        this.enclosingInstance = enclosingInstance;
    }

    public Class<Object>[] getClasses() {
        return this.classes;
    }

    public String getExtensionPointID() {
        return this.extensionPointID;
    }

    public Class getEnclosingClass() {
        if (this.getEnclosingInstance() != null) {
            return this.getEnclosingInstance().getClass();
        }
        return null;
    }

    public Object getEnclosingInstance() {
        return this.enclosingInstance;
    }

    public List<Object> parseExtensionPoint() {
        if (this.getExtensionPointID() == null || this.getClasses() == null || this.getClasses().length <= 0) {
            return Collections.EMPTY_LIST;
        }
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(this.getExtensionPointID());
        if (extensionPoint == null) {
            Activator.getDefault().logError("The Extension Point ID provided does not exist", null);
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Object object = this.parseConfigurationElement(element);
            if (object != null) {
                objects.add(object);
            }
            ++n2;
        }
        return objects;
    }

    protected Object parseConfigurationElement(IConfigurationElement element) {
        if (element == null) {
            return null;
        }
        Object object = this.createInstance(element);
        if (object == null) {
            return null;
        }
        if (object instanceof IObjectWithContributorId) {
            String pluginID = element.getContributor().getName();
            ((IObjectWithContributorId)object).setContributorId(pluginID);
        }
        Field[] fieldArray = object.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute;
            Field field = fieldArray[n2];
            if (!(field.getType().isAssignableFrom(List.class) && !field.getType().isAssignableFrom(Object.class) || (attribute = field.getName()) == null || attribute.contains("$"))) {
                Object value = this.parseAttribute(element, attribute);
                if (!(value instanceof String)) {
                    if (field.getType().isAssignableFrom(List.class)) {
                        try {
                            if (field.get(object) == null) {
                                field.set(object, Collections.EMPTY_LIST);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this.error("Cannot acces field " + attribute, e);
                        }
                        catch (IllegalAccessException e) {
                            this.error("Cannot acces field " + attribute, e);
                        }
                    }
                } else {
                    String valueString = (String)value;
                    try {
                        if (field.getType().isAssignableFrom(Object.class)) {
                            Object instantiation = null;
                            try {
                                instantiation = element.createExecutableExtension(attribute);
                                field.set(object, instantiation);
                            }
                            catch (CoreException e) {
                                this.error("Cannot create instance of " + valueString, e);
                                instantiation = null;
                            }
                        } else if (field.getType().isAssignableFrom(Boolean.class)) {
                            field.set(object, Boolean.valueOf(valueString));
                        } else {
                            field.set(object, valueString);
                        }
                    }
                    catch (IllegalAccessException ex) {
                        this.error("Cannot acces field " + attribute, ex);
                        return null;
                    }
                    catch (IllegalArgumentException ex) {
                        this.error("Illegal value for " + attribute, ex);
                        return null;
                    }
                }
            }
            ++n2;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n3 = iConfigurationElementArray.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement child = iConfigurationElementArray[n];
            Object parsedChild = this.parseConfigurationElement(child);
            if (parsedChild != null) {
                objects.add(parsedChild);
            }
            ++n;
        }
        this.addChildrenToInstance(object, objects);
        return object;
    }

    protected Object parseAttribute(IConfigurationElement element, String attribute) {
        return element.getAttribute(attribute);
    }

    protected void addChildrenToInstance(Object instance, List<Object> children) {
        for (Object child : children) {
            String name = child.getClass().getSimpleName();
            try {
                Field field = instance.getClass().getField(name);
                ArrayList value = field.get(instance);
                if (!field.getType().isAssignableFrom(List.class)) continue;
                if (value == null) {
                    value = new ArrayList();
                    field.set(instance, value);
                }
                ((List)value).add(child);
            }
            catch (NoSuchFieldException ex) {
                this.error("No field named " + name, ex);
                return;
            }
            catch (IllegalAccessException ex) {
                this.error("Field " + name + " not accessible", ex);
                return;
            }
        }
    }

    protected Object createInstance(IConfigurationElement element) {
        String name = element.getName();
        Class<Object>[] classArray = this.getClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<Object> clazz = classArray[n2];
            if (clazz.getSimpleName().equals(name)) {
                try {
                    Class[] parameters = null;
                    parameters = this.getEnclosingClass() != null ? new Class[]{this.getEnclosingClass()} : new Class[]{};
                    Constructor<Object> constructor = clazz.getConstructor(parameters);
                    Object[] arguments = null;
                    arguments = this.getEnclosingInstance() != null ? new Object[]{this.getEnclosingInstance()} : new Object[]{};
                    return constructor.newInstance(arguments);
                }
                catch (IllegalAccessException ex) {
                    this.error("Cannot access constructor for " + name, ex);
                    return null;
                }
                catch (IllegalArgumentException ex) {
                    this.error("Cannot create instance of type " + name, ex);
                    return null;
                }
                catch (InstantiationException ex) {
                    this.error("Cannot create instance of type " + name, ex);
                    return null;
                }
                catch (NoSuchMethodException ex) {
                    this.error("Cannot find constructor for " + name, ex);
                    return null;
                }
                catch (InvocationTargetException ex) {
                    this.error("Cannot invoke constructor for " + name, ex);
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    private void error(String message, Throwable throwable) {
        Activator.getDefault().logError(message, throwable);
    }
}

