/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.ids.MOSKittEditorIDs;
import org.eclipse.papyrus.diagram.common.part.CachedResourcesDiagramEditor;
import org.eclipse.papyrus.diagram.common.part.CachedResourcesEditorInput;
import org.eclipse.papyrus.diagram.common.part.EditingDomainRegistry;
import org.eclipse.papyrus.diagram.common.providers.ViewInfo;
import org.eclipse.papyrus.diagram.common.util.PathsUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDTUtil {
    public static String EDITOR_VERSION = "org.eclipse.papyrus.diagram.common.Editor";
    private static final String[] getNameNames = new String[]{"getName", "getname"};
    private static final String LastOpenedDiagramPropertyBase = "lastOpenedDiagram";
    public static final QualifiedName LastOpenedDiagramProperty = new QualifiedName("org.eclipse.papyrus.diagram.common", "lastOpenedDiagram");
    public static final String FilterViewAndLabelsSource = "org.eclipse.papyrus.diagram.common.FilterViewsAndLabelsSource";

    public static void addDiagramVersion(Diagram diagram, String version) {
        if (version == null) {
            return;
        }
        EAnnotation eAnnotation = diagram.getEAnnotation(EDITOR_VERSION);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(EDITOR_VERSION);
            eAnnotation.getDetails().put((Object)"version", (Object)version);
            diagram.getEAnnotations().add((Object)eAnnotation);
        }
    }

    public static String getDiagramVersion(Diagram diagram) {
        EAnnotation eAnnotation = diagram.getEAnnotation(EDITOR_VERSION);
        if (eAnnotation == null) {
            return null;
        }
        return (String)eAnnotation.getDetails().get((Object)"version");
    }

    public static String getEditorVersion(IEditorPart editor) {
        return MDTUtil.getBundleVersion(editor.getSite().getPluginId());
    }

    public static String getBundleVersion(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return null;
        }
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        return version;
    }

    public static IPath getWorkspaceLocation() {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        catch (NullPointerException ex) {
            Status status = new Status(4, "org.eclipse.papyrus.diagram.common", "Error getting workspace", (Throwable)ex);
            Activator.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    public static String fullFilePathToResource(String filePath) {
        String workspaceLocation = MDTUtil.getWorkspaceLocation().toString();
        return filePath.replaceFirst(workspaceLocation, "");
    }

    public static URI fullFilePathToResourceURI(String filePath) {
        String uri = MDTUtil.fullFilePathToResource(filePath);
        return URI.createPlatformResourceURI((String)uri, (boolean)true);
    }

    public static String getDiagramName(Diagram diagram) {
        if (diagram != null) {
            String type = diagram.getType();
            String label = MOSKittEditorIDs.getExtensionsMapModelToLabel().get(type);
            label = label != null ? label : "";
            return String.valueOf(label) + " : " + diagram.getName();
        }
        return null;
    }

    public static Diagram getDiagramFomEditor(IEditorPart editor) {
        Object adapted;
        if (editor instanceof DiagramEditor) {
            return ((DiagramEditor)editor).getDiagram();
        }
        if (editor != null && (adapted = editor.getAdapter(Diagram.class)) instanceof Diagram) {
            return (Diagram)adapted;
        }
        return null;
    }

    public static IEditorPart getActiveEditor() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public static PreferencesHint getPreferencesHint(String kind) throws ExecutionException {
        String editor = MOSKittEditorIDs.getAllExtensionModelToEditor().get(kind);
        return new PreferencesHint(editor);
    }

    public static Map getSaveOptions() {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }

    public static Resource getRootElementResource(IEditorPart editorPart) {
        EObject rootElement = MDTUtil.getEditorRootelement(editorPart);
        Resource resource = null;
        if (rootElement != null) {
            resource = rootElement.eResource();
        }
        return resource;
    }

    public static EObject getEditorRootelement(IEditorPart editorPart) {
        EditPart rootEditPart = (EditPart)editorPart.getAdapter(EditPart.class);
        if (rootEditPart == null) {
            return null;
        }
        EObject rootElement = null;
        Object object = ((EditPart)rootEditPart.getChildren().get(0)).getModel();
        if (object instanceof View) {
            rootElement = ((View)object).getElement();
        }
        return rootElement;
    }

    public static Diagram getHostDiagram(EditPolicy policy) {
        if (policy.getHost() instanceof IGraphicalEditPart) {
            View view = ((IGraphicalEditPart)policy.getHost()).getNotationView();
            if (view != null) {
                view = view.getDiagram();
            }
            if (view instanceof Diagram) {
                return (Diagram)view;
            }
        }
        return null;
    }

    public static Diagram getDiagramFromRequest(IEditCommandRequest request) {
        Object data;
        Diagram diagram = null;
        if (request != null && (data = request.getParameters().get("es.cv.gvcase.mdt.uml2.diagram.common.Belongs_To_This_Diagram")) instanceof Diagram) {
            diagram = (Diagram)data;
        }
        return diagram;
    }

    public static List<EObject> getRootElementsFromFile(IEditorInput input) {
        return MDTUtil.getRootElementsFromFile(input, null);
    }

    public static List<EObject> getRootElementsFromFile(IEditorInput input, ResourceSet resourceSet) {
        Resource resource;
        URI uri = null;
        IURIEditorInput uriEditorInput = (IURIEditorInput)Platform.getAdapterManager().getAdapter((Object)input, IURIEditorInput.class);
        if (uriEditorInput != null) {
            uri = URI.createURI((String)uriEditorInput.getURI().toString());
        } else {
            IFileEditorInput fileEditorInput = (IFileEditorInput)Platform.getAdapterManager().getAdapter((Object)input, IFileEditorInput.class);
            if (fileEditorInput != null) {
                uri = URI.createURI((String)fileEditorInput.getFile().getLocationURI().toString());
            }
        }
        if (uri != null && (resource = (resourceSet = resourceSet != null ? resourceSet : new ResourceSetImpl()).getResource(uri, true)) != null) {
            ArrayList<EObject> rootEObjects = new ArrayList<EObject>();
            for (EObject eObject : resource.getContents()) {
                rootEObjects.add(eObject);
            }
            return rootEObjects;
        }
        return Collections.emptyList();
    }

    public static String getObjectNameOrEmptyString(Object object) {
        String name = MDTUtil.getObjectName(object);
        return name == null ? "" : name;
    }

    public static String getObjectName(Object object) {
        if (object == null) {
            return null;
        }
        Method method = null;
        Object o = null;
        String[] stringArray = getNameNames;
        int n = getNameNames.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            try {
                method = object.getClass().getMethod(methodName, null);
            }
            catch (NoSuchMethodException e) {
                method = null;
            }
            if (method != null) break;
            ++n2;
        }
        if (method != null) {
            try {
                o = method.invoke(object, null);
            }
            catch (IllegalAccessException ex) {
                return null;
            }
            catch (InvocationTargetException ex) {
                return null;
            }
            if (o instanceof String) {
                return (String)o;
            }
        }
        return null;
    }

    public static EObject resolveSemantic(Object object) {
        if (object instanceof EditPart) {
            object = ((EditPart)object).getModel();
        }
        if (object instanceof View) {
            object = ((View)object).getElement();
        }
        if (object instanceof EObject) {
            return (EObject)object;
        }
        return null;
    }

    public static QualifiedName getLastOpenedDiagramPropertyQualifiedNameForEditor(String editorID) {
        return new QualifiedName("org.eclipse.papyrus.diagram.common", LastOpenedDiagramPropertyBase + (editorID != null ? editorID : ""));
    }

    public static CachedResourcesDiagramEditor getCachedResourcesDiagramEditorFromEditorRef(IEditorReference reference) {
        if (reference == null) {
            return null;
        }
        IEditorPart part = reference.getEditor(false);
        if (part == null) {
            return null;
        }
        CachedResourcesDiagramEditor editor = (CachedResourcesDiagramEditor)((Object)Platform.getAdapterManager().getAdapter((Object)part, CachedResourcesDiagramEditor.class));
        if (editor != null) {
            return editor;
        }
        return null;
    }

    public static boolean setLastOpenedDiagramProperty(Diagram diagram) {
        return MDTUtil.setLastOpenedDiagramProperty(diagram, null);
    }

    public static boolean setLastOpenedDiagramProperty(Diagram diagram, String editorID) {
        return MDTUtil.setLastOpenedDiagramProperty(diagram, editorID, true);
    }

    public static boolean setLastOpenedDiagramProperty(Diagram diagram, String editorID, boolean setEditorForFileProperty) {
        if (editorID == null) {
            editorID = MOSKittEditorIDs.getAllExtensionModelToEditor().get(diagram.getType());
        }
        String fragment = diagram.eResource().getURIFragment((EObject)diagram);
        URI uri = diagram.eResource().getURI();
        uri = uri != null ? uri.trimFragment() : null;
        String path = PathsUtil.fromAbsoluteFileSystemToAbsoluteWorkspace(uri.toPlatformString(true));
        return MDTUtil.setLastOpenedDiagramProperty(path, fragment, editorID, setEditorForFileProperty);
    }

    public static boolean setLastOpenedDiagramProperty(String path, String fragment, String editorID, boolean setEditorForFileProperty) {
        Path filePath = new Path(path);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
        if (file != null) {
            try {
                QualifiedName propertyQualifiedName = MDTUtil.getLastOpenedDiagramPropertyQualifiedNameForEditor(editorID);
                file.setPersistentProperty(propertyQualifiedName, fragment);
                if (setEditorForFileProperty && editorID != null) {
                    MDTUtil.setEditorForDiagramProperty(file, editorID);
                }
                return true;
            }
            catch (CoreException ex) {
                Status status = new Status(2, "org.eclipse.papyrus.diagram.common", "Error setting file property");
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return false;
    }

    public static boolean removeLastOpenedDiagramProperty(Diagram diagram) {
        if (diagram == null || diagram.eResource() == null) {
            return false;
        }
        String fragment = diagram.eResource().getURIFragment((EObject)diagram);
        URI uri = diagram.eResource().getURI();
        uri = uri != null ? uri.trimFragment() : null;
        String path = PathsUtil.fromAbsoluteFileSystemToAbsoluteWorkspace(uri.toPlatformString(true));
        Path filePath = new Path(path);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
        if (file != null) {
            try {
                file.setPersistentProperty(LastOpenedDiagramProperty, null);
                Diagram firstDiagram = null;
                for (EObject elem : diagram.eResource().getContents()) {
                    if (!(elem instanceof Diagram)) continue;
                    firstDiagram = (Diagram)elem;
                    break;
                }
                String editorID = MOSKittEditorIDs.getAllExtensionModelToEditor().get(firstDiagram.getType());
                if (editorID != null) {
                    MDTUtil.setEditorForDiagramProperty(file, editorID);
                }
                return true;
            }
            catch (CoreException ex) {
                Status status = new Status(2, "org.eclipse.papyrus.diagram.common", "Error setting file property");
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return false;
    }

    public static void setEditorForDiagramProperty(URI uri, String editorID) {
        String part1 = uri.path().replaceFirst("resource", "");
        Path path = new Path(part1);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (file != null) {
            MDTUtil.setEditorForDiagramProperty(file, editorID);
        }
    }

    public static void setEditorForDiagramProperty(IFile file, String editorID) {
        if (file != null) {
            try {
                file.setPersistentProperty(IDE.EDITOR_KEY, editorID);
            }
            catch (CoreException ex) {
                Activator.getDefault().logError("Couldn't set file editorToOpen property", ex);
            }
            return;
        }
    }

    public static boolean removeEditorForDiagramProperty(URI uri) {
        String part1 = uri.path().replaceFirst("resource", "");
        Path path = new Path(part1);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (file != null) {
            return MDTUtil.removeEditorForDiagramProperty(file);
        }
        return false;
    }

    public static boolean removeEditorForDiagramProperty(IFile file) {
        try {
            file.setPersistentProperty(IDE.EDITOR_KEY, null);
            return true;
        }
        catch (CoreException ex) {
            return false;
        }
    }

    public static boolean setEditorForDiagramForFirstDiagram(Resource resource) {
        Diagram diagram = MDTUtil.getFirstDiagramFromResource(resource);
        if (diagram != null) {
            String kind = diagram.getType();
            String editorID = MOSKittEditorIDs.getAllExtensionModelToEditor().get(kind);
            if (editorID != null) {
                MDTUtil.setEditorForDiagramProperty(resource.getURI(), editorID);
            }
        }
        return false;
    }

    public static String getLastOpenedDiagramProperty(String filePath) {
        return MDTUtil.getLastOpenedDiagramPropertyForEditor(filePath, null);
    }

    public static String getLastOpenedDiagramPropertyForEditor(String filePath, String editorID) {
        if (filePath == null) {
            return null;
        }
        Path path = new Path(filePath);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (file != null) {
            try {
                return file.getPersistentProperty(MDTUtil.getLastOpenedDiagramPropertyQualifiedNameForEditor(editorID));
            }
            catch (CoreException ex) {
                Status status = new Status(2, "org.eclipse.papyrus.diagram.common", "Error retieving editor property: ", (Throwable)ex);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return null;
    }

    public static CachedResourcesEditorInput copyEditorInputButUri(IEditorInput input, URI uri) {
        CachedResourcesEditorInput cachedInput = new CachedResourcesEditorInput(uri, input.getName());
        if (input instanceof CachedResourcesEditorInput) {
            cachedInput.setUnload(((CachedResourcesEditorInput)input).isUnload());
        }
        return cachedInput;
    }

    public static CachedResourcesEditorInput getValidEditorInput(URI editorInput, String editorID) {
        URI uri;
        TransactionalEditingDomain domain;
        if (editorID != null && editorInput != null && (domain = EditingDomainRegistry.getInstance().get(editorID, editorInput.trimFragment().toString())) != null && (uri = MDTUtil.getProperDiagramURIToOpen(domain.getResourceSet(), editorInput)) != null) {
            return new CachedResourcesEditorInput(uri, false);
        }
        return null;
    }

    public static URI getProperDiagramURIToOpen(ResourceSet resourceSet, URI editorInput) {
        Diagram diagram;
        Diagram diagram2;
        EObject eObject = MDTUtil.searchEObjectFromFragment(editorInput, resourceSet);
        if (eObject != null && (diagram2 = (Diagram)Platform.getAdapterManager().getAdapter((Object)eObject, Diagram.class)) != null) {
            return diagram2.eResource().getURI().appendFragment(diagram2.eResource().getURIFragment((EObject)diagram2));
        }
        Resource resource = resourceSet.getResource(editorInput.trimFragment(), true);
        if (resource != null && (diagram = MDTUtil.getFirstDiagramFromResource(resource)) != null) {
            return resource.getURI().appendFragment(resource.getURIFragment((EObject)diagram));
        }
        return null;
    }

    public static EObject searchEObjectFromFragment(URI uri, ResourceSet resourceSet) {
        if (uri == null) {
            return null;
        }
        String uriFragment = uri.fragment();
        if (uriFragment != null && uriFragment.length() > 0 && resourceSet != null) {
            resourceSet.getResource(uri.trimFragment(), true);
            for (Resource resource : resourceSet.getResources()) {
                EObject eObject = MDTUtil.searchEObjectFromFragment(uriFragment, resource);
                if (eObject == null) continue;
                return eObject;
            }
        }
        return null;
    }

    public static EObject searchEObjectFromFragment(String uriFragment, Resource resource) {
        if (uriFragment != null && uriFragment.length() > 0 && resource != null) {
            return resource.getEObject(uriFragment);
        }
        return null;
    }

    public static Diagram getFirstDiagramFromResource(Resource resource) {
        if (resource != null && resource.getContents().size() > 0) {
            for (EObject eObject : resource.getContents()) {
                Diagram diagram = (Diagram)Platform.getAdapterManager().getAdapter((Object)eObject, Diagram.class);
                if (diagram == null) continue;
                return diagram;
            }
        }
        return null;
    }

    public static boolean isOfType(Class clazz, String className) {
        if (clazz == null || className == null) {
            return false;
        }
        if (clazz.getName().equals(className)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (MDTUtil.isOfType(c, className)) {
                return true;
            }
            ++n2;
        }
        return MDTUtil.isOfType(clazz.getSuperclass(), className);
    }

    public static List<EditPart> getEditPartsFromSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ArrayList<EditPart> editParts = new ArrayList<EditPart>();
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection.toList()) {
                if (!(object instanceof EditPart)) continue;
                editParts.add((EditPart)object);
            }
            return editParts;
        }
        return Collections.EMPTY_LIST;
    }

    public static List<EObject> getEObjectsFromSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ArrayList<EObject> eObjects = new ArrayList<EObject>();
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection.toList()) {
                EObject eObject = MDTUtil.resolveSemantic(object);
                if (eObject == null) continue;
                eObjects.add(eObject);
            }
            return eObjects;
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Diagram> getDiagramsInHierarchy(EObject eObject, Resource gmfResource) {
        if (eObject == null) {
            return Collections.EMPTY_LIST;
        }
        if (!(gmfResource instanceof GMFResource)) {
            ResourceSet resourceSet;
            Resource resource = eObject.eResource();
            ResourceSet resourceSet2 = resourceSet = resource != null ? resource.getResourceSet() : null;
            if (resourceSet != null) {
                for (Resource resourceAux : resourceSet.getResources()) {
                    if (!(resourceAux instanceof GMFResource)) continue;
                    gmfResource = resourceAux;
                    break;
                }
            }
        }
        if (!(gmfResource instanceof GMFResource)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        ArrayList<EObject> allEObjects = new ArrayList<EObject>();
        allEObjects.add(eObject);
        TreeIterator iterator = eObject.eAllContents();
        while (iterator.hasNext()) {
            allEObjects.add((EObject)iterator.next());
        }
        for (EObject element : allEObjects) {
            for (EObject content : gmfResource.getContents()) {
                if (!(content instanceof Diagram) || !element.equals(((Diagram)content).getElement())) continue;
                diagrams.add((Diagram)content);
            }
        }
        if (diagrams.size() > 0) {
            return diagrams;
        }
        return Collections.EMPTY_LIST;
    }

    public static void setElementsToFilterToDiagram(Diagram diagram, Collection<Integer> infos) {
        String key;
        if (diagram == null || infos == null) {
            return;
        }
        EAnnotation eAnnotation = diagram.getEAnnotation(FilterViewAndLabelsSource);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(FilterViewAndLabelsSource);
            diagram.getEAnnotations().add((Object)eAnnotation);
        }
        Collection<Integer> existing = MDTUtil.getAllViewsToFilterFromDiagram(diagram);
        ArrayList<Integer> toAdd = new ArrayList<Integer>();
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        for (Integer integer : infos) {
            if (existing.contains(integer)) continue;
            toAdd.add(integer);
        }
        for (Integer integer : existing) {
            if (infos.contains(integer)) continue;
            toDelete.add(integer);
        }
        for (Integer integer : toAdd) {
            key = String.valueOf(integer);
            if (eAnnotation.getDetails().containsKey((Object)key)) continue;
            eAnnotation.getDetails().put((Object)key, (Object)"");
        }
        for (Integer integer : toDelete) {
            key = String.valueOf(integer);
            if (!eAnnotation.getDetails().containsKey((Object)key)) continue;
            eAnnotation.getDetails().remove((Object)key);
        }
    }

    public static void removeElementToFilterFromDiagram(Diagram diagram, Collection<ViewInfo> infos) {
        if (diagram == null || infos == null || infos.size() <= 0) {
            return;
        }
        EAnnotation eAnnotation = diagram.getEAnnotation(FilterViewAndLabelsSource);
        if (eAnnotation == null) {
            return;
        }
        for (ViewInfo info : infos) {
            String key = String.valueOf(info.getVisualID());
            if (!eAnnotation.getDetails().containsKey((Object)key)) continue;
            eAnnotation.getDetails().removeKey((Object)key);
        }
    }

    public static Collection<Integer> getAllViewsToFilterFromDiagram(Diagram diagram) {
        EAnnotation eAnnotation = diagram.getEAnnotation(FilterViewAndLabelsSource);
        if (eAnnotation == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (String key : eAnnotation.getDetails().keySet()) {
            keys.add(Integer.valueOf(key));
        }
        return keys;
    }

    public static boolean findElementInDiagramFilter(Diagram diagram, int visualID) {
        if (diagram != null) {
            EAnnotation eAnnotation = diagram.getEAnnotation(FilterViewAndLabelsSource);
            if (eAnnotation == null) {
                return false;
            }
            String key = String.valueOf(visualID);
            return eAnnotation.getDetails().containsKey((Object)key);
        }
        return false;
    }

    public static void filterDiagramViews(Diagram diagram) {
        Collection<Integer> filters = MDTUtil.getAllViewsToFilterFromDiagram(diagram);
        TreeIterator it = diagram.eAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof View)) continue;
            View view = (View)eObject;
            Integer integer = null;
            try {
                integer = Integer.valueOf(view.getType());
            }
            catch (NumberFormatException ex) {
                integer = null;
            }
            if (integer == null) continue;
            SetRequest request = null;
            request = filters.contains(integer) ? new SetRequest((EObject)view, (EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible(), (Object)false) : new SetRequest((EObject)view, (EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible(), (Object)true);
            SetValueCommand command = new SetValueCommand(request);
            Object value = request.getValue();
            EObject elementToEdit = request.getElementToEdit();
            EStructuralFeature feature = request.getFeature();
            if (value == null || elementToEdit == null || feature == null || elementToEdit.eGet(feature) == null || value.equals(elementToEdit.eGet(feature))) continue;
            TransactionUtil.getEditingDomain((EObject)view).getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
        }
    }

    public static IStatusLineManager getStatusLineManager() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars().getStatusLineManager();
        }
        catch (NullPointerException ex) {
            return null;
        }
    }
}

