/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.diagram.common.util.MDTUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class PathsUtil {
    private static final Set<String> archiveSchemes;
    private static final String SCHEME_FILE = "file";
    private static final String SCHEME_JAR = "jar";
    private static final String SCHEME_ZIP = "zip";
    private static final String SCHEME_ARCHIVE = "archive";
    private static final String SCHEME_PLATFORM = "platform";
    private static final String[] PROTOCOLS;
    private static final String SCHEME_SEPARATOR = ":";
    private static final String AUTHORITY_SEPARATOR = "//";
    private static final String replacement = "";

    static {
        HashSet<String> set = new HashSet<String>();
        String propertyValue = System.getProperty("org.eclipse.emf.common.util.URI.archiveSchemes");
        if (propertyValue == null) {
            set.add(SCHEME_JAR);
            set.add(SCHEME_ZIP);
            set.add(SCHEME_ARCHIVE);
            set.add(SCHEME_FILE);
            set.add(SCHEME_PLATFORM);
        } else {
            StringTokenizer t = new StringTokenizer(propertyValue);
            while (t.hasMoreTokens()) {
                set.add(t.nextToken().toLowerCase());
            }
        }
        archiveSchemes = Collections.unmodifiableSet(set);
        PROTOCOLS = new String[]{"resource", "plugin"};
    }

    public static String fromAbsoluteFileSystemToAbsoluteWorkspace(String filesystemPath) {
        String workspacePath = PathsUtil.removeSchemas(filesystemPath);
        workspacePath = PathsUtil.removeWorkspace(workspacePath);
        workspacePath = PathsUtil.removeProtocols(workspacePath);
        workspacePath = PathsUtil.addRoot(workspacePath);
        return URI.decode((String)workspacePath);
    }

    public static String fromEditorInputToURIString(IEditorInput editorInput) {
        String uri = null;
        if (editorInput instanceof FileEditorInput) {
            uri = ((FileEditorInput)editorInput).getPath().toString();
            uri = MDTUtil.fullFilePathToResourceURI(uri).toString();
        } else if (editorInput instanceof URIEditorInput) {
            uri = ((URIEditorInput)editorInput).getURI().trimFragment().toString();
        }
        if (uri != null) {
            uri = PathsUtil.fromAbsoluteFileSystemToAbsoluteWorkspace(uri);
        }
        return uri;
    }

    public static String removeSchemas(String path) {
        if (path == null) {
            return path;
        }
        String newPath = path;
        for (String archiveSchema : archiveSchemes) {
            if (!newPath.startsWith(archiveSchema)) continue;
            newPath = newPath.replaceFirst(archiveSchema, replacement);
        }
        if (newPath.startsWith(SCHEME_SEPARATOR) && (newPath = newPath.replaceFirst(SCHEME_SEPARATOR, replacement)).startsWith(AUTHORITY_SEPARATOR)) {
            newPath = newPath.replaceFirst(AUTHORITY_SEPARATOR, replacement);
        }
        return newPath;
    }

    public static String removeWorkspace(String path) {
        if (path == null) {
            return path;
        }
        String newPath = path;
        if (newPath.startsWith(MDTUtil.getWorkspaceLocation().toString()) || newPath.startsWith("/" + MDTUtil.getWorkspaceLocation().toString())) {
            newPath = newPath.replaceFirst(MDTUtil.getWorkspaceLocation().toString(), replacement);
        }
        return newPath;
    }

    public static String removeProtocols(String path) {
        if (path == null) {
            return null;
        }
        String[] stringArray = PROTOCOLS;
        int n = PROTOCOLS.length;
        int n2 = 0;
        while (n2 < n) {
            String protocol = stringArray[n2];
            if (path.startsWith(protocol) || path.startsWith("/" + protocol)) {
                path = path.replaceFirst(protocol, replacement);
            }
            ++n2;
        }
        return path;
    }

    public static String addRoot(String path) {
        if (path == null) {
            return path;
        }
        String newPath = path;
        String rootPath = Path.ROOT.toString();
        while (newPath.startsWith(rootPath)) {
            newPath = newPath.replaceFirst(rootPath, replacement);
        }
        if (!newPath.startsWith(Path.ROOT.toString())) {
            newPath = String.valueOf(Path.ROOT.toString()) + newPath;
        }
        return newPath;
    }

    public static String getRelativeWorkspaceFromEditorInput(IEditorInput input) {
        if (input == null) {
            return null;
        }
        String uriString = null;
        if (input instanceof FileEditorInput) {
            uriString = ((FileEditorInput)input).getFile().getFullPath().toString();
        }
        if (input instanceof URIEditorInput) {
            uriString = ((URIEditorInput)input).getURI().trimFragment().toString();
        }
        if (uriString != null) {
            uriString = PathsUtil.fromAbsoluteFileSystemToAbsoluteWorkspace(uriString);
        }
        return uriString;
    }

    public static String getRelativeWorkspaceFromEditorInputWithFragment(IEditorInput input) {
        if (input == null) {
            return null;
        }
        String uriString = null;
        if (input instanceof FileEditorInput) {
            uriString = ((FileEditorInput)input).getURI().toString();
        }
        if (input instanceof URIEditorInput) {
            uriString = ((URIEditorInput)input).getURI().toString();
        }
        if (uriString != null) {
            uriString = PathsUtil.fromAbsoluteFileSystemToAbsoluteWorkspace(uriString);
        }
        return uriString;
    }
}

