/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.resource.NotFoundException;
import org.eclipse.papyrus.resource.uml.UmlModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class UMLSelectionTester
extends PropertyTester {
    public static final String IS_UML_MODEL = "isUMLModel";
    public static final String IS_UML_PROFILE = "isUMLProfile";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null || !(editor instanceof PapyrusMultiDiagramEditor)) {
            return false;
        }
        Boolean currentValue = null;
        if (IS_UML_MODEL.equals(property)) {
            currentValue = this.testUMLModelNature(receiver);
            return currentValue == expectedValue;
        }
        if (IS_UML_PROFILE.equals(property)) {
            currentValue = this.testUMLProfileNature(receiver);
            return currentValue == expectedValue;
        }
        return false;
    }

    protected boolean testUMLModelNature(Object receiver) {
        EObject root = this.getRoot();
        return root instanceof Package && !(root instanceof Profile);
    }

    protected boolean testUMLProfileNature(Object receiver) {
        return this.getRoot() instanceof Profile;
    }

    private EObject getRoot() {
        EObject root = null;
        try {
            ServiceUtilsForActionHandlers serviceUtils = new ServiceUtilsForActionHandlers();
            UmlModel openedModel = (UmlModel)serviceUtils.getModelSet().getModel("org.eclipse.papyrus.resource.uml.UmlModel");
            if (openedModel != null) {
                root = openedModel.lookupRoot();
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        return root;
    }
}

