/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PackageImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Visitor {
    public static List<Element> getOwnedAndImportedElement(Namespace visited, Class<?> wantedClass) {
        ArrayList<Element> visibleElements = new ArrayList<Element>();
        for (ElementImport eImport : visited.getElementImports()) {
            if (!wantedClass.isInstance(eImport)) continue;
            visibleElements.add((Element)eImport.getImportedElement());
        }
        for (NamedElement n : visited.getOwnedMembers()) {
            if (wantedClass.isInstance(n)) {
                visibleElements.add((Element)n);
            }
            if (!(n instanceof Namespace)) continue;
            visibleElements.addAll(Visitor.getOwnedAndImportedElement((Namespace)n, wantedClass));
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain(wantedClass);
        return visibleElements;
    }

    public static List<Namespace> getImportedNamespaces(Namespace visited) {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (PackageImport pImport : visited.getPackageImports()) {
            namespaces.add((Namespace)pImport.getImportedPackage());
        }
        for (ElementImport eImport : visited.getElementImports()) {
            if (!(eImport.getImportedElement() instanceof Namespace)) continue;
            namespaces.add((Namespace)eImport.getImportedElement());
        }
        return namespaces;
    }

    public static List<Namespace> getOwnedAndImportedNamespaces(Namespace visited) {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        namespaces.addAll(Visitor.getImportedNamespaces(visited));
        for (NamedElement n : visited.getOwnedMembers()) {
            if (!(n instanceof Namespace)) continue;
            namespaces.add((Namespace)n);
        }
        return namespaces;
    }
}

