/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.component.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.providers.BaseViewInfo;
import org.eclipse.papyrus.diagram.common.providers.ViewInfo;
import org.eclipse.papyrus.diagram.component.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.diagram.component/debug/visualID";
    private static ViewInfo diagramViewInfo = null;

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLComponentDiagram".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLComponentDiagram".equals(containerModelID)) {
            return -1;
        }
        if ("PapyrusUMLComponentDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3200;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3201;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3199;
            }
            case 2002: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3070: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3071: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 7001: {
                if (!UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 3070;
            }
            case 7002: {
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (!UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 3071;
            }
            case 7003: {
                if (!UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 3070;
            }
            case 7004: {
                if (!UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 3070;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLComponentDiagram".equals(containerModelID)) {
            return false;
        }
        if ("PapyrusUMLComponentDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (3200 == nodeVisualID) {
                    return true;
                }
                if (3201 == nodeVisualID) {
                    return true;
                }
                if (3199 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5005 != nodeVisualID) break;
                return true;
            }
            case 3200: {
                if (5254 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 3201: {
                if (5255 != nodeVisualID) break;
                return true;
            }
            case 3199: {
                if (5252 == nodeVisualID) {
                    return true;
                }
                if (5253 != nodeVisualID) break;
                return true;
            }
            case 3069: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (5007 != nodeVisualID) break;
                return true;
            }
            case 3070: {
                if (5256 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3071: {
                if (5257 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3072: {
                if (nodeVisualID != 0) break;
                return true;
            }
            case 3074: {
                if (5258 != nodeVisualID) break;
                return true;
            }
            case 3075: {
                if (5259 == nodeVisualID) {
                    return true;
                }
                if (5260 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3070 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3071 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3070 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3070 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (2 != nodeVisualID) break;
                return true;
            }
            case 4012: {
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6020 != nodeVisualID) break;
                return true;
            }
            case 4014: {
                if (6008 == nodeVisualID) {
                    return true;
                }
                if (6022 != nodeVisualID) break;
                return true;
            }
            case 4007: {
                if (3 == nodeVisualID) {
                    return true;
                }
                if (4 != nodeVisualID) break;
                return true;
            }
            case 4013: {
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6021 != nodeVisualID) break;
                return true;
            }
            case 4010: {
                if (6009 == nodeVisualID) {
                    return true;
                }
                if (6023 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getUsage().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getInterfaceRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4006;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        if (UMLPackage.eINSTANCE.getSubstitution().isSuperTypeOf(domainElement.eClass())) {
            return 4012;
        }
        if (UMLPackage.eINSTANCE.getManifestation().isSuperTypeOf(domainElement.eClass())) {
            return 4014;
        }
        if (UMLPackage.eINSTANCE.getComponentRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4007;
        }
        if (UMLPackage.eINSTANCE.getAbstraction().isSuperTypeOf(domainElement.eClass())) {
            return 4013;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return 4010;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    public static ViewInfo getDiagramViewInfo() {
        if (diagramViewInfo == null) {
            diagramViewInfo = UMLVisualIDRegistry.getPackage_1000ViewInfo();
        }
        return diagramViewInfo;
    }

    protected static ViewInfo getPackage_1000ViewInfo() {
        BaseViewInfo root = new BaseViewInfo(1000, 0, "", null, null);
        BaseViewInfo viewInfo = null;
        BaseViewInfo labelInfo = null;
        viewInfo = new BaseViewInfo(2002, 2, "Component");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2003, 2, "Interface");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3200, 2, "Package");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3201, 2, "Comment");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3199, 2, "Constraint");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4001, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4006, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4003, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(2, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4012, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6006, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6020, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4014, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6008, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6022, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4007, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(3, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(4, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4013, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6007, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6021, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4016, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4015, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4009, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4010, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6009, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6023, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(3069, 2, "Port");
        root.addNode(2002, (ViewInfo)viewInfo);
        root.addNode(3070, (ViewInfo)viewInfo);
        root.addNode(3071, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3070, 2, "Component");
        root.addNode(7003, (ViewInfo)viewInfo);
        root.addNode(7004, (ViewInfo)viewInfo);
        root.addNode(7001, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3071, 2, "Component");
        root.addNode(7002, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3072, 2, "Interface");
        root.addNode(7002, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3074, 2, "Comment");
        root.addNode(7002, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3075, 2, "Constraint");
        root.addNode(7002, (ViewInfo)viewInfo);
        return root;
    }
}

