/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.component.providers;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.diagram.component.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLElementTypes {
    private static Map<IElementType, ENamedElement> elements;
    private static ImageRegistry imageRegistry;
    private static Set<IElementType> KNOWN_ELEMENT_TYPES;
    public static final IElementType Package_1000;
    public static final IElementType Component_2002;
    public static final IElementType Interface_2003;
    public static final IElementType Package_3200;
    public static final IElementType Comment_3201;
    public static final IElementType Constraint_3199;
    public static final IElementType Port_3069;
    public static final IElementType Component_3070;
    public static final IElementType Component_3071;
    public static final IElementType Interface_3072;
    public static final IElementType Comment_3074;
    public static final IElementType Constraint_3075;
    public static final IElementType Usage_4001;
    public static final IElementType InterfaceRealization_4006;
    public static final IElementType Generalization_4003;
    public static final IElementType Substitution_4012;
    public static final IElementType Manifestation_4014;
    public static final IElementType ComponentRealization_4007;
    public static final IElementType Abstraction_4013;
    public static final IElementType Link_4016;
    public static final IElementType CommentAnnotatedElement_4015;
    public static final IElementType ConstraintConstrainedElement_4009;
    public static final IElementType Dependency_4010;

    static {
        Package_1000 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Model_1000");
        Component_2002 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Component_2002");
        Interface_2003 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Interface_2003");
        Package_3200 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Package_3200");
        Comment_3201 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Comment_3201");
        Constraint_3199 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Comment_3199");
        Port_3069 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Port_3069");
        Component_3070 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Component_3070");
        Component_3071 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Component_3071");
        Interface_3072 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Interface_3072");
        Comment_3074 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Comment_3074");
        Constraint_3075 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Constraint_3075");
        Usage_4001 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Usage_4001");
        InterfaceRealization_4006 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.InterfaceRealization_4006");
        Generalization_4003 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Generalization_4003");
        Substitution_4012 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Substitution_4012");
        Manifestation_4014 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Manifestation_4014");
        ComponentRealization_4007 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.ComponentRealization_4007");
        Abstraction_4013 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Abstraction_4013");
        Link_4016 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Link_4016");
        CommentAnnotatedElement_4015 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.CommentAnnotatedElement_4008");
        ConstraintConstrainedElement_4009 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.ConstraintConstrainedElement_4009");
        Dependency_4010 = UMLElementTypes.getElementType("org.eclipse.papyrus.diagram.component.Dependency_4010");
    }

    private UMLElementTypes() {
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static String getImageRegistryKey(ENamedElement element) {
        return element.getName();
    }

    private static ImageDescriptor getProvidedImageDescriptor(ENamedElement element) {
        EClass eClass;
        if (element instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EClass eContainingClass = feature.getEContainingClass();
            EClassifier eType = feature.getEType();
            if (eContainingClass != null && !eContainingClass.isAbstract()) {
                element = eContainingClass;
            } else if (eType instanceof EClass && !((EClass)eType).isAbstract()) {
                element = eType;
            }
        }
        if (element instanceof EClass && !(eClass = (EClass)element).isAbstract()) {
            return UMLDiagramEditorPlugin.getInstance().getItemImageDescriptor(eClass.getEPackage().getEFactoryInstance().create(eClass));
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(ENamedElement element) {
        String key = UMLElementTypes.getImageRegistryKey(element);
        ImageDescriptor imageDescriptor = UMLElementTypes.getImageRegistry().getDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = UMLElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            UMLElementTypes.getImageRegistry().put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Image getImage(ENamedElement element) {
        String key = UMLElementTypes.getImageRegistryKey(element);
        Image image = UMLElementTypes.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor imageDescriptor = UMLElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            UMLElementTypes.getImageRegistry().put(key, imageDescriptor);
            image = UMLElementTypes.getImageRegistry().get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(IAdaptable hint) {
        ENamedElement element = UMLElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return UMLElementTypes.getImageDescriptor(element);
    }

    public static Image getImage(IAdaptable hint) {
        ENamedElement element = UMLElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return UMLElementTypes.getImage(element);
    }

    public static ENamedElement getElement(IAdaptable hint) {
        Object type = hint.getAdapter(IElementType.class);
        if (elements == null) {
            elements = new IdentityHashMap<IElementType, ENamedElement>();
            elements.put(Package_1000, (ENamedElement)UMLPackage.eINSTANCE.getPackage());
            elements.put(Component_2002, (ENamedElement)UMLPackage.eINSTANCE.getComponent());
            elements.put(Interface_2003, (ENamedElement)UMLPackage.eINSTANCE.getInterface());
            elements.put(Package_3200, (ENamedElement)UMLPackage.eINSTANCE.getPackage());
            elements.put(Comment_3201, (ENamedElement)UMLPackage.eINSTANCE.getComment());
            elements.put(Constraint_3199, (ENamedElement)UMLPackage.eINSTANCE.getConstraint());
            elements.put(Port_3069, (ENamedElement)UMLPackage.eINSTANCE.getPort());
            elements.put(Component_3070, (ENamedElement)UMLPackage.eINSTANCE.getComponent());
            elements.put(Component_3071, (ENamedElement)UMLPackage.eINSTANCE.getComponent());
            elements.put(Interface_3072, (ENamedElement)UMLPackage.eINSTANCE.getInterface());
            elements.put(Comment_3074, (ENamedElement)UMLPackage.eINSTANCE.getComment());
            elements.put(Constraint_3075, (ENamedElement)UMLPackage.eINSTANCE.getConstraint());
            elements.put(Usage_4001, (ENamedElement)UMLPackage.eINSTANCE.getUsage());
            elements.put(InterfaceRealization_4006, (ENamedElement)UMLPackage.eINSTANCE.getInterfaceRealization());
            elements.put(Generalization_4003, (ENamedElement)UMLPackage.eINSTANCE.getGeneralization());
            elements.put(Substitution_4012, (ENamedElement)UMLPackage.eINSTANCE.getSubstitution());
            elements.put(Manifestation_4014, (ENamedElement)UMLPackage.eINSTANCE.getManifestation());
            elements.put(ComponentRealization_4007, (ENamedElement)UMLPackage.eINSTANCE.getComponentRealization());
            elements.put(Abstraction_4013, (ENamedElement)UMLPackage.eINSTANCE.getAbstraction());
            elements.put(CommentAnnotatedElement_4015, (ENamedElement)UMLPackage.eINSTANCE.getComment_AnnotatedElement());
            elements.put(ConstraintConstrainedElement_4009, (ENamedElement)UMLPackage.eINSTANCE.getConstraint_ConstrainedElement());
            elements.put(Dependency_4010, (ENamedElement)UMLPackage.eINSTANCE.getDependency());
        }
        return elements.get(type);
    }

    private static IElementType getElementType(String id) {
        return ElementTypeRegistry.getInstance().getType(id);
    }

    public static boolean isKnownElementType(IElementType elementType) {
        if (KNOWN_ELEMENT_TYPES == null) {
            KNOWN_ELEMENT_TYPES = new HashSet<IElementType>();
            KNOWN_ELEMENT_TYPES.add(Package_1000);
            KNOWN_ELEMENT_TYPES.add(Component_2002);
            KNOWN_ELEMENT_TYPES.add(Interface_2003);
            KNOWN_ELEMENT_TYPES.add(Package_3200);
            KNOWN_ELEMENT_TYPES.add(Comment_3201);
            KNOWN_ELEMENT_TYPES.add(Constraint_3199);
            KNOWN_ELEMENT_TYPES.add(Port_3069);
            KNOWN_ELEMENT_TYPES.add(Component_3070);
            KNOWN_ELEMENT_TYPES.add(Component_3071);
            KNOWN_ELEMENT_TYPES.add(Interface_3072);
            KNOWN_ELEMENT_TYPES.add(Comment_3074);
            KNOWN_ELEMENT_TYPES.add(Constraint_3075);
            KNOWN_ELEMENT_TYPES.add(Usage_4001);
            KNOWN_ELEMENT_TYPES.add(InterfaceRealization_4006);
            KNOWN_ELEMENT_TYPES.add(Generalization_4003);
            KNOWN_ELEMENT_TYPES.add(Substitution_4012);
            KNOWN_ELEMENT_TYPES.add(Manifestation_4014);
            KNOWN_ELEMENT_TYPES.add(ComponentRealization_4007);
            KNOWN_ELEMENT_TYPES.add(Abstraction_4013);
            KNOWN_ELEMENT_TYPES.add(Link_4016);
            KNOWN_ELEMENT_TYPES.add(CommentAnnotatedElement_4015);
            KNOWN_ELEMENT_TYPES.add(ConstraintConstrainedElement_4009);
            KNOWN_ELEMENT_TYPES.add(Dependency_4010);
        }
        return KNOWN_ELEMENT_TYPES.contains(elementType);
    }

    public static IElementType getElementType(int visualID) {
        switch (visualID) {
            case 1000: {
                return Package_1000;
            }
            case 2002: {
                return Component_2002;
            }
            case 2003: {
                return Interface_2003;
            }
            case 3200: {
                return Package_3200;
            }
            case 3201: {
                return Comment_3201;
            }
            case 3199: {
                return Constraint_3199;
            }
            case 3069: {
                return Port_3069;
            }
            case 3070: {
                return Component_3070;
            }
            case 3071: {
                return Component_3071;
            }
            case 3072: {
                return Interface_3072;
            }
            case 3074: {
                return Comment_3074;
            }
            case 3075: {
                return Constraint_3075;
            }
            case 4001: {
                return Usage_4001;
            }
            case 4006: {
                return InterfaceRealization_4006;
            }
            case 4003: {
                return Generalization_4003;
            }
            case 4012: {
                return Substitution_4012;
            }
            case 4014: {
                return Manifestation_4014;
            }
            case 4007: {
                return ComponentRealization_4007;
            }
            case 4013: {
                return Abstraction_4013;
            }
            case 4016: {
                return Link_4016;
            }
            case 4015: {
                return CommentAnnotatedElement_4015;
            }
            case 4009: {
                return ConstraintConstrainedElement_4009;
            }
            case 4010: {
                return Dependency_4010;
            }
        }
        return null;
    }
}

