/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.composite.custom.helper.advice;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.diagram.composite.custom.utils.GeneralizationUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralizationHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeReorientRelationshipCommand(ReorientRelationshipRequest request) {
        HashSet<View> viewsToDestroy = new HashSet<View>();
        if (request.getRelationship() instanceof Generalization) {
            viewsToDestroy.addAll(this.getMemberViewsToDestroy((Generalization)request.getRelationship()));
        }
        if (!viewsToDestroy.isEmpty()) {
            DestroyDependentsRequest ddr = new DestroyDependentsRequest(request.getEditingDomain(), request.getRelationship(), false);
            return ddr.getDestroyDependentsCommand(viewsToDestroy);
        }
        return null;
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        EObject destructee = request.getElementToDestroy();
        Set<Object> viewsToDestroy = new HashSet();
        if (destructee instanceof Generalization) {
            viewsToDestroy = this.getMemberViewsToDestroy((Generalization)destructee);
        }
        if (!viewsToDestroy.isEmpty()) {
            return request.getDestroyDependentsCommand(viewsToDestroy);
        }
        return null;
    }

    protected Set<View> getMemberViewsToDestroy(Generalization generalization) {
        HashSet<View> viewsToDestroy = new HashSet<View>();
        Classifier general = generalization.getGeneral();
        if (general != null) {
            EList members = general.getMembers();
            for (NamedElement member : members) {
                Iterator viewIt = CrossReferencerUtil.getCrossReferencingViews((EObject)member, (String)"CompositeStructure").iterator();
                while (viewIt.hasNext()) {
                    GeneralizationUtil util = new GeneralizationUtil();
                    View view = (View)viewIt.next();
                    if (!util.isConcernedByGeneralizationChanges(generalization, view)) continue;
                    viewsToDestroy.add(view);
                }
            }
        }
        return viewsToDestroy;
    }
}

