/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.deployment.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.papyrus.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ArtifactCompositeCompartmentEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ArtifactCompositeCompartmentEditPartACN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ArtifactCompositeCompartmentEditPartCN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ArtifactEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ArtifactEditPartACN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ArtifactEditPartCN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ArtifactNameEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ArtifactNameEditPartACN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ArtifactNameEditPartCN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.CommentAnnotatedElementEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.CommentBodyEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.CommentEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ConstraintConstrainedElementEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ConstraintEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ConstraintNameEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ConstraintSpecificationEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DependencyAppliedStereotypeEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DependencyEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DependencyNameEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DeploymentAppliedStereotypeEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DeploymentDiagramEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DeploymentEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DeploymentNameEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DeviceCompositeCompartmentEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DeviceCompositeCompartmentEditPartCN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DeviceEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DeviceEditPartCN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DeviceNameEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.DeviceNameEditPartCN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ExecutionEnvironmentCompositeCompartmentEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ExecutionEnvironmentCompositeCompartmentEditPartCN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ExecutionEnvironmentEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ExecutionEnvironmentEditPartCN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ExecutionEnvironmentNameEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ExecutionEnvironmentNameEditPartCN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.GeneralizationAppliedStereotypeEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.GeneralizationEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.LinkDescriptorEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ManifestationAppliedStereotypeEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ManifestationEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.ManifestationNameEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.NodeCompositeCompartmentEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.NodeCompositeCompartmentEditPartCN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.NodeEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.NodeEditPartCN;
import org.eclipse.papyrus.diagram.deployment.edit.parts.NodeNameEditPart;
import org.eclipse.papyrus.diagram.deployment.edit.parts.NodeNameEditPartCN;
import org.eclipse.papyrus.diagram.deployment.part.UMLVisualIDRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class UMLEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof View) {
            View view = (View)model;
            switch (UMLVisualIDRegistry.getVisualID(view)) {
                case 1000: {
                    return new DeploymentDiagramEditPart(view);
                }
                case 2001: {
                    return new CommentEditPart(view);
                }
                case 1: {
                    return new CommentBodyEditPart(view);
                }
                case 2005: {
                    return new ConstraintEditPart(view);
                }
                case 2: {
                    return new ConstraintNameEditPart(view);
                }
                case 3: {
                    return new ConstraintSpecificationEditPart(view);
                }
                case 2002: {
                    return new ExecutionEnvironmentEditPart(view);
                }
                case 5: {
                    return new ExecutionEnvironmentNameEditPart(view);
                }
                case 2003: {
                    return new DeviceEditPart(view);
                }
                case 6: {
                    return new DeviceNameEditPart(view);
                }
                case 2006: {
                    return new ArtifactEditPart(view);
                }
                case 8: {
                    return new ArtifactNameEditPart(view);
                }
                case 2008: {
                    return new NodeEditPart(view);
                }
                case 9: {
                    return new NodeNameEditPart(view);
                }
                case 23: {
                    return new NodeEditPartCN(view);
                }
                case 24: {
                    return new NodeNameEditPartCN(view);
                }
                case 16: {
                    return new DeviceEditPartCN(view);
                }
                case 20: {
                    return new DeviceNameEditPartCN(view);
                }
                case 21: {
                    return new ExecutionEnvironmentEditPartCN(view);
                }
                case 22: {
                    return new ExecutionEnvironmentNameEditPartCN(view);
                }
                case 25: {
                    return new ArtifactEditPartCN(view);
                }
                case 27: {
                    return new ArtifactNameEditPartCN(view);
                }
                case 28: {
                    return new ArtifactEditPartACN(view);
                }
                case 29: {
                    return new ArtifactNameEditPartACN(view);
                }
                case 17: {
                    return new DeviceCompositeCompartmentEditPart(view);
                }
                case 18: {
                    return new ExecutionEnvironmentCompositeCompartmentEditPart(view);
                }
                case 19: {
                    return new NodeCompositeCompartmentEditPart(view);
                }
                case 26: {
                    return new ArtifactCompositeCompartmentEditPart(view);
                }
                case 30: {
                    return new DeviceCompositeCompartmentEditPartCN(view);
                }
                case 31: {
                    return new ExecutionEnvironmentCompositeCompartmentEditPartCN(view);
                }
                case 32: {
                    return new NodeCompositeCompartmentEditPartCN(view);
                }
                case 33: {
                    return new ArtifactCompositeCompartmentEditPartCN(view);
                }
                case 34: {
                    return new ArtifactCompositeCompartmentEditPartACN(view);
                }
                case 4005: {
                    return new LinkDescriptorEditPart(view);
                }
                case 4008: {
                    return new CommentAnnotatedElementEditPart(view);
                }
                case 4009: {
                    return new ConstraintConstrainedElementEditPart(view);
                }
                case 4001: {
                    return new DeploymentEditPart(view);
                }
                case 13: {
                    return new DeploymentNameEditPart(view);
                }
                case 14: {
                    return new DeploymentAppliedStereotypeEditPart(view);
                }
                case 4002: {
                    return new ManifestationEditPart(view);
                }
                case 10: {
                    return new ManifestationNameEditPart(view);
                }
                case 11: {
                    return new ManifestationAppliedStereotypeEditPart(view);
                }
                case 4003: {
                    return new GeneralizationEditPart(view);
                }
                case 4: {
                    return new GeneralizationAppliedStereotypeEditPart(view);
                }
                case 4004: {
                    return new DependencyEditPart(view);
                }
                case 12: {
                    return new DependencyNameEditPart(view);
                }
                case 15: {
                    return new DependencyAppliedStereotypeEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(context, model);
    }

    private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof IMultilineEditableFigure) {
            return new MultilineCellEditorLocator((IMultilineEditableFigure)source.getFigure());
        }
        if (source.getFigure() instanceof WrappingLabel) {
            return new TextCellEditorLocator((WrappingLabel)source.getFigure());
        }
        return new LabelCellEditorLocator((Label)source.getFigure());
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            if (!text.getFont().isDisposed()) {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class MultilineCellEditorLocator
    implements CellEditorLocator {
        private IMultilineEditableFigure multilineEditableFigure;

        public MultilineCellEditorLocator(IMultilineEditableFigure figure) {
            this.multilineEditableFigure = figure;
        }

        public IMultilineEditableFigure getMultilineEditableFigure() {
            return this.multilineEditableFigure;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getMultilineEditableFigure().getBounds().getCopy();
            rect.x = this.getMultilineEditableFigure().getEditionLocation().x;
            rect.y = this.getMultilineEditableFigure().getEditionLocation().y;
            this.getMultilineEditableFigure().translateToAbsolute((Translatable)rect);
            if (this.getMultilineEditableFigure().getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrappingLabel wrapLabel;

        public TextCellEditorLocator(WrappingLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrappingLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (!text.getFont().isDisposed()) {
                if (this.getWrapLabel().isTextWrapOn() && this.getWrapLabel().getText().length() > 0) {
                    rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
                } else {
                    int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                    rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
                }
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

