/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.profile.custom.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.diagram.profile.custom.helper.ExtensionHelper;
import org.eclipse.papyrus.diagram.profile.custom.policies.CUMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.diagram.profile.edit.commands.ExtensionCreateCommand;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class CustomExtensionCreateCommand
extends ExtensionCreateCommand {
    private final EObject source;
    private final EObject target;
    protected Property sourcePartWithPort = null;

    public CustomExtensionCreateCommand(CreateRelationshipRequest req, EObject source, EObject target) {
        super(req, source, target);
        this.source = source;
        this.target = target;
        if (req.getParameter("SOURCE_PARENT") instanceof Property) {
            this.sourcePartWithPort = (Property)req.getParameter("SOURCE_PARENT");
        }
    }

    protected Stereotype _getSource() {
        return (Stereotype)this.source;
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof Stereotype)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Class)) {
            return false;
        }
        if (this._getSource() == null) {
            return true;
        }
        return CUMLBaseItemSemanticEditPolicy.LinkConstraints.canCreateExtension_1013(this.getContainer(), this._getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        Extension newExtension = UMLFactory.eINSTANCE.createExtension();
        ExtensionEnd endSource = UMLFactory.eINSTANCE.createExtensionEnd();
        if (!(this._getSource() instanceof Stereotype)) {
            throw new ExecutionException("Invalid source in create Connector command");
        }
        endSource.setName(String.valueOf("Extension_".replaceFirst("E", "e")) + this._getSource().getName());
        endSource.setType((Type)this._getSource());
        endSource.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        newExtension.getOwnedEnds().add((Object)endSource);
        Property property = UMLFactory.eINSTANCE.createProperty();
        property.setName("base_" + this.getTarget().getName());
        property.setType((Type)this.getTarget());
        property.setAssociation((Association)newExtension);
        property.setAggregation(AggregationKind.NONE_LITERAL);
        newExtension.getMemberEnds().add((Object)property);
        this._getSource().getOwnedAttributes().add((Object)property);
        this.doConfigure(newExtension, monitor, info);
        this.getContainer().getPackagedElements().add((Object)newExtension);
        newExtension.setName(ExtensionHelper.getExtensionName((Element)this.getContainer(), this._getSource(), this.getTarget()));
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newExtension);
        return CommandResult.newOKCommandResult((Object)newExtension);
    }

    protected void doConfigure(Extension newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this._getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

