/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.profile.custom.edit.parts;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.editparts.UMLConnectionNodeEditPart;
import org.eclipse.papyrus.diagram.profile.custom.figure.AssociationFigure;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public abstract class AbstractAssociationEditPart
extends UMLConnectionNodeEditPart {
    protected static final String ASSOCIATION_END_LISTENERS_SOURCE = "AssociationEndListenersSource";
    protected static final String ASSOCIATION_END_LISTENERS_TARGET = "AssociationEndListenersTarget";

    public AbstractAssociationEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
        this.addAssociationEndListeners();
    }

    protected void addAssociationEndListeners() {
        Association association;
        EObject semanticElement = this.resolveSemanticElement();
        if (semanticElement instanceof Association && (association = (Association)semanticElement).getMemberEnds().size() >= 2) {
            EObject sourceEnd = (EObject)association.getMemberEnds().get(0);
            EObject targetEnd = (EObject)association.getMemberEnds().get(1);
            this.addListenerFilter(ASSOCIATION_END_LISTENERS_SOURCE, (NotificationListener)this, sourceEnd);
            this.addListenerFilter(ASSOCIATION_END_LISTENERS_TARGET, (NotificationListener)this, targetEnd);
        }
    }

    public void deactivate() {
        this.removeAssociationEndListeners();
        super.deactivate();
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.resolveSemanticElement() != null) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        if (this.resolveSemanticElement() != null) {
            if (this.getSource() == null || this.getTarget() == null) {
                return;
            }
            if (((GraphicalEditPart)this.getSource()).resolveSemanticElement() == null || ((GraphicalEditPart)this.getTarget()).resolveSemanticElement() == null) {
                return;
            }
            Property source = null;
            Property target = null;
            Element umlElement = this.getUMLElement();
            if (umlElement instanceof Association) {
                Association association = (Association)this.getUMLElement();
                assert (association.getMemberEnds().size() >= 2);
                if (association.getMemberEnds() != null && association.getMemberEnds().size() >= 2) {
                    if (((Property)association.getMemberEnds().get(0)).getType().equals(((GraphicalEditPart)this.getSource()).resolveSemanticElement())) {
                        source = (Property)association.getMemberEnds().get(0);
                        target = (Property)association.getMemberEnds().get(1);
                    } else {
                        source = (Property)association.getMemberEnds().get(1);
                        target = (Property)association.getMemberEnds().get(0);
                    }
                    int sourceType = 0;
                    int targetType = 0;
                    if (!source.getOwner().equals(this.resolveSemanticElement())) {
                        sourceType += 8;
                        ++sourceType;
                    }
                    if (!target.getOwner().equals(this.resolveSemanticElement())) {
                        targetType += 8;
                        ++targetType;
                    }
                    if (source.getAggregation() == AggregationKind.SHARED_LITERAL) {
                        targetType += 2;
                    }
                    if (target.getAggregation() == AggregationKind.SHARED_LITERAL) {
                        sourceType += 2;
                    }
                    if (source.getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
                        targetType += 4;
                    }
                    if (target.getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
                        sourceType += 4;
                    }
                    if (association.getNavigableOwnedEnds().contains((Object)source)) {
                        ++sourceType;
                    }
                    if (association.getNavigableOwnedEnds().contains((Object)target)) {
                        ++targetType;
                    }
                    if (this.getPrimaryShape() instanceof AssociationFigure) {
                        ((AssociationFigure)this.getPrimaryShape()).setEnd(sourceType, targetType);
                    }
                }
            }
        }
        super.refreshVisuals();
    }

    protected void removeAssociationEndListeners() {
        this.removeListenerFilter(ASSOCIATION_END_LISTENERS_SOURCE);
        this.removeListenerFilter(ASSOCIATION_END_LISTENERS_TARGET);
    }
}

