/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.profile.custom.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.diagram.common.figure.edge.UMLEdgeFigure;

public class AssociationFigure
extends UMLEdgeFigure {
    public static final int aggregation = 2;
    public static final int composition = 4;
    public static final int navigable = 1;
    public static final int owned = 8;
    private WrappingLabel fAssociationNameLabel;
    private WrappingLabel fMultiplicitySourceLabel;
    private WrappingLabel fMultiplicityTargetLabel;
    private WrappingLabel fRoleSourceLabel;
    private WrappingLabel fRoleTargetLabel;

    public AssociationFigure() {
        this.setAntialias(1);
        this.createContents();
    }

    public AssociationFigure(int sourceType, int targetType) {
        this.setEnd(sourceType, targetType);
        this.createContents();
    }

    protected void createContents() {
        super.createContents();
        this.fAssociationNameLabel = new WrappingLabel();
        this.fAssociationNameLabel.setText("");
        this.add((IFigure)this.fAssociationNameLabel);
        this.fRoleSourceLabel = new WrappingLabel();
        this.fRoleSourceLabel.setText("");
        this.add((IFigure)this.fRoleSourceLabel);
        this.fMultiplicitySourceLabel = new WrappingLabel();
        this.fMultiplicitySourceLabel.setText("");
        this.add((IFigure)this.fMultiplicitySourceLabel);
        this.fRoleTargetLabel = new WrappingLabel();
        this.fRoleTargetLabel.setText("");
        this.add((IFigure)this.fRoleTargetLabel);
        this.fMultiplicityTargetLabel = new WrappingLabel();
        this.fMultiplicityTargetLabel.setText("");
        this.add((IFigure)this.fMultiplicityTargetLabel);
    }

    protected RotatableDecoration getAggregationDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 0);
        decorationPointList.addPoint(-2, 2);
        decorationPointList.addPoint(-4, 0);
        decorationPointList.addPoint(-2, -2);
        decoration.setTemplate(decorationPointList);
        decoration.setBackgroundColor(ColorConstants.white);
        decoration.setScale(3.0, 3.0);
        return decoration;
    }

    public WrappingLabel getAppliedStereotypeAssociationLabel() {
        return this.appliedStereotypeLabel;
    }

    public WrappingLabel getAssociationNameLabel() {
        return this.fAssociationNameLabel;
    }

    protected RotatableDecoration getCompositionDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 0);
        decorationPointList.addPoint(-2, 2);
        decorationPointList.addPoint(-4, 0);
        decorationPointList.addPoint(-2, -2);
        decoration.setTemplate(decorationPointList);
        decoration.setScale(3.0, 3.0);
        return decoration;
    }

    public RotatableDecoration getDecoration(int typeDecoration) {
        int ownedValue = typeDecoration / 8;
        int remain = typeDecoration % 8;
        int compositeValue = remain / 4;
        int aggregationValue = (remain %= 4) / 2;
        int navigationValue = (remain %= 2) / 1;
        if (ownedValue == 1) {
            if (compositeValue == 1) {
                if (navigationValue == 1) {
                    return this.getOwnedNavigableCompositionDecoration();
                }
                return this.getOwnedCompositionDecoration();
            }
            if (aggregationValue == 1) {
                if (navigationValue == 1) {
                    return this.getOwnedNavigableAggregationDecoration();
                }
                return this.getOwnedAggregationDecoration();
            }
            if (navigationValue == 1) {
                return this.getOwnedNavigationDecoration();
            }
            return this.getOwnedDecoration();
        }
        if (compositeValue == 1) {
            if (navigationValue == 1) {
                return this.getNavigableCompositionDecoration();
            }
            return this.getCompositionDecoration();
        }
        if (aggregationValue == 1) {
            if (navigationValue == 1) {
                return this.getNavigableAggregationDecoration();
            }
            return this.getAggregationDecoration();
        }
        if (navigationValue == 1) {
            return this.getNavigationDecoration();
        }
        return null;
    }

    public WrappingLabel getMultiplicitySourceLabel() {
        return this.fMultiplicitySourceLabel;
    }

    public WrappingLabel getMultiplicityTargetLabel() {
        return this.fMultiplicityTargetLabel;
    }

    protected RotatableDecoration getNavigableAggregationDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 0);
        decorationPointList.addPoint(-2, 2);
        decorationPointList.addPoint(-4, 0);
        decorationPointList.addPoint(-10, 2);
        decorationPointList.addPoint(-4, 0);
        decorationPointList.addPoint(-10, -2);
        decorationPointList.addPoint(-4, 0);
        decorationPointList.addPoint(-2, -2);
        decoration.setTemplate(decorationPointList);
        decoration.setBackgroundColor(ColorConstants.white);
        decoration.setScale(3.0, 3.0);
        return decoration;
    }

    protected RotatableDecoration getNavigableCompositionDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 0);
        decorationPointList.addPoint(-2, 2);
        decorationPointList.addPoint(-4, 0);
        decorationPointList.addPoint(-10, 2);
        decorationPointList.addPoint(-4, 0);
        decorationPointList.addPoint(-10, -2);
        decorationPointList.addPoint(-4, 0);
        decorationPointList.addPoint(-2, -2);
        decoration.setTemplate(decorationPointList);
        decoration.setScale(3.0, 3.0);
        return decoration;
    }

    protected RotatableDecoration getNavigationDecoration() {
        PolylineDecoration dec = new PolylineDecoration();
        dec.setScale(15.0, 5.0);
        dec.setLineWidth(1);
        return dec;
    }

    protected RotatableDecoration getOwnedAggregationDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 1);
        decorationPointList.addPoint(-2, 3);
        decorationPointList.addPoint(-4, 3);
        decorationPointList.addPoint(-6, 1);
        decorationPointList.addPoint(-6, 0);
        decorationPointList.addPoint(-12, 6);
        decorationPointList.addPoint(-18, 0);
        decorationPointList.addPoint(-12, -6);
        decorationPointList.addPoint(-6, 0);
        decorationPointList.addPoint(-6, -1);
        decorationPointList.addPoint(-4, -3);
        decorationPointList.addPoint(-2, -3);
        decorationPointList.addPoint(0, -1);
        decorationPointList.addPoint(-1, -1);
        decorationPointList.addPoint(-1, 1);
        decorationPointList.addPoint(-2, 3);
        decorationPointList.addPoint(-2, -3);
        decorationPointList.addPoint(-3, -3);
        decorationPointList.addPoint(-3, 3);
        decorationPointList.addPoint(-4, 3);
        decorationPointList.addPoint(-4, -3);
        decorationPointList.addPoint(-5, -2);
        decorationPointList.addPoint(-5, 2);
        decorationPointList.addPoint(-6, 1);
        decorationPointList.addPoint(-6, -1);
        decoration.setScale(1.0, 1.0);
        decoration.setTemplate(decorationPointList);
        decoration.setBackgroundColor(ColorConstants.white);
        return decoration;
    }

    protected RotatableDecoration getOwnedCompositionDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 1);
        decorationPointList.addPoint(-2, 3);
        decorationPointList.addPoint(-4, 3);
        decorationPointList.addPoint(-6, 1);
        decorationPointList.addPoint(-6, 0);
        decorationPointList.addPoint(-12, 6);
        decorationPointList.addPoint(-18, 0);
        decorationPointList.addPoint(-12, -6);
        decorationPointList.addPoint(-6, 0);
        decorationPointList.addPoint(-6, -1);
        decorationPointList.addPoint(-4, -3);
        decorationPointList.addPoint(-2, -3);
        decorationPointList.addPoint(0, -1);
        decoration.setScale(1.0, 1.0);
        decoration.setTemplate(decorationPointList);
        return decoration;
    }

    protected RotatableDecoration getOwnedDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 1);
        decorationPointList.addPoint(-2, 3);
        decorationPointList.addPoint(-4, 3);
        decorationPointList.addPoint(-6, 1);
        decorationPointList.addPoint(-6, -1);
        decorationPointList.addPoint(-4, -3);
        decorationPointList.addPoint(-2, -3);
        decorationPointList.addPoint(0, -1);
        decoration.setTemplate(decorationPointList);
        decoration.setScale(1.0, 1.0);
        return decoration;
    }

    protected RotatableDecoration getOwnedNavigableAggregationDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 1);
        decorationPointList.addPoint(-2, 3);
        decorationPointList.addPoint(-4, 3);
        decorationPointList.addPoint(-6, 1);
        decorationPointList.addPoint(-6, 0);
        decorationPointList.addPoint(-12, 6);
        decorationPointList.addPoint(-18, 0);
        decorationPointList.addPoint(-36, 6);
        decorationPointList.addPoint(-18, 0);
        decorationPointList.addPoint(-36, -6);
        decorationPointList.addPoint(-18, 0);
        decorationPointList.addPoint(-12, -6);
        decorationPointList.addPoint(-6, 0);
        decorationPointList.addPoint(-6, -1);
        decorationPointList.addPoint(-4, -3);
        decorationPointList.addPoint(-2, -3);
        decorationPointList.addPoint(0, -1);
        decorationPointList.addPoint(-1, -1);
        decorationPointList.addPoint(-1, 1);
        decorationPointList.addPoint(-2, 3);
        decorationPointList.addPoint(-2, -3);
        decorationPointList.addPoint(-3, -3);
        decorationPointList.addPoint(-3, 3);
        decorationPointList.addPoint(-4, 3);
        decorationPointList.addPoint(-4, -3);
        decorationPointList.addPoint(-5, -2);
        decorationPointList.addPoint(-5, 2);
        decorationPointList.addPoint(-6, 1);
        decorationPointList.addPoint(-6, -1);
        decoration.setScale(1.0, 1.0);
        decoration.setTemplate(decorationPointList);
        decoration.setBackgroundColor(ColorConstants.white);
        return decoration;
    }

    protected RotatableDecoration getOwnedNavigableCompositionDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 1);
        decorationPointList.addPoint(-2, 3);
        decorationPointList.addPoint(-4, 3);
        decorationPointList.addPoint(-6, 1);
        decorationPointList.addPoint(-6, 0);
        decorationPointList.addPoint(-12, 6);
        decorationPointList.addPoint(-18, 0);
        decorationPointList.addPoint(-36, 6);
        decorationPointList.addPoint(-18, 0);
        decorationPointList.addPoint(-36, -6);
        decorationPointList.addPoint(-18, 0);
        decorationPointList.addPoint(-12, -6);
        decorationPointList.addPoint(-6, 0);
        decorationPointList.addPoint(-6, -1);
        decorationPointList.addPoint(-4, -3);
        decorationPointList.addPoint(-2, -3);
        decorationPointList.addPoint(0, -1);
        decoration.setScale(1.0, 1.0);
        decoration.setTemplate(decorationPointList);
        return decoration;
    }

    protected RotatableDecoration getOwnedNavigationDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 1);
        decorationPointList.addPoint(-2, 3);
        decorationPointList.addPoint(-4, 3);
        decorationPointList.addPoint(-6, 1);
        decorationPointList.addPoint(-6, 0);
        decorationPointList.addPoint(-18, 6);
        decorationPointList.addPoint(-6, 0);
        decorationPointList.addPoint(-18, -6);
        decorationPointList.addPoint(-6, 0);
        decorationPointList.addPoint(-6, -1);
        decorationPointList.addPoint(-4, -3);
        decorationPointList.addPoint(-2, -3);
        decorationPointList.addPoint(0, -1);
        decoration.setScale(1.0, 1.0);
        decoration.setTemplate(decorationPointList);
        return decoration;
    }

    public WrappingLabel getRoleSourceLabel() {
        return this.fRoleSourceLabel;
    }

    public WrappingLabel getRoleTargetLabel() {
        return this.fRoleTargetLabel;
    }

    public void paintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        super.paintFigure(graphics);
    }

    public void setEnd(int sourceType, int targetType) {
        this.setSourceDecoration(this.getDecoration(sourceType));
        this.setTargetDecoration(this.getDecoration(targetType));
    }
}

