/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.profile.custom.policies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.AddCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.diagram.profile.custom.commands.CustomMetaClassCreateCommand;
import org.eclipse.papyrus.diagram.profile.custom.commands.CustomSemanticCreateCommand;
import org.eclipse.papyrus.diagram.profile.custom.helper.MetaclassHelper;
import org.eclipse.papyrus.diagram.profile.custom.requests.CustomCreateElementRequestAdapter;
import org.eclipse.papyrus.diagram.profile.custom.requests.CustomCreateViewAndElementRequest;
import org.eclipse.papyrus.diagram.profile.custom.requests.CustomCreateViewRequest;
import org.eclipse.papyrus.diagram.profile.edit.parts.MetaclassEditPart;
import org.eclipse.papyrus.diagram.profile.edit.parts.MetaclassEditPartCN;
import org.eclipse.papyrus.diagram.profile.edit.parts.ProfileDiagramEditPart;
import org.eclipse.papyrus.diagram.profile.edit.parts.ProfilePackageableElementCompartmentEditPartCN;
import org.eclipse.papyrus.diagram.profile.edit.parts.ProfilePackageableElementCompartmentEditPartTN;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Profile;

public class CustomCreationRoleEditPolicy
extends CreationEditPolicy {
    private int[] metaclassesEP_ID = new int[]{1031, 3028};
    private ArrayList<String> metaclassesEP_ID_List = new ArrayList();
    private ArrayList<CreateElementRequestAdapter> requestAdapterList;

    public CustomCreationRoleEditPolicy() {
        this.init(this.metaclassesEP_ID);
        this.requestAdapterList = new ArrayList();
    }

    private void init(int[] metaclassesID) {
        int i = 0;
        while (i < metaclassesID.length) {
            this.metaclassesEP_ID_List.add(new String(new Integer(metaclassesID[i]).toString()));
            ++i;
        }
    }

    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        Command createElementCommand;
        if (!this.metaclassesEP_ID_List.contains(((CreateViewRequest.ViewDescriptor)request.getViewDescriptors().get(0)).getSemanticHint())) {
            return super.getCreateElementAndViewCommand(request);
        }
        CreateElementRequestAdapter requestAdapter = request.getViewAndElementDescriptor().getCreateElementRequestAdapter();
        CustomCreateElementRequestAdapter customRequestAdapter = new CustomCreateElementRequestAdapter((CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class));
        CustomCreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CustomCreateViewAndElementRequest.ViewAndElementDescriptor(customRequestAdapter, ((CreateViewRequest.ViewDescriptor)request.getViewDescriptors().get(0)).getViewKind(), ((CreateViewRequest.ViewDescriptor)request.getViewDescriptors().get(0)).getSemanticHint(), ((CreateViewRequest.ViewDescriptor)request.getViewDescriptors().get(0)).getPreferencesHint());
        CustomCreateViewAndElementRequest requestNEW = new CustomCreateViewAndElementRequest(viewDescriptor);
        requestNEW.setExtendedData(request.getExtendedData());
        requestNEW.setLocation(request.getLocation());
        CreateElementRequest createElementRequest = (CreateElementRequest)customRequestAdapter.getAdapter(CreateElementRequest.class, 0);
        if (createElementRequest.getContainer() == null) {
            View view = (View)this.getHost().getModel();
            EObject hostElement = ViewUtil.resolveSemanticElement((View)view);
            if (hostElement == null && view.getElement() == null) {
                hostElement = view;
            }
            if (hostElement == null) {
                return null;
            }
            createElementRequest.setContainer(hostElement);
        }
        if ((createElementCommand = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)((CreateElementRequest)customRequestAdapter.getAdapter(CreateElementRequest.class, 0)), request.getExtendedData()))) == null) {
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        if (!createElementCommand.canExecute()) {
            return createElementCommand;
        }
        Profile profile = (Profile)createElementRequest.getContainer();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)profile);
        CustomSemanticCreateCommand semanticCommand = new CustomSemanticCreateCommand(domain, customRequestAdapter, profile);
        Command viewCommand = this.getCreateCommand(requestNEW);
        CompositeCommand cc = new CompositeCommand(semanticCommand.getLabel());
        cc.compose((IUndoableOperation)semanticCommand);
        cc.compose((IUndoableOperation)new CommandProxy(viewCommand));
        return new ICommandProxy((ICommand)cc);
    }

    public Command getCommand(Request request) {
        if (this.understandsRequest(request)) {
            if (request instanceof CreateViewAndElementRequest && this.metaclassesEP_ID_List.contains(((CreateViewRequest.ViewDescriptor)((CreateViewAndElementRequest)request).getViewDescriptors().get(0)).getSemanticHint())) {
                Point location = ((CreateViewAndElementRequest)request).getLocation().getCopy();
                ((GraphicalEditPart)this.getHost()).getContentPane().translateToRelative((Translatable)location);
                ((GraphicalEditPart)this.getHost()).getContentPane().translateFromParent((Translatable)location);
                location.translate(((GraphicalEditPart)this.getHost()).getContentPane().getClientArea().getLocation().getNegated());
                ((CreateViewAndElementRequest)request).setLocation(location);
                return this.getCreateElementAndViewCommand((CreateViewAndElementRequest)request);
            }
            return super.getCommand(request);
        }
        return null;
    }

    private Command getCreateCommand(CustomCreateViewAndElementRequest request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        for (CustomCreateViewRequest.ViewDescriptor viewDescriptor : request.getViewDescriptors()) {
            CustomMetaClassCreateCommand createCommand = new CustomMetaClassCreateCommand(editingDomain, viewDescriptor, (View)this.getHost().getModel(), request.getLocation());
            cc.compose((IUndoableOperation)createCommand);
        }
        return new ICommandProxy(cc.reduce());
    }

    protected Command getReparentCommand(ChangeBoundsRequest request) {
        Iterator editParts = request.getEditParts().iterator();
        View container = (View)this.getHost().getAdapter(View.class);
        EObject context = container == null ? null : ViewUtil.resolveSemanticElement((View)container);
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        while (editParts.hasNext()) {
            View view;
            EditPart ep = (EditPart)editParts.next();
            if (ep instanceof LabelEditPart) continue;
            if (ep instanceof GroupEditPart) {
                cc.compose((IUndoableOperation)this.getReparentGroupCommand((GroupEditPart)ep));
            }
            if ((view = (View)ep.getAdapter(View.class)) == null) continue;
            EObject semantic = ViewUtil.resolveSemanticElement((View)view);
            if (semantic == null) {
                cc.compose((IUndoableOperation)this.getReparentViewCommand((IGraphicalEditPart)ep));
                continue;
            }
            if (context == null || !this.shouldReparent(semantic, context)) continue;
            cc.compose((IUndoableOperation)this.getReparentCommand((IGraphicalEditPart)ep));
        }
        return cc.isEmpty() ? null : new ICommandProxy(cc.reduce());
    }

    protected ICommand getReparentCommand(IGraphicalEditPart gep) {
        if (!(gep instanceof MetaclassEditPart) && !(gep instanceof MetaclassEditPartCN)) {
            return super.getReparentCommand(gep);
        }
        if (!(this.getHost() instanceof ProfilePackageableElementCompartmentEditPartTN || this.getHost() instanceof ProfilePackageableElementCompartmentEditPartCN || this.getHost() instanceof ProfileDiagramEditPart)) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        View container = (View)this.getHost().getModel();
        EObject context = ViewUtil.resolveSemanticElement((View)container);
        View view = (View)gep.getModel();
        EObject element = ViewUtil.resolveSemanticElement((View)view);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        String qName = null;
        EditPart parent = gep.getParent();
        Object profileEP = null;
        Profile parentProfile = MetaclassHelper.getParentProfile(gep.getParent());
        EObject elementToMove = gep.getPrimaryView().getElement();
        if (elementToMove instanceof Class) {
            qName = ((Class)elementToMove).getQualifiedName();
        }
        EList elements = parentProfile.getElementImports();
        for (ElementImport elementImport : elements) {
            if (!elementImport.getImportedElement().getQualifiedName().equals(qName)) continue;
            element = elementImport;
            break;
        }
        cc.compose((IUndoableOperation)this.getReparentViewCommand(gep));
        return cc;
    }

    protected ICommand getReparentViewCommand(IGraphicalEditPart gep) {
        if (!(gep instanceof MetaclassEditPart) && !(gep instanceof MetaclassEditPartCN)) {
            return super.getReparentViewCommand(gep);
        }
        CompositeCommand deleteViewCmd = new CompositeCommand("Reparent one metaclass view and delete the others");
        View metaclassView = (View)gep.getModel();
        EObject element = metaclassView.getElement();
        List elementViews = DiagramEditPartsUtil.getEObjectViews((EObject)element);
        for (View view : elementViews) {
            if (view == metaclassView) continue;
            deleteViewCmd.add((IUndoableOperation)new DeleteCommand(gep.getEditingDomain(), view));
        }
        View parent = (View)this.getHost().getModel();
        deleteViewCmd.add((IUndoableOperation)new AddCommand(gep.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)parent), (IAdaptable)new EObjectAdapter((EObject)metaclassView)));
        return deleteViewCmd;
    }
}

