/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.profile.custom.policies;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.diagram.common.helper.OperationLabelHelper;
import org.eclipse.papyrus.diagram.profile.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationLabelEditPolicy
extends AbstractMaskManagedEditPolicy {
    public void addAdditionalListeners() {
        super.addAdditionalListeners();
        Operation operation = this.getUMLElement();
        if (operation == null) {
            return;
        }
        for (Parameter parameter : operation.getOwnedParameters()) {
            this.getDiagramEventBroker().addNotificationListener((EObject)parameter, (NotificationListener)this);
            if (parameter.getType() == null) continue;
            this.getDiagramEventBroker().addNotificationListener((EObject)parameter.getType(), (NotificationListener)this);
        }
    }

    public int getCurrentDisplayValue() {
        EAnnotation customeDisplayAnnotation = ((View)this.getHost().getModel()).getEAnnotation("CustomAppearance_Annotation");
        int displayValue = this.getDefaultDisplayValue();
        if (customeDisplayAnnotation != null) {
            displayValue = Integer.parseInt((String)customeDisplayAnnotation.getDetails().get((Object)"CustomAppearance_MaskValue"));
        } else {
            IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
            int displayValueTemp = store.getInt("Operation.label.display");
            if (displayValueTemp != 0) {
                displayValue = displayValueTemp;
            }
        }
        return displayValue;
    }

    public int getDefaultDisplayValue() {
        return 2954;
    }

    public String getMaskLabel(int value) {
        return OperationLabelHelper.getInstance().getMaskLabel(value);
    }

    public Collection<String> getMaskLabels() {
        return OperationLabelHelper.getInstance().getMaskLabels();
    }

    public Map<Integer, String> getMasks() {
        return OperationLabelHelper.getInstance().getMasks();
    }

    public Collection<Integer> getMaskValues() {
        return OperationLabelHelper.getInstance().getMaskValues();
    }

    public String getPreferencePageID() {
        return "org.eclipse.papyrus.diagram.profile.custom.preferences.OperationPreferencePage";
    }

    public Operation getUMLElement() {
        return (Operation)super.getUMLElement();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        Operation operation = this.getUMLElement();
        if (object == null) {
            return;
        }
        if (object.equals(operation)) {
            this.notifyOperationChanged(operation, notification);
        } else if (this.isParameter(object)) {
            this.notifyParameterChanged(notification);
        } else if (this.isParameterType(object)) {
            this.notifyParameterTypeChanged(notification);
        }
        if (this.isMaskManagedAnnotation(object)) {
            this.refreshDisplay();
        }
        if (this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        }
    }

    protected boolean isParameterType(Object object) {
        if (!(object instanceof Type)) {
            return false;
        }
        for (Parameter parameter : this.getUMLElement().getOwnedParameters()) {
            if (!object.equals(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    protected boolean isParameter(Object object) {
        if (!(object instanceof Parameter)) {
            return false;
        }
        return this.getUMLElement().getOwnedParameters().contains(object);
    }

    protected void notifyParameterChanged(Notification notification) {
        switch (notification.getFeatureID(Parameter.class)) {
            case 4: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 26: {
                this.refreshDisplay();
                break;
            }
            case 10: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 5: {
                        if (notification.getNewValue() instanceof List) {
                            List addedElements = (List)notification.getNewValue();
                            for (Object addedElement : addedElements) {
                                if (!(addedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().addNotificationListener((EObject)addedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 4: {
                        this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 6: {
                        if (notification.getOldValue() instanceof List) {
                            List removedElements = (List)notification.getOldValue();
                            for (Object removedElement : removedElements) {
                                if (!(removedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().removeNotificationListener((EObject)removedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 1: {
                        if (notification.getNewValue() != null) {
                            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        }
                        if (notification.getOldValue() != null) {
                            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        }
                        this.refreshDisplay();
                    }
                }
                break;
            }
        }
    }

    protected void notifyParameterTypeChanged(Notification notification) {
        switch (notification.getFeatureID(notification.getNotifier().getClass())) {
            case 4: 
            case 5: 
            case 11: {
                this.refreshDisplay();
                break;
            }
        }
    }

    protected void notifyOperationChanged(Operation operation, Notification notification) {
        switch (notification.getFeatureID(Operation.class)) {
            case 4: 
            case 5: 
            case 19: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: {
                this.refreshDisplay();
                break;
            }
            case 21: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 5: {
                        if (notification.getNewValue() instanceof List) {
                            List addedElements = (List)notification.getNewValue();
                            for (Object addedElement : addedElements) {
                                if (!(addedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().addNotificationListener((EObject)addedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 4: {
                        this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 6: {
                        if (notification.getOldValue() instanceof List) {
                            List removedElements = (List)notification.getOldValue();
                            for (Object removedElement : removedElements) {
                                if (!(removedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().removeNotificationListener((EObject)removedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 1: {
                        if (notification.getNewValue() != null) {
                            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        }
                        if (notification.getOldValue() != null) {
                            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        }
                        this.refreshDisplay();
                    }
                }
                break;
            }
        }
    }

    public void refreshDisplay() {
        OperationLabelHelper.getInstance().refreshEditPartDisplay((GraphicalEditPart)this.getHost());
    }

    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        Operation operation = this.getUMLElement();
        if (operation == null) {
            return;
        }
        for (Parameter parameter : operation.getOwnedParameters()) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)parameter, (NotificationListener)this);
            if (parameter.getType() == null) continue;
            this.getDiagramEventBroker().removeNotificationListener((EObject)parameter.getType(), (NotificationListener)this);
        }
    }
}

