/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.profile.custom.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.diagram.common.editpolicies.OldCommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.diagram.common.util.Util;
import org.eclipse.papyrus.diagram.profile.custom.commands.SetStereotypeVisibleOnMetaclassCommand;
import org.eclipse.papyrus.diagram.profile.custom.helper.MultiAssociationHelper;
import org.eclipse.papyrus.diagram.profile.custom.helper.MultiDependencyHelper;
import org.eclipse.papyrus.diagram.profile.custom.helper.ProfileLinkMappingHelper;
import org.eclipse.papyrus.diagram.profile.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.diagram.profile.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileDiagramDragDropEditPolicy
extends OldCommonDiagramDragDropEditPolicy {
    public ProfileDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)ProfileLinkMappingHelper.getInstance());
    }

    protected Set<Integer> getDroppableElementVisualId() {
        HashSet<Integer> droppableElementsVisualID = new HashSet<Integer>();
        droppableElementsVisualID.add(2014);
        droppableElementsVisualID.add(1064);
        droppableElementsVisualID.add(1013);
        droppableElementsVisualID.add(2015);
        droppableElementsVisualID.add(1002);
        droppableElementsVisualID.add(1007);
        droppableElementsVisualID.add(1014);
        droppableElementsVisualID.add(1028);
        droppableElementsVisualID.add(1031);
        droppableElementsVisualID.add(3028);
        return droppableElementsVisualID;
    }

    public int getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public int getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public IElementType getUMLElementType(int elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    protected Command dropAssociation(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID) {
        Collection<?> endtypes = ProfileLinkMappingHelper.getInstance().getSource(semanticLink);
        if (endtypes.size() == 2) {
            Element source = (Element)endtypes.toArray()[0];
            Element target = (Element)endtypes.toArray()[1];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Association"), source, target, 4001, dropRequest.getLocation(), semanticLink));
        }
        if (endtypes.size() > 2) {
            MultiAssociationHelper associationHelper = new MultiAssociationHelper(this.getEditingDomain());
            return associationHelper.dropMultiAssociation((Association)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropDependency(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID) {
        Collection<?> sources = ProfileLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = ProfileLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sources.size() == 1 && targets.size() == 1) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Association"), source, target, 4008, dropRequest.getLocation(), semanticLink));
        }
        if (sources.size() > 1 || targets.size() > 1) {
            MultiDependencyHelper dependencyHelper = new MultiDependencyHelper(this.getEditingDomain());
            return dependencyHelper.dropMutliDependency((Dependency)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID, int linkVISUALID) {
        switch (linkVISUALID) {
            case 1064: {
                return this.dropElementImport(dropRequest, semanticElement, nodeVISUALID);
            }
            case 1013: {
                return this.dropExtension(dropRequest, semanticElement, linkVISUALID);
            }
        }
        switch (nodeVISUALID) {
            case 2014: {
                return this.dropDependency(dropRequest, semanticElement, nodeVISUALID);
            }
            case 2015: {
                return this.dropAssociation(dropRequest, semanticElement, nodeVISUALID);
            }
            case 1002: 
            case 1007: {
                return this.dropComment(dropRequest, semanticElement, nodeVISUALID);
            }
            case 1014: 
            case 1028: {
                return this.dropConstraint(dropRequest, semanticElement, nodeVISUALID);
            }
            case 1031: 
            case 3028: {
                return this.dropMetaclass(dropRequest, semanticElement, nodeVISUALID);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropMetaclass(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID) {
        if (Util.isMetaclass((Type)((Type)semanticElement))) {
            CompositeCommand cc = new CompositeCommand("Drop");
            CompositeCommand dropCommand = super.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticElement);
            cc.compose((IUndoableOperation)dropCommand);
            Object returnedValue = dropCommand.getCommandResult().getReturnValue();
            if (returnedValue instanceof ArrayList) {
                CreateViewRequest.ViewDescriptor desc = (CreateViewRequest.ViewDescriptor)((ArrayList)returnedValue).get(0);
                SetStereotypeVisibleOnMetaclassCommand command = new SetStereotypeVisibleOnMetaclassCommand(this.getEditingDomain(), "Apply Stereotype", null, semanticElement, desc);
                if (command.canExecute()) {
                    cc.compose((IUndoableOperation)command);
                }
            }
            return new ICommandProxy((ICommand)cc);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropComment(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (!(graphicalParentObject instanceof Package)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (nodeVISUALID == 1002) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_1002, (IHintedType)UMLElementTypes.CommentAnnotatedElement_1022);
        }
        if (nodeVISUALID == 1007) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_1007, (IHintedType)UMLElementTypes.CommentAnnotatedElement_1022);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropConstraint(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (!(graphicalParentObject instanceof Package)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (nodeVISUALID == 1014) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_1014, (IHintedType)UMLElementTypes.ConstraintConstrainedElement_4014);
        }
        if (nodeVISUALID == 1028) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_1028, (IHintedType)UMLElementTypes.ConstraintConstrainedElement_4014);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected Command dropExtension(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sources = ProfileLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = ProfileLinkMappingHelper.getInstance().getTarget(semanticLink);
        Element source = (Element)sources.toArray()[0];
        Element target = (Element)targets.toArray()[0];
        if (sources.size() != 1 && targets.size() != 1) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)this.dropBinaryLinkExtension(new CompositeCommand("drop Extension"), source, target, 1013, dropRequest.getLocation(), semanticLink));
    }

    protected Command dropElementImport(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        if (semanticLink instanceof ElementImport && ((ElementImport)semanticLink).getImportedElement() instanceof Class) {
            SetStereotypeVisibleOnMetaclassCommand stereotypeCommand;
            Class metaclass = (Class)((ElementImport)semanticLink).getImportedElement();
            EObject container = semanticLink.eContainer();
            List containerView = DiagramEditPartsUtil.getEObjectViews((EObject)container);
            CompositeCommand cc = new CompositeCommand("Drop");
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)metaclass);
            CreateViewRequest.ViewDescriptor descriptor = ((View)containerView.get(0)).equals(this.getHost().getModel()) ? new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(1031)).getSemanticHint(), -1, false, this.getDiagramPreferencesHint()) : new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(3028)).getSemanticHint(), -1, false, this.getDiagramPreferencesHint());
            CreateCommand createCommand = new CreateCommand(this.getEditingDomain(), descriptor, (View)this.getHost().getModel());
            cc.compose((IUndoableOperation)createCommand);
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), dropRequest.getLocation());
            cc.compose((IUndoableOperation)setBoundsCommand);
            if (createCommand.canExecute() && (stereotypeCommand = new SetStereotypeVisibleOnMetaclassCommand(this.getEditingDomain(), "Set Stereotype Visible", null, semanticLink, (CreateViewRequest.ViewDescriptor)createCommand.getCommandResult().getReturnValue())).canExecute()) {
                cc.add((IUndoableOperation)stereotypeCommand);
            }
            return new ICommandProxy((ICommand)cc);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public CompositeCommand dropBinaryLinkExtension(CompositeCommand cc, Element source, Element target, int linkVISUALID, Point location, Element semanticLink) {
        SetBoundsCommand setBoundsCommand;
        CreateCommand nodeCreationCommand;
        CreateViewRequest.ViewDescriptor descriptor;
        GraphicalEditPart sourceEditPart = (GraphicalEditPart)this.lookForEditPartSource((EObject)source);
        GraphicalEditPart targetEditPart = (GraphicalEditPart)this.lookForEditPartTarget((EObject)target, semanticLink);
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)this.getUMLElementType(linkVISUALID), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), this.getDiagramPreferencesHint());
        SemanticAdapter sourceAdapter = null;
        SemanticAdapter targetAdapter = null;
        EList e = source.eAdapters();
        if (sourceEditPart == null) {
            descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)source), Node.class, null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            nodeCreationCommand = new CreateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), descriptor, (View)this.getHost().getModel());
            cc.compose((IUndoableOperation)nodeCreationCommand);
            setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y + 100));
            cc.compose((IUndoableOperation)setBoundsCommand);
            sourceAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
        } else {
            sourceAdapter = new SemanticAdapter(null, sourceEditPart.getModel());
        }
        if (targetEditPart == null) {
            descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)target), Node.class, null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            nodeCreationCommand = new CreateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), descriptor, (View)this.getHost().getModel());
            cc.compose((IUndoableOperation)nodeCreationCommand);
            setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y - 100));
            cc.compose((IUndoableOperation)setBoundsCommand);
            targetAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
        } else {
            targetAdapter = new SemanticAdapter(null, targetEditPart.getModel());
        }
        CommonDeferredCreateConnectionViewCommand aLinkCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), (IAdaptable)sourceAdapter, (IAdaptable)targetAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        aLinkCommand.setElement((EObject)semanticLink);
        cc.compose((IUndoableOperation)aLinkCommand);
        return cc;
    }

    private EditPart lookForEditPartSource(EObject semantic) {
        Collection editPartSet = this.getHost().getViewer().getEditPartRegistry().values();
        Iterator editPartIterator = editPartSet.iterator();
        EditPart existedEditPart = null;
        while (editPartIterator.hasNext() && existedEditPart == null) {
            EditPart currentEditPart = (EditPart)editPartIterator.next();
            if (!this.isEditPartTypeAdapted(currentEditPart.getClass(), semantic.eClass()) || !semantic.equals(((GraphicalEditPart)currentEditPart).resolveSemanticElement())) continue;
            existedEditPart = currentEditPart;
        }
        return existedEditPart;
    }

    private EditPart lookForEditPartTarget(EObject semantic, Element semanticLink) {
        Collection editPartSet = this.getHost().getViewer().getEditPartRegistry().values();
        Collection<EditPart> editPartSet2 = this.getTheFirstLevel(semanticLink);
        Iterator editPartIterator = editPartSet.iterator();
        EditPart existedEditPart = null;
        while (editPartIterator.hasNext() && existedEditPart == null) {
            EditPart currentEditPart = (EditPart)editPartIterator.next();
            if (!editPartSet2.contains(currentEditPart) || !this.isEditPartTypeAdapted(currentEditPart.getClass(), semantic.eClass()) || !semantic.equals(((GraphicalEditPart)currentEditPart).resolveSemanticElement())) continue;
            existedEditPart = currentEditPart;
        }
        return existedEditPart;
    }

    private boolean isEditPartTypeAdapted(java.lang.Class<? extends EditPart> editPartClass, EClass eClass) {
        if (DiagramEditPart.class.isAssignableFrom(editPartClass) || CompartmentEditPart.class.isAssignableFrom(editPartClass)) {
            return false;
        }
        if (GraphicalEditPart.class.isAssignableFrom(editPartClass)) {
            return this.isEditPartTypeSuitableForEClass(editPartClass.asSubclass(GraphicalEditPart.class), eClass);
        }
        return false;
    }

    private Collection<EditPart> getTheFirstLevel(Element semanticLink) {
        EObject linkContainer = semanticLink.eContainer();
        EditPart currentEditPart2 = null;
        ArrayList<EditPart> profileContents = new ArrayList<EditPart>();
        Collection editPartSet = this.getHost().getViewer().getEditPartRegistry().values();
        for (EditPart currentEditPart2 : editPartSet) {
            EObject parent;
            if (currentEditPart2.getParent() == null) continue;
            Object model = currentEditPart2.getParent().getModel();
            if (model instanceof Node && (parent = ((Node)model).getElement()).equals(linkContainer)) {
                profileContents.add(currentEditPart2);
            }
            if (!(model instanceof Diagram) || !(parent = ((Diagram)model).getElement()).equals(linkContainer)) continue;
            profileContents.add(currentEditPart2);
        }
        return profileContents;
    }
}

