/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.profile.custom.ui.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.profile.custom.messages.Messages;
import org.eclipse.papyrus.diagram.profile.custom.ui.dialog.ClassElementComparator;
import org.eclipse.papyrus.diagram.profile.custom.ui.dialog.ElementListWithComparator;
import org.eclipse.papyrus.profile.ui.dialogs.AlphabeticalViewerSorter;
import org.eclipse.papyrus.profile.ui.dialogs.ChooseSetAssistedDialog;
import org.eclipse.papyrus.profile.ui.dialogs.IChooseDialog;
import org.eclipse.papyrus.umlutils.ElementUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;

public class ChooseSetMetaclassDialog
extends ChooseSetAssistedDialog
implements IChooseDialog {
    protected Profile profile;

    public ChooseSetMetaclassDialog(Shell parentShell, Profile profile) {
        this(parentShell, profile, true);
    }

    public ChooseSetMetaclassDialog(Shell parentShell, Profile prof, boolean retrieveImported) {
        super(parentShell, Messages.ChooseSetMetaclassDialog_Metaclasses, Messages.ChooseSetMetaclassDialog_ImportedMetaclasses);
        EObject container = prof.eContainer();
        Profile oldContainer = prof;
        while (container != null) {
            oldContainer = container;
            container = container.eContainer();
        }
        this.profile = oldContainer;
        this.selectedElementList = new ElementListWithComparator(new ClassElementComparator());
        this.labelProvider = new MetaclassLabelProvider();
        this.decoratedContentProposalProvider = new MetaclassContentProposalProvider();
        Iterator metaclasses = ElementUtil.getPossibleMetaclasses((Element)this.profile).iterator();
        while (metaclasses.hasNext()) {
            this.possibleElementList.addElement(metaclasses.next());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Control composite = super.createDialogArea(parent);
        this.possibleElementsTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.possibleElementsTable, 0x1000000, 0);
        column.setText(Messages.ChooseSetMetaclassDialog_Metaclass);
        column.setWidth(150);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseSetMetaclassDialog.this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(0));
            }
        });
        column = new TableColumn(this.possibleElementsTable, 16384, 1);
        column.setText(Messages.ChooseSetMetaclassDialog_Information);
        column.setWidth(165);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseSetMetaclassDialog.this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(1));
            }
        });
        this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(0));
        return composite;
    }

    protected void runAddElement(String name) {
        Class theClass = null;
        for (Class current : this.possibleElementList.getElements()) {
            if (!name.equalsIgnoreCase(current.getName()) && !name.equalsIgnoreCase(current.getQualifiedName())) continue;
            theClass = current;
        }
        if (theClass != null) {
            this.runActionAdd(theClass);
        }
    }

    public void runActionAdd(Object element) {
        super.runActionAdd(element);
        this.updateOKButtonStatus();
    }

    protected void runActionRemove(Object element) {
        super.runActionRemove(element);
        this.updateOKButtonStatus();
    }

    protected boolean isSelectableElement(String text) {
        for (Class element : this.possibleElementList.getElements()) {
            if (!text.equalsIgnoreCase(element.getName()) && !text.equalsIgnoreCase(element.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void updateOKButtonStatus() {
        Button OKButton = this.getButton(0);
        if (OKButton != null) {
            OKButton.setEnabled(!this.selectedElementList.getElements().isEmpty());
        }
    }

    public class MetaclassContentProposalProvider
    extends ChooseSetAssistedDialog.DecoratedContentProposalProvider {
        public MetaclassContentProposalProvider() {
            super((ChooseSetAssistedDialog)ChooseSetMetaclassDialog.this);
        }

        public ChooseSetAssistedDialog.DecoratedContentProposal[] getProposals(String contents, int position) {
            ArrayList<ChooseSetAssistedDialog.DecoratedContentProposal> proposals = new ArrayList<ChooseSetAssistedDialog.DecoratedContentProposal>();
            if (ChooseSetMetaclassDialog.this.possibleElementList != null) {
                for (NamedElement element : ChooseSetMetaclassDialog.this.possibleElementList.getElements()) {
                    String simpleName = element.getName();
                    if (position >= simpleName.length() || !contents.substring(0, position).equalsIgnoreCase(simpleName.substring(0, position))) continue;
                    proposals.add(new ChooseSetAssistedDialog.DecoratedContentProposal((ChooseSetAssistedDialog)ChooseSetMetaclassDialog.this, (Object)element, ChooseSetMetaclassDialog.this.labelProvider));
                }
            }
            Collections.sort(proposals);
            return proposals.toArray(new ChooseSetAssistedDialog.DecoratedContentProposal[proposals.size()]);
        }
    }

    protected class MetaclassLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final String ID = "org.eclipse.uml2.uml.edit";
        private static final String PATH = "/icons/full/obj16/";
        private static final String LOCAL_PATH = "/icons/obj16/";
        private static final String EXTENSION = ".gif";
        private static final String EMPTY_IMAGE = "Empty.gif";
        private static final String DUMMY_IMAGE = "dummy.gif";
        private static final String EMPTY_IMAGE_PATH = "../../../../../../../../../icons/obj16/Empty.gif";

        protected MetaclassLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageRegistry registry;
            Image image = null;
            String name = this.getText(element);
            if (element instanceof Class) {
                image = Activator.getPluginIconImage((String)ID, (String)(PATH + name + EXTENSION));
            }
            if (image.equals((Object)Activator.getPluginIconImage((String)ID, (String)"/icons/full/obj16/dummy.gif.gif")) && (image = Activator.getPluginIconImage((String)"org.eclipse.papyrus.diagram.profile", (String)"/icons/obj16/Empty.gif")).equals((Object)Activator.getPluginIconImage((String)ID, (String)"/icons/full/obj16/dummy.gif.gif")) && (registry = Activator.getDefault().getImageRegistry()).getDescriptor("org.eclipse.papyrus.diagram.profile/icons/full/obj16/Empty.gif") == null) {
                try {
                    ImageDescriptor imDesc = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)EMPTY_IMAGE_PATH);
                    String key = "org.eclipse.papyrus.diagram.profile/icons/obj16/Empty.gif";
                    registry.put(key, imDesc);
                    image = registry.get(key);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return image;
        }

        public String getText(Object element) {
            if (!(element instanceof Class)) {
                return "not a class";
            }
            return ((Class)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getText(element);
            }
            if (columnIndex == 1) {
                return ((Class)element).getQualifiedName();
            }
            return "not the right column index";
        }
    }

    protected class MetaclassQualifiedLabelProvider
    extends MetaclassLabelProvider {
        protected MetaclassQualifiedLabelProvider() {
        }

        public String getText(Object element) {
            if (!(element instanceof Class)) {
                return "not a class";
            }
            return ((Class)element).getQualifiedName();
        }
    }
}

