/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.profile.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.diagram.profile.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ProfileApplicationReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ProfileApplicationReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof ProfileApplication)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Package) || !(this.newEnd instanceof Package)) {
            return false;
        }
        Profile target = this.getLink().getAppliedProfile();
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistProfileApplication_1045(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Profile) || !(this.newEnd instanceof Profile)) {
            return false;
        }
        Package source = this.getLink().getApplyingPackage();
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistProfileApplication_1045(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setApplyingPackage(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setAppliedProfile(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected ProfileApplication getLink() {
        return (ProfileApplication)this.getElementToEdit();
    }

    protected Package getOldSource() {
        return (Package)this.oldEnd;
    }

    protected Package getNewSource() {
        return (Package)this.newEnd;
    }

    protected Profile getOldTarget() {
        return (Profile)this.oldEnd;
    }

    protected Profile getNewTarget() {
        return (Profile)this.newEnd;
    }
}

