/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.profile.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.providers.BaseViewInfo;
import org.eclipse.papyrus.diagram.common.providers.ViewInfo;
import org.eclipse.papyrus.diagram.profile.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.diagram.profile/debug/visualID";
    private static ViewInfo diagramViewInfo = null;

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLProfileDiagram".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Profile)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLProfileDiagram".equals(containerModelID)) {
            return -1;
        }
        if ("PapyrusUMLProfileDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
                    return 2014;
                }
                if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
                    return 2015;
                }
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) {
                    return 1026;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 1031;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 1002;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 1014;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return 1030;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 2009;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 2010;
                }
                if (!NotationPackage.eINSTANCE.getDiagram().isSuperTypeOf(domainElement.eClass())) break;
                return 2016;
            }
            case 1012: {
                if (!UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) break;
                return 1012;
            }
            case 1005: {
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 1007;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 1027;
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return 1024;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 1012;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 1028;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3026;
                }
                if (!UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 11: {
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 1007;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 1027;
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return 1024;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 1012;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 1028;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3026;
                }
                if (!UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 1042: {
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) {
                    return 1023;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 1027;
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return 1024;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 1012;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 1028;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3026;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 1007;
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return 3028;
            }
            case 1051: {
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) {
                    return 1023;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 1027;
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return 1024;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 1012;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 1028;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3026;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 1007;
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return 3028;
            }
            case 1071: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 1052: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 1019: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3020;
            }
            case 1053: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3020;
            }
            case 1057: {
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 1007;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 1027;
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return 1024;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 1012;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 1028;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3026;
                }
                if (!UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 1058: {
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 1007;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 1027;
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return 1024;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 1012;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 1028;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3026;
                }
                if (!UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 1062: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 1037;
            }
            case 1063: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 1037;
            }
            case 1067: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3018;
            }
            case 1069: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3018;
            }
            case 1068: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3019;
            }
            case 1070: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3019;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLProfileDiagram".equals(containerModelID)) {
            return false;
        }
        if ("PapyrusUMLProfileDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2014 == nodeVisualID) {
                    return true;
                }
                if (2015 == nodeVisualID) {
                    return true;
                }
                if (1026 == nodeVisualID) {
                    return true;
                }
                if (1031 == nodeVisualID) {
                    return true;
                }
                if (1002 == nodeVisualID) {
                    return true;
                }
                if (1014 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (1030 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2009 == nodeVisualID) {
                    return true;
                }
                if (2010 == nodeVisualID) {
                    return true;
                }
                if (2016 != nodeVisualID) break;
                return true;
            }
            case 2014: {
                if (1 != nodeVisualID) break;
                return true;
            }
            case 1026: {
                if (1034 == nodeVisualID) {
                    return true;
                }
                if (1071 == nodeVisualID) {
                    return true;
                }
                if (1019 != nodeVisualID) break;
                return true;
            }
            case 1031: {
                if (1084 != nodeVisualID) break;
                return true;
            }
            case 1002: {
                if (3 != nodeVisualID) break;
                return true;
            }
            case 1014: {
                if (1015 == nodeVisualID) {
                    return true;
                }
                if (5063 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5020 == nodeVisualID) {
                    return true;
                }
                if (1057 != nodeVisualID) break;
                return true;
            }
            case 1030: {
                if (1047 == nodeVisualID) {
                    return true;
                }
                if (1042 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5026 == nodeVisualID) {
                    return true;
                }
                if (1005 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5023 == nodeVisualID) {
                    return true;
                }
                if (1063 != nodeVisualID) break;
                return true;
            }
            case 2009: {
                if (5032 != nodeVisualID) break;
                return true;
            }
            case 2010: {
                if (5035 == nodeVisualID) {
                    return true;
                }
                if (1067 == nodeVisualID) {
                    return true;
                }
                if (1068 != nodeVisualID) break;
                return true;
            }
            case 2016: {
                if (2 != nodeVisualID) break;
                return true;
            }
            case 3026: {
                if (5058 != nodeVisualID) break;
                return true;
            }
            case 1023: {
                if (1046 == nodeVisualID) {
                    return true;
                }
                if (1052 == nodeVisualID) {
                    return true;
                }
                if (1053 != nodeVisualID) break;
                return true;
            }
            case 3028: {
                if (5062 != nodeVisualID) break;
                return true;
            }
            case 1007: {
                if (1008 != nodeVisualID) break;
                return true;
            }
            case 1027: {
                if (1056 == nodeVisualID) {
                    return true;
                }
                if (1058 != nodeVisualID) break;
                return true;
            }
            case 1024: {
                if (1050 == nodeVisualID) {
                    return true;
                }
                if (1051 != nodeVisualID) break;
                return true;
            }
            case 1012: {
                if (1010 == nodeVisualID) {
                    return true;
                }
                if (11 == nodeVisualID) {
                    return true;
                }
                if (1012 != nodeVisualID) break;
                return true;
            }
            case 1028: {
                if (1059 == nodeVisualID) {
                    return true;
                }
                if (5064 != nodeVisualID) break;
                return true;
            }
            case 3025: {
                if (5055 == nodeVisualID) {
                    return true;
                }
                if (1062 != nodeVisualID) break;
                return true;
            }
            case 3027: {
                if (5061 == nodeVisualID) {
                    return true;
                }
                if (1069 == nodeVisualID) {
                    return true;
                }
                if (1070 != nodeVisualID) break;
                return true;
            }
            case 1005: {
                if (1007 == nodeVisualID) {
                    return true;
                }
                if (1027 == nodeVisualID) {
                    return true;
                }
                if (1024 == nodeVisualID) {
                    return true;
                }
                if (1012 == nodeVisualID) {
                    return true;
                }
                if (1028 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 11: {
                if (1007 == nodeVisualID) {
                    return true;
                }
                if (1027 == nodeVisualID) {
                    return true;
                }
                if (1024 == nodeVisualID) {
                    return true;
                }
                if (1012 == nodeVisualID) {
                    return true;
                }
                if (1028 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 1042: {
                if (1023 == nodeVisualID) {
                    return true;
                }
                if (1027 == nodeVisualID) {
                    return true;
                }
                if (1024 == nodeVisualID) {
                    return true;
                }
                if (1012 == nodeVisualID) {
                    return true;
                }
                if (1028 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 == nodeVisualID) {
                    return true;
                }
                if (1007 == nodeVisualID) {
                    return true;
                }
                if (3028 != nodeVisualID) break;
                return true;
            }
            case 1051: {
                if (1023 == nodeVisualID) {
                    return true;
                }
                if (1027 == nodeVisualID) {
                    return true;
                }
                if (1024 == nodeVisualID) {
                    return true;
                }
                if (1012 == nodeVisualID) {
                    return true;
                }
                if (1028 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 == nodeVisualID) {
                    return true;
                }
                if (1007 == nodeVisualID) {
                    return true;
                }
                if (3028 != nodeVisualID) break;
                return true;
            }
            case 1071: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 1052: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 1019: {
                if (3020 != nodeVisualID) break;
                return true;
            }
            case 1053: {
                if (3020 != nodeVisualID) break;
                return true;
            }
            case 1057: {
                if (1007 == nodeVisualID) {
                    return true;
                }
                if (1027 == nodeVisualID) {
                    return true;
                }
                if (1024 == nodeVisualID) {
                    return true;
                }
                if (1012 == nodeVisualID) {
                    return true;
                }
                if (1028 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 1058: {
                if (1007 == nodeVisualID) {
                    return true;
                }
                if (1027 == nodeVisualID) {
                    return true;
                }
                if (1024 == nodeVisualID) {
                    return true;
                }
                if (1012 == nodeVisualID) {
                    return true;
                }
                if (1028 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 1062: {
                if (1037 != nodeVisualID) break;
                return true;
            }
            case 1063: {
                if (1037 != nodeVisualID) break;
                return true;
            }
            case 1067: {
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 1069: {
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 1068: {
                if (3019 != nodeVisualID) break;
                return true;
            }
            case 1070: {
                if (3019 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6005 == nodeVisualID) {
                    return true;
                }
                if (6033 == nodeVisualID) {
                    return true;
                }
                if (6034 != nodeVisualID) break;
                return true;
            }
            case 4019: {
                if (6024 == nodeVisualID) {
                    return true;
                }
                if (6035 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6007 != nodeVisualID) break;
                return true;
            }
            case 4008: {
                if (6026 == nodeVisualID) {
                    return true;
                }
                if (6027 != nodeVisualID) break;
                return true;
            }
            case 1064: {
                if (6020 == nodeVisualID) {
                    return true;
                }
                if (6021 != nodeVisualID) break;
                return true;
            }
            case 1065: {
                if (6022 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getExtension().isSuperTypeOf(domainElement.eClass())) {
            return 1013;
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getProfileApplication().isSuperTypeOf(domainElement.eClass())) {
            return 1045;
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
            return 4019;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return 4008;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return 4018;
        }
        if (UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) {
            return 1064;
        }
        if (UMLPackage.eINSTANCE.getPackageImport().isSuperTypeOf(domainElement.eClass())) {
            return 1065;
        }
        return -1;
    }

    private static boolean isDiagram(Profile element) {
        return true;
    }

    public static ViewInfo getDiagramViewInfo() {
        if (diagramViewInfo == null) {
            diagramViewInfo = UMLVisualIDRegistry.getProfile_1000ViewInfo();
        }
        return diagramViewInfo;
    }

    protected static ViewInfo getProfile_1000ViewInfo() {
        BaseViewInfo root = new BaseViewInfo(1000, 0, "", null, null);
        BaseViewInfo viewInfo = null;
        BaseViewInfo labelInfo = null;
        viewInfo = new BaseViewInfo(2014, 2, "Dependency");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2015, 2, "Association");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1026, 2, "Stereotype");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1031, 2, "Class");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1002, 2, "Comment");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1014, 2, "Constraint");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2005, 2, "Model");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1030, 2, "Profile");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2007, 2, "Package");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2006, 2, "Enumeration");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2009, 2, "PrimitiveType");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2010, 2, "DataType");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2016, 2, "Diagram");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1013, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4001, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6001, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6002, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6003, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6005, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6033, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6034, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(1045, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4019, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6024, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6035, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4002, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6007, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4008, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6026, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6027, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4018, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1064, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6020, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6021, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(1065, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6022, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(1022, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4014, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3026, 2, "PrimitiveType");
        root.addNode(1005, (ViewInfo)viewInfo);
        root.addNode(11, (ViewInfo)viewInfo);
        root.addNode(1051, (ViewInfo)viewInfo);
        root.addNode(1057, (ViewInfo)viewInfo);
        root.addNode(1058, (ViewInfo)viewInfo);
        root.addNode(1042, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3019, 2, "Operation");
        root.addNode(1070, (ViewInfo)viewInfo);
        root.addNode(1068, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1037, 2, "EnumerationLiteral");
        root.addNode(1063, (ViewInfo)viewInfo);
        root.addNode(1062, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3018, 2, "Property");
        root.addNode(1067, (ViewInfo)viewInfo);
        root.addNode(1069, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3002, 2, "Property");
        root.addNode(1052, (ViewInfo)viewInfo);
        root.addNode(1071, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3020, 2, "Operation");
        root.addNode(1053, (ViewInfo)viewInfo);
        root.addNode(1019, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1023, 2, "Stereotype");
        root.addNode(1051, (ViewInfo)viewInfo);
        root.addNode(1042, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3028, 2, "Class");
        root.addNode(1042, (ViewInfo)viewInfo);
        root.addNode(1051, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1007, 2, "Comment");
        root.addNode(1005, (ViewInfo)viewInfo);
        root.addNode(11, (ViewInfo)viewInfo);
        root.addNode(1058, (ViewInfo)viewInfo);
        root.addNode(1042, (ViewInfo)viewInfo);
        root.addNode(1051, (ViewInfo)viewInfo);
        root.addNode(1057, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1027, 2, "Model");
        root.addNode(1057, (ViewInfo)viewInfo);
        root.addNode(1058, (ViewInfo)viewInfo);
        root.addNode(1042, (ViewInfo)viewInfo);
        root.addNode(1051, (ViewInfo)viewInfo);
        root.addNode(1005, (ViewInfo)viewInfo);
        root.addNode(11, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1024, 2, "Profile");
        root.addNode(11, (ViewInfo)viewInfo);
        root.addNode(1005, (ViewInfo)viewInfo);
        root.addNode(1051, (ViewInfo)viewInfo);
        root.addNode(1042, (ViewInfo)viewInfo);
        root.addNode(1057, (ViewInfo)viewInfo);
        root.addNode(1058, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1012, 2, "Package");
        root.addNode(1005, (ViewInfo)viewInfo);
        root.addNode(11, (ViewInfo)viewInfo);
        root.addNode(1012, (ViewInfo)viewInfo);
        root.addNode(1051, (ViewInfo)viewInfo);
        root.addNode(1042, (ViewInfo)viewInfo);
        root.addNode(1058, (ViewInfo)viewInfo);
        root.addNode(1057, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(1028, 2, "Constraint");
        root.addNode(1058, (ViewInfo)viewInfo);
        root.addNode(1057, (ViewInfo)viewInfo);
        root.addNode(1051, (ViewInfo)viewInfo);
        root.addNode(1042, (ViewInfo)viewInfo);
        root.addNode(11, (ViewInfo)viewInfo);
        root.addNode(1005, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3025, 2, "Enumeration");
        root.addNode(1058, (ViewInfo)viewInfo);
        root.addNode(1057, (ViewInfo)viewInfo);
        root.addNode(1051, (ViewInfo)viewInfo);
        root.addNode(1042, (ViewInfo)viewInfo);
        root.addNode(11, (ViewInfo)viewInfo);
        root.addNode(1005, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3027, 2, "DataType");
        root.addNode(1005, (ViewInfo)viewInfo);
        root.addNode(11, (ViewInfo)viewInfo);
        root.addNode(1042, (ViewInfo)viewInfo);
        root.addNode(1051, (ViewInfo)viewInfo);
        root.addNode(1057, (ViewInfo)viewInfo);
        root.addNode(1058, (ViewInfo)viewInfo);
        return root;
    }
}

