/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Lifeline;

public class CombinedFragment2CreateCommand
extends EditElementCommand {
    private EClass eClass = null;
    private EObject eObject = null;

    public CombinedFragment2CreateCommand(CreateElementRequest req, EObject eObject) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
        this.eObject = eObject;
        this.eClass = eObject != null ? eObject.eClass() : null;
    }

    public static CombinedFragment2CreateCommand create(CreateElementRequest req, EObject eObject) {
        return new CombinedFragment2CreateCommand(req, eObject);
    }

    public CombinedFragment2CreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        if (container != null) {
            return container;
        }
        return this.eObject;
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object modelContainer = ((CreateElementRequest)this.getRequest()).getParameters().get("InteractionFragment Container");
        CombinedFragment combinedFragment = CommandHelper.doCreateCoRegion(modelContainer, (Lifeline)this.getElementToEdit());
        if (combinedFragment != null) {
            this.doConfigure(combinedFragment, monitor, info);
            ((CreateElementRequest)this.getRequest()).setNewElement((EObject)combinedFragment);
            return CommandResult.newOKCommandResult((Object)combinedFragment);
        }
        return CommandResult.newErrorCommandResult((String)"");
    }

    protected void doConfigure(CombinedFragment newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

