/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.sequence.providers.ElementInitializers;
import org.eclipse.papyrus.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.DestructionEvent;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class DestructionEventCreateCommand
extends EditElementCommand {
    private EClass eClass = null;
    private EObject eObject = null;

    public DestructionEventCreateCommand(CreateElementRequest req, EObject eObject) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
        this.eObject = eObject;
        this.eClass = eObject != null ? eObject.eClass() : null;
    }

    public static DestructionEventCreateCommand create(CreateElementRequest req, EObject eObject) {
        return new DestructionEventCreateCommand(req, eObject);
    }

    public DestructionEventCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        if (container != null) {
            return container;
        }
        return this.eObject;
    }

    public boolean canExecute() {
        Lifeline lifeline = (Lifeline)this.getElementToEdit();
        for (InteractionFragment ift : lifeline.getCoveredBys()) {
            OccurrenceSpecification os;
            if (!(ift instanceof OccurrenceSpecification) || !((os = (OccurrenceSpecification)ift).getEvent() instanceof DestructionEvent)) continue;
            return false;
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object modelContainer = ((CreateElementRequest)this.getRequest()).getParameters().get("InteractionFragment Container");
        DestructionEvent destructionEvent = CommandHelper.doCreateDestructionEvent((Lifeline)this.getElementToEdit(), modelContainer);
        ElementInitializers.getInstance().init_DestructionEvent_3022(destructionEvent);
        this.doConfigure(destructionEvent, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)destructionEvent);
        return CommandResult.newOKCommandResult((Object)destructionEvent);
    }

    protected void doConfigure(DestructionEvent newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

