/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.helper.DurationConstraintHelper;
import org.eclipse.papyrus.diagram.sequence.providers.ElementInitializers;
import org.eclipse.papyrus.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;

public class DurationConstraintCreateCommand
extends EditElementCommand {
    private EClass eClass = null;
    private EObject eObject = null;

    public DurationConstraintCreateCommand(CreateElementRequest req, EObject eObject) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
        this.eObject = eObject;
        this.eClass = eObject != null ? eObject.eClass() : null;
    }

    public static DurationConstraintCreateCommand create(CreateElementRequest req, EObject eObject) {
        return new DurationConstraintCreateCommand(req, eObject);
    }

    public DurationConstraintCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        if (container != null) {
            return container;
        }
        return this.eObject;
    }

    public boolean canExecute() {
        if (!this.getRequest().getParameters().containsKey("Nearest occurrence specification")) {
            return true;
        }
        Object paramOccurrence1 = this.getRequest().getParameter("Nearest occurrence specification");
        List<OccurrenceSpecification> occ1List = SequenceUtil.getAsOccSpecList(paramOccurrence1);
        if (occ1List.isEmpty()) {
            return false;
        }
        if (!this.getRequest().getParameters().containsKey("Nearest occurrence specification (end)")) {
            return true;
        }
        Object paramOccurrence2 = this.getRequest().getParameter("Nearest occurrence specification (end)");
        List<OccurrenceSpecification> occ2List = SequenceUtil.getAsOccSpecList(paramOccurrence2);
        if (occ2List.isEmpty()) {
            return false;
        }
        if (!Collections.disjoint(occ1List, occ2List)) {
            return false;
        }
        OccurrenceSpecification[] pair = SequenceUtil.getPairOfCorrespondingOccSpec(occ1List, occ2List);
        if (pair != null && pair.length > 1) {
            boolean enabled = DurationConstraintHelper.coversSameLifeline((OccurrenceSpecification)pair[0], (OccurrenceSpecification)pair[1]);
            return enabled |= DurationConstraintHelper.endsOfSameMessage((OccurrenceSpecification)pair[0], (OccurrenceSpecification)pair[1]);
        }
        return false;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        DurationConstraint newElement = UMLFactory.eINSTANCE.createDurationConstraint();
        Namespace owner = (Namespace)this.getElementToEdit().eContainer();
        owner.getOwnedRules().add((Object)newElement);
        ElementInitializers.getInstance().init_DurationConstraint_3021(newElement);
        Object paramOccurrence1 = this.getRequest().getParameter("Nearest occurrence specification");
        List<OccurrenceSpecification> occ1List = SequenceUtil.getAsOccSpecList(paramOccurrence1);
        Object paramOccurrence2 = this.getRequest().getParameter("Nearest occurrence specification (end)");
        List<OccurrenceSpecification> occ2List = SequenceUtil.getAsOccSpecList(paramOccurrence2);
        OccurrenceSpecification[] pair = SequenceUtil.getPairOfCorrespondingOccSpec(occ1List, occ2List);
        if (pair != null && pair.length > 1) {
            newElement.getConstrainedElements().add((Object)pair[0]);
            newElement.getConstrainedElements().add((Object)pair[1]);
        }
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(DurationConstraint newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

