/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.commands;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.sequence.providers.ElementInitializers;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.InteractionConstraint;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionOperandCreateCommand
extends EditElementCommand {
    private EClass eClass = null;
    private EObject eObject = null;

    public InteractionOperandCreateCommand(CreateElementRequest req, EObject eObject) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
        this.eObject = eObject;
        this.eClass = eObject != null ? eObject.eClass() : null;
    }

    public static InteractionOperandCreateCommand create(CreateElementRequest req, EObject eObject) {
        return new InteractionOperandCreateCommand(req, eObject);
    }

    public InteractionOperandCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        if (container != null) {
            return container;
        }
        return this.eObject;
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CombinedFragment owner = (CombinedFragment)this.getElementToEdit();
        Set coveredInteractionFragments = (Set)this.getRequest().getParameters().get("Covered InteractionFragments");
        InteractionOperand newElement = InteractionOperandCreateCommand.createInteractionOperand(owner, coveredInteractionFragments);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(InteractionOperand newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    public static InteractionOperand createInteractionOperand(CombinedFragment cf, Set<InteractionFragment> coveredInteractionFragments) {
        InteractionOperand newIO = UMLFactory.eINSTANCE.createInteractionOperand();
        cf.getOperands().add((Object)newIO);
        String base = newIO.eClass().getName();
        String name = ElementInitializers.getNextNumberedName((Collection)cf.getOperands(), base);
        newIO.setName(name);
        for (InteractionOperand operand : cf.getOperands()) {
            operand.getCovereds().addAll((Collection)cf.getCovereds());
        }
        InteractionConstraint guard = UMLFactory.eINSTANCE.createInteractionConstraint();
        newIO.setGuard(guard);
        LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
        literalString.setValue("undefined");
        guard.setSpecification((ValueSpecification)literalString);
        LiteralInteger min = UMLFactory.eINSTANCE.createLiteralInteger();
        min.setValue(0);
        guard.setMinint((ValueSpecification)min);
        LiteralInteger max = UMLFactory.eINSTANCE.createLiteralInteger();
        max.setValue(1);
        guard.setMaxint((ValueSpecification)max);
        if (coveredInteractionFragments != null) {
            InteractionOperand cfOwner = null;
            if (cf.getEnclosingOperand() != null) {
                cfOwner = cf.getEnclosingOperand();
            } else if (cf.getEnclosingInteraction() != null) {
                cfOwner = cf.getEnclosingInteraction();
            }
            if (cfOwner != null) {
                for (InteractionFragment ift : coveredInteractionFragments) {
                    if (!cfOwner.equals(ift.getEnclosingOperand()) && !cfOwner.equals(ift.getEnclosingInteraction())) continue;
                    ift.setEnclosingInteraction(null);
                    ift.setEnclosingOperand(newIO);
                }
            }
        }
        return newIO;
    }
}

