/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.sequence.providers.ElementInitializers;
import org.eclipse.papyrus.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.PartDecomposition;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifelineCreateCommand
extends EditElementCommand {
    private EClass eClass = null;
    private EObject eObject = null;
    private List<Property> availableProperties;

    public LifelineCreateCommand(CreateElementRequest req, EObject eObject) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
        this.eObject = eObject;
        this.eClass = eObject != null ? eObject.eClass() : null;
    }

    public static LifelineCreateCommand create(CreateElementRequest req, EObject eObject) {
        return new LifelineCreateCommand(req, eObject);
    }

    public LifelineCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        if (container != null) {
            return container;
        }
        return this.eObject;
    }

    public boolean canExecute() {
        return !(this.getElementToEdit() instanceof InteractionOperand);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject object = this.getElementToEdit();
        Interaction interactionOwner = null;
        Property property = null;
        Lifeline newElement = UMLFactory.eINSTANCE.createLifeline();
        if (object instanceof Lifeline) {
            Lifeline parentLifeline = (Lifeline)object;
            property = CommandHelper.getProperties(this.availableProperties);
            if (property == null) {
                return CommandResult.newCancelledCommandResult();
            }
            newElement.setRepresents((ConnectableElement)property);
            interactionOwner = parentLifeline.getInteraction();
            PartDecomposition partDecomposition = parentLifeline.getDecomposedAs();
            if (partDecomposition == null) {
                EList ifts = interactionOwner.getFragments();
                partDecomposition = UMLFactory.eINSTANCE.createPartDecomposition();
                partDecomposition.setName(ElementInitializers.getNextNumberedName((Collection)ifts, partDecomposition.eClass().getName()));
                ifts.add(partDecomposition);
                parentLifeline.setDecomposedAs(partDecomposition);
            }
            partDecomposition.getCovereds().add((Object)newElement);
        } else {
            interactionOwner = (Interaction)this.getElementToEdit();
        }
        interactionOwner.getLifelines().add((Object)newElement);
        ElementInitializers.getInstance().init_Lifeline_3001(newElement);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(Lifeline newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    public void setAvailableProperties(List<Property> availableProperties) {
        this.availableProperties = availableProperties;
    }
}

