/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.diagram.sequence.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.diagram.sequence.util.ReconnectMessageHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Message;

public class Message3ReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public Message3ReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Message)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Element) || !(this.newEnd instanceof Element)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Interaction)) {
            return false;
        }
        Interaction container = (Interaction)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistMessage_4005(container, this.getLink(), this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Element) || !(this.newEnd instanceof Element)) {
            return false;
        }
        Element source = this.getLink().getOwner();
        if (!(this.getLink().eContainer() instanceof Interaction)) {
            return false;
        }
        Interaction container = (Interaction)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistMessage_4005(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        ReconnectMessageHelper.updateMessageEnd(this.getLink().getSendEvent(), this.getOldSource(), this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        ReconnectMessageHelper.updateMessageEnd(this.getLink().getReceiveEvent(), this.getOldTarget(), this.getNewTarget());
        ReconnectMessageHelper.updateMessage(this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Message getLink() {
        return (Message)this.getElementToEdit();
    }

    protected Element getOldSource() {
        return (Element)this.oldEnd;
    }

    protected Element getNewSource() {
        return (Element)this.newEnd;
    }

    protected Element getOldTarget() {
        return (Element)this.oldEnd;
    }

    protected Element getNewTarget() {
        return (Element)this.newEnd;
    }
}

