/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.sequence.providers.ElementInitializers;
import org.eclipse.papyrus.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.UMLFactory;

public class TimeConstraintCreateCommand
extends EditElementCommand {
    private EClass eClass = null;
    private EObject eObject = null;

    public TimeConstraintCreateCommand(CreateElementRequest req, EObject eObject) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
        this.eObject = eObject;
        this.eClass = eObject != null ? eObject.eClass() : null;
    }

    public static TimeConstraintCreateCommand create(CreateElementRequest req, EObject eObject) {
        return new TimeConstraintCreateCommand(req, eObject);
    }

    public TimeConstraintCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        if (container != null) {
            return container;
        }
        return this.eObject;
    }

    public boolean canExecute() {
        Object paramOccurrence = this.getRequest().getParameter("Nearest occurrence specification");
        List<OccurrenceSpecification> occList = SequenceUtil.getAsOccSpecList(paramOccurrence);
        if (!occList.isEmpty()) {
            for (OccurrenceSpecification occurrence : occList) {
                Message mess;
                if (occurrence instanceof MessageOccurrenceSpecification && (mess = ((MessageOccurrenceSpecification)occurrence).getMessage()).getReceiveEvent().equals(occurrence) && MessageSort.SYNCH_CALL_LITERAL.equals((Object)mess.getMessageSort())) continue;
                return true;
            }
        }
        return false;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        TimeConstraint newElement = UMLFactory.eINSTANCE.createTimeConstraint();
        Namespace owner = (Namespace)this.getElementToEdit().eContainer();
        owner.getOwnedRules().add((Object)newElement);
        ElementInitializers.getInstance().init_TimeConstraint_3019(newElement);
        Object paramOccurrence = this.getRequest().getParameter("Nearest occurrence specification");
        List<OccurrenceSpecification> occList = SequenceUtil.getAsOccSpecList(paramOccurrence);
        if (!occList.isEmpty()) {
            for (OccurrenceSpecification occurrence : occList) {
                Message mess;
                if (occurrence instanceof MessageOccurrenceSpecification && (mess = ((MessageOccurrenceSpecification)occurrence).getMessage()).getReceiveEvent().equals(occurrence) && MessageSort.SYNCH_CALL_LITERAL.equals((Object)mess.getMessageSort())) continue;
                newElement.getConstrainedElements().add((Object)occurrence);
                break;
            }
        }
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(TimeConstraint newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

