/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class InteractionFragmentEditPart
extends ShapeNodeEditPart {
    public InteractionFragmentEditPart(View view) {
        super(view);
    }

    public void resizeInteractionFragmentFigure() {
        List childrenEditPart;
        EList lifelineCoveredList;
        EObject element;
        Object obj = this.getModel();
        if (obj instanceof Shape && (element = ((Shape)obj).getElement()) instanceof InteractionFragment && (lifelineCoveredList = ((InteractionFragment)element).getCovereds()) != null && this.getParent() != null && (childrenEditPart = this.getParent().getChildren()) != null) {
            int minX = Integer.MAX_VALUE;
            int maxX = -2147483647;
            int maxR = -2147483647;
            for (EditPart childEditPart : childrenEditPart) {
                EObject childElement;
                Object childModel;
                if (!(childEditPart instanceof LifelineEditPart) || !((childModel = childEditPart.getModel()) instanceof Shape) || !((childElement = ((Shape)childModel).getElement()) instanceof Lifeline)) continue;
                Lifeline lifeline = (Lifeline)childElement;
                for (Lifeline lfn : lifelineCoveredList) {
                    if (!lifeline.equals(lfn)) continue;
                    LifelineEditPart liflelineEditPart = (LifelineEditPart)childEditPart;
                    if (liflelineEditPart.getFigure().getBounds().x > maxX) {
                        maxX = liflelineEditPart.getFigure().getBounds().x;
                        maxR = liflelineEditPart.getFigure().getBounds().right();
                    }
                    if (liflelineEditPart.getFigure().getBounds().x >= minX) continue;
                    minX = liflelineEditPart.getFigure().getBounds().x;
                }
            }
            if (minX != Integer.MAX_VALUE || maxR != -2147483647) {
                this.getNewSize(minX, maxR);
            }
        }
    }

    private void getNewSize(int min, int max) {
        int h = this.getFigure().getBounds().height;
        int y = this.getFigure().getBounds().y;
        Dimension size = new Dimension(max - min, h);
        Point loc = new Point(min, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    public void updateCoveredLifelines(Bounds newBounds) {
        Rectangle newBound = new Rectangle(newBounds.getX(), newBounds.getY(), newBounds.getWidth(), newBounds.getHeight());
        InteractionFragment combinedFragment = (InteractionFragment)this.resolveSemanticElement();
        EList coveredLifelines = combinedFragment.getCovereds();
        ArrayList<Lifeline> coveredLifelinesToAdd = new ArrayList<Lifeline>();
        ArrayList<Lifeline> coveredLifelinesToRemove = new ArrayList<Lifeline>();
        for (Object child : this.getParent().getChildren()) {
            if (!(child instanceof LifelineEditPart)) continue;
            LifelineEditPart lifelineEditPart = (LifelineEditPart)((Object)child);
            Lifeline lifeline = (Lifeline)lifelineEditPart.resolveSemanticElement();
            if (newBound.intersects(lifelineEditPart.getFigure().getBounds())) {
                if (coveredLifelines.contains((Object)lifeline)) continue;
                coveredLifelinesToAdd.add(lifeline);
                continue;
            }
            if (!coveredLifelines.contains((Object)lifeline)) continue;
            coveredLifelinesToRemove.add(lifeline);
        }
        if (!coveredLifelinesToAdd.isEmpty()) {
            CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)combinedFragment, (Object)UMLPackage.eINSTANCE.getInteractionFragment_Covered(), coveredLifelinesToAdd));
        }
        if (!coveredLifelinesToRemove.isEmpty()) {
            CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)combinedFragment, (Object)UMLPackage.eINSTANCE.getInteractionFragment_Covered(), coveredLifelinesToRemove));
        }
    }
}

