/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.diagram.sequence.edit.parts.ActionExecutionSpecificationEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.BehaviorExecutionSpecificationEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.CombinedFragment2EditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.CommentEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.ConsiderIgnoreFragmentEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.ConstraintEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.ContinuationEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.DestructionEventEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.DurationConstraintEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.DurationConstraintInMessageEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.DurationObservationEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.InteractionFragmentEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.InteractionUseName2EditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.InteractionUseNameEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.StateInvariantEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.TimeConstraintEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.TimeObservationEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.policies.InteractionUseItemSemanticEditPolicy;
import org.eclipse.papyrus.diagram.sequence.edit.policies.OpenDiagramEditPolicy;
import org.eclipse.papyrus.diagram.sequence.figures.InteractionUseRectangleFigure;
import org.eclipse.papyrus.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.diagram.sequence.util.NotificationHelper;
import org.eclipse.papyrus.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.preferences.utils.PreferenceConstantHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionUseEditPart
extends InteractionFragmentEditPart {
    public static final int VISUAL_ID = 3002;
    private static final String NO_ACTUAL_GATE_MANUAL_CREATION_DLG_TITLE = "No manual creation of actual gate";
    private static final String NO_ACTUAL_GATE_MANUAL_CREATION_DLG_MSG = "It's forbidden to create actual gate";
    private static final String NO_ACTUAL_GATE_MANUAL_DELETION_DLG_TITLE = "No manual deletion of actual gate";
    private static final String NO_ACTUAL_GATE_MANUAL_DELETION_DLG_MSG = "It's forbidden to delete actual gate";
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private NotificationHelper notifier = new NotificationHelper(new UIAdapterImpl(){

        protected void safeNotifyChanged(Notification msg) {
            InteractionUseEditPart.this.handleNotificationEvent(msg);
        }
    });

    public InteractionUseEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new InteractionUseItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenDiagramEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new InteractionUseRectangleFigure();
        return this.primaryShape;
    }

    public InteractionUseRectangleFigure getPrimaryShape() {
        return (InteractionUseRectangleFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof InteractionUseNameEditPart) {
            ((InteractionUseNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getHeaderLabel());
            return true;
        }
        if (childEditPart instanceof InteractionUseName2EditPart) {
            ((InteractionUseName2EditPart)childEditPart).setLabel(this.getPrimaryShape().getCenterLabel());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof InteractionUseNameEditPart) {
            return true;
        }
        return childEditPart instanceof InteractionUseName2EditPart;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        String prefElementId = "InteractionUse";
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)16);
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight));
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5003));
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        Object result = null;
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor() || feature == NotationPackage.eINSTANCE.getFontStyle_FontColor() || feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            String prefColor = null;
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"InteractionUse", (int)3);
            } else if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"InteractionUse", (int)2);
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"InteractionUse", (int)0);
            }
            result = FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)prefColor));
        } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency() || feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
            String prefGradient = PreferenceConstantHelper.getElementConstant((String)"InteractionUse", (int)4);
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(preferenceStore.getString(prefGradient));
            if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency()) {
                result = new Integer(gradientPreferenceConverter.getTransparency());
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
                result = gradientPreferenceConverter.getGradientData();
            }
        }
        if (result == null) {
            result = this.getStructuralFeatureValue(feature);
        }
        return result;
    }

    public List<IElementType> getMARelTypesOnSource() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(7);
        types.add(UMLElementTypes.Message_4003);
        types.add(UMLElementTypes.Message_4004);
        types.add(UMLElementTypes.Message_4005);
        types.add(UMLElementTypes.Message_4006);
        types.add(UMLElementTypes.Message_4007);
        types.add(UMLElementTypes.Message_4008);
        types.add(UMLElementTypes.Message_4009);
        return types;
    }

    public List<IElementType> getMARelTypesOnSourceAndTarget(IGraphicalEditPart targetEditPart) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof DestructionEventEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof DestructionEventEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof DestructionEventEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof DestructionEventEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof DestructionEventEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof DestructionEventEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof DestructionEventEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        return types;
    }

    public List<IElementType> getMATypesForTarget(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == UMLElementTypes.Message_4003) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4004) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4005) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4006) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4007) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4008) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4009) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        }
        return types;
    }

    public List<IElementType> getMARelTypesOnTarget() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(9);
        types.add(UMLElementTypes.Message_4003);
        types.add(UMLElementTypes.Message_4004);
        types.add(UMLElementTypes.Message_4005);
        types.add(UMLElementTypes.Message_4006);
        types.add(UMLElementTypes.Message_4007);
        types.add(UMLElementTypes.Message_4008);
        types.add(UMLElementTypes.Message_4009);
        types.add(UMLElementTypes.CommentAnnotatedElement_4010);
        types.add(UMLElementTypes.ConstraintConstrainedElement_4011);
        return types;
    }

    public List<IElementType> getMATypesForSource(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == UMLElementTypes.Message_4003) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4004) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4005) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4006) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4007) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4008) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4009) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionEvent_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.CommentAnnotatedElement_4010) {
            types.add(UMLElementTypes.Comment_3009);
        } else if (relationshipType == UMLElementTypes.ConstraintConstrainedElement_4011) {
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.DurationConstraint_3023);
        }
        return types;
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (UMLPackage.eINSTANCE.getInteractionUse_RefersTo().equals(feature)) {
            if (notification.getOldValue() instanceof Interaction) {
                this.notifier.unlistenAll();
            }
            InteractionUse interactionUse = (InteractionUse)this.resolveSemanticElement();
            CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)interactionUse, (Object)UMLPackage.eINSTANCE.getInteractionUse_ActualGate(), (Collection)interactionUse.getActualGates()));
            if (notification.getNewValue() instanceof Interaction) {
                Interaction interaction = (Interaction)notification.getNewValue();
                this.notifier.listenObject((Notifier)interaction);
                EList actualGates = interactionUse.getActualGates();
                EList formalGates = interaction.getFormalGates();
                for (Gate formalGate : formalGates) {
                    Gate newActualGate = (Gate)EcoreUtil.create((EClass)UMLPackage.Literals.GATE);
                    newActualGate.setName(formalGate.getName());
                    CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.resolveSemanticElement(), (Object)UMLPackage.eINSTANCE.getInteractionUse_ActualGate(), (Object)newActualGate));
                    this.notifier.listenObject((Notifier)formalGate);
                    this.notifier.listenObject((Notifier)newActualGate);
                }
            }
        } else if (UMLPackage.eINSTANCE.getInteractionFragment_Covered().equals(feature)) {
            this.activate();
            this.resizeInteractionFragmentFigure();
        } else if (UMLPackage.eINSTANCE.getInteraction_FormalGate().equals(feature)) {
            Object newValue;
            InteractionUse interactionUse = (InteractionUse)this.resolveSemanticElement();
            Object oldValue = notification.getOldValue();
            if (oldValue instanceof Gate) {
                this.notifier.unlistenObject((Notifier)((Gate)oldValue));
                EList actualGates = interactionUse.getActualGates();
                int i = actualGates.size() - 1;
                while (i >= 0) {
                    Gate element = (Gate)actualGates.get(i);
                    if (((Gate)oldValue).getName().equals(element.getName())) {
                        this.notifier.unlistenObject((Notifier)element);
                        CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)interactionUse, (Object)UMLPackage.eINSTANCE.getInteractionUse_ActualGate(), (Object)element));
                    }
                    --i;
                }
            }
            if ((newValue = notification.getNewValue()) instanceof Gate) {
                Gate actualGate = interactionUse.createActualGate(((Gate)newValue).getName());
                this.notifier.listenObject((Notifier)((Gate)newValue));
                this.notifier.listenObject((Notifier)actualGate);
            }
        } else if (UMLPackage.eINSTANCE.getInteractionUse_ActualGate().equals(feature)) {
            Gate oldActualGate;
            if (notification.getEventType() == 3) {
                Gate newActualGate;
                if (notification.getNewValue() instanceof Gate && !this.checkActualGateExistence(newActualGate = (Gate)notification.getNewValue())) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NO_ACTUAL_GATE_MANUAL_CREATION_DLG_TITLE, (String)NO_ACTUAL_GATE_MANUAL_CREATION_DLG_MSG);
                    CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.resolveSemanticElement(), (Object)UMLPackage.eINSTANCE.getInteractionUse_ActualGate(), (Object)newActualGate));
                }
            } else if (notification.getEventType() == 4 && notification.getOldValue() instanceof Gate && this.checkActualGateExistence(oldActualGate = (Gate)notification.getOldValue())) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NO_ACTUAL_GATE_MANUAL_DELETION_DLG_TITLE, (String)NO_ACTUAL_GATE_MANUAL_DELETION_DLG_MSG);
                CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.resolveSemanticElement(), (Object)UMLPackage.eINSTANCE.getInteractionUse_ActualGate(), (Object)oldActualGate));
            }
        } else if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) && notification.getNotifier() instanceof Gate) {
            Gate gate = (Gate)notification.getNotifier();
            if (gate.eContainer() instanceof Interaction) {
                InteractionUse interactionUse = (InteractionUse)this.resolveSemanticElement();
                EList actualGates = interactionUse.getActualGates();
                String oldValue = notification.getOldStringValue();
                String newValue = notification.getNewStringValue();
                for (Gate actualGate : actualGates) {
                    if ((oldValue != null || actualGate.getName() != null) && (oldValue == null || !oldValue.equals(actualGate.getName()))) continue;
                    this.notifier.unlistenObject((Notifier)actualGate);
                    actualGate.setName(newValue);
                    this.notifier.listenObject((Notifier)actualGate);
                }
            } else if (gate.eContainer() instanceof InteractionUse) {
                this.notifier.unlistenObject((Notifier)gate);
                gate.setName(notification.getOldStringValue());
                this.notifier.listenObject((Notifier)gate);
            }
        }
        super.handleNotificationEvent(notification);
    }

    private boolean checkActualGateExistence(Gate actualGate) {
        InteractionUse interactionUse = (InteractionUse)this.resolveSemanticElement();
        Interaction interaction = interactionUse.getRefersTo();
        if (interaction != null) {
            for (Gate formalGate : interaction.getFormalGates()) {
                if (!formalGate.getName().equals(actualGate.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void activate() {
        super.activate();
        if (this.resolveSemanticElement() instanceof InteractionUse) {
            InteractionUse interactionUse = (InteractionUse)this.resolveSemanticElement();
            Interaction interaction = interactionUse.getRefersTo();
            if (interaction != null) {
                this.notifier.listenObject((Notifier)interaction);
                for (Gate formalGate : interaction.getFormalGates()) {
                    this.notifier.listenObject((Notifier)formalGate);
                }
            }
            for (Gate actualGate : interactionUse.getActualGates()) {
                this.notifier.listenObject((Notifier)actualGate);
            }
        }
    }

    public void deactivate() {
        super.deactivate();
        this.notifier.unlistenAll();
    }

    public void removeNotify() {
        this.notifier.unlistenAll();
        super.removeNotify();
    }
}

