/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.editpolicies.AppliedStereotypeLinkLabelDisplayEditPolicy;
import org.eclipse.papyrus.diagram.common.figure.edge.UMLEdgeFigure;
import org.eclipse.papyrus.diagram.sequence.edit.parts.MessageCreateAppliedStereotypeEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.MessageName4EditPart;
import org.eclipse.papyrus.diagram.sequence.edit.policies.CreationOnMessageEditPolicy;
import org.eclipse.papyrus.diagram.sequence.edit.policies.LifelineChildGraphicalNodeEditPolicy;
import org.eclipse.papyrus.diagram.sequence.edit.policies.Message4ItemSemanticEditPolicy;
import org.eclipse.papyrus.diagram.sequence.edit.policies.MessageConnectionEditPolicy;
import org.eclipse.papyrus.diagram.sequence.edit.policies.MessageConnectionLineSegEditPolicy;
import org.eclipse.papyrus.diagram.sequence.util.SequenceUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;

public class Message4EditPart
extends ConnectionNodeEditPart
implements ITreeBranchEditPart {
    public static final int VISUAL_ID = 4006;
    static final Font FFIGUREMESSAGECREATELABELFIGURE_FONT = new Font((Device)Display.getCurrent(), "SANS", 9, 0);

    public Message4EditPart(View view) {
        super(view);
    }

    protected void installRouter() {
        this.getConnectionFigure().setConnectionRouter(LifelineChildGraphicalNodeEditPolicy.messageRouter);
        this.getConnectionFigure().setCursor(Cursors.ARROW);
        this.refreshBendpoints();
    }

    protected void refreshRoutingStyles() {
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new Message4ItemSemanticEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationOnMessageEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new MessageConnectionEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeLinkLabelDisplayEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new MessageConnectionLineSegEditPolicy());
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof MessageName4EditPart) {
            ((MessageName4EditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureMessageCreateLabelFigure());
            return true;
        }
        if (childEditPart instanceof MessageCreateAppliedStereotypeEditPart) {
            ((MessageCreateAppliedStereotypeEditPart)childEditPart).setLabel(this.getPrimaryShape().getAppliedStereotypeLabel());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof MessageName4EditPart) {
            return true;
        }
        return childEditPart instanceof MessageCreateAppliedStereotypeEditPart;
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected Connection createConnectionFigure() {
        return new MessageCreate();
    }

    public MessageCreate getPrimaryShape() {
        return (MessageCreate)this.getFigure();
    }

    protected void handleNotificationEvent(Notification notification) {
        SequenceUtil.handleMessageSortChange((EditingDomain)this.getEditingDomain(), notification, (Message)this.resolveSemanticElement(), MessageSort.ASYNCH_CALL_LITERAL);
        super.handleNotificationEvent(notification);
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getSource().showSourceFeedback(request);
            this.getTarget().showSourceFeedback(request);
        }
        super.showSourceFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getSource().eraseSourceFeedback(request);
            this.getTarget().eraseSourceFeedback(request);
        }
        super.eraseSourceFeedback(request);
    }

    public class MessageCreate
    extends UMLEdgeFigure {
        private WrappingLabel fFigureMessageCreateLabelFigure;
        private WrappingLabel fAppliedStereotypeLabel;

        public MessageCreate() {
            this.setLineStyle(2);
            this.setForegroundColor(ColorConstants.black);
            this.createContents();
            this.setTargetDecoration(this.createTargetDecoration());
        }

        protected void createContents() {
            super.createContents();
            this.fFigureMessageCreateLabelFigure = new WrappingLabel();
            this.fFigureMessageCreateLabelFigure.setText("");
            this.fFigureMessageCreateLabelFigure.setFont(FFIGUREMESSAGECREATELABELFIGURE_FONT);
            this.add((IFigure)this.fFigureMessageCreateLabelFigure);
        }

        private RotatableDecoration createTargetDecoration() {
            PolylineDecoration df = new PolylineDecoration();
            df.setForegroundColor(ColorConstants.black);
            PointList pl = new PointList();
            pl.addPoint(Message4EditPart.this.getMapMode().DPtoLP(-2), Message4EditPart.this.getMapMode().DPtoLP(2));
            pl.addPoint(Message4EditPart.this.getMapMode().DPtoLP(0), Message4EditPart.this.getMapMode().DPtoLP(0));
            pl.addPoint(Message4EditPart.this.getMapMode().DPtoLP(-2), Message4EditPart.this.getMapMode().DPtoLP(-2));
            df.setTemplate(pl);
            df.setScale((double)Message4EditPart.this.getMapMode().DPtoLP(7), (double)Message4EditPart.this.getMapMode().DPtoLP(3));
            return df;
        }

        public WrappingLabel getFigureMessageCreateLabelFigure() {
            return this.fFigureMessageCreateLabelFigure;
        }

        public WrappingLabel getAppliedStereotypeLabel() {
            return super.getAppliedStereotypeLabel();
        }
    }
}

