/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.parts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.editpolicies.AppliedStereotypeLinkLabelDisplayEditPolicy;
import org.eclipse.papyrus.diagram.common.figure.edge.UMLEdgeFigure;
import org.eclipse.papyrus.diagram.sequence.edit.parts.MessageNameEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.MessageSyncAppliedStereotypeEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.policies.CreationOnMessageEditPolicy;
import org.eclipse.papyrus.diagram.sequence.edit.policies.LifelineChildGraphicalNodeEditPolicy;
import org.eclipse.papyrus.diagram.sequence.edit.policies.MessageConnectionEditPolicy;
import org.eclipse.papyrus.diagram.sequence.edit.policies.MessageConnectionLineSegEditPolicy;
import org.eclipse.papyrus.diagram.sequence.edit.policies.MessageItemSemanticEditPolicy;
import org.eclipse.papyrus.diagram.sequence.util.SequenceUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;

public class MessageEditPart
extends ConnectionNodeEditPart
implements ITreeBranchEditPart {
    public static final int VISUAL_ID = 4003;
    static final Font FFIGUREMESSAGESYNCLABELFIGURE_FONT = new Font((Device)Display.getCurrent(), "SANS", 9, 0);

    public MessageEditPart(View view) {
        super(view);
    }

    protected void installRouter() {
        this.getConnectionFigure().setConnectionRouter(LifelineChildGraphicalNodeEditPolicy.messageRouter);
        this.getConnectionFigure().setCursor(Cursors.ARROW);
        this.refreshBendpoints();
    }

    protected void refreshRoutingStyles() {
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new MessageItemSemanticEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationOnMessageEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new MessageConnectionEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeLinkLabelDisplayEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new MessageConnectionLineSegEditPolicy());
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof MessageNameEditPart) {
            ((MessageNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureMessageSyncLabelFigure());
            return true;
        }
        if (childEditPart instanceof MessageSyncAppliedStereotypeEditPart) {
            ((MessageSyncAppliedStereotypeEditPart)childEditPart).setLabel(this.getPrimaryShape().getAppliedStereotypeLabel());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof MessageNameEditPart) {
            return true;
        }
        return childEditPart instanceof MessageSyncAppliedStereotypeEditPart;
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected Connection createConnectionFigure() {
        return new MessageSync();
    }

    public MessageSync getPrimaryShape() {
        return (MessageSync)this.getFigure();
    }

    protected void handleNotificationEvent(Notification notification) {
        SequenceUtil.handleMessageSortChange((EditingDomain)this.getEditingDomain(), notification, (Message)this.resolveSemanticElement(), MessageSort.ASYNCH_CALL_LITERAL);
        super.handleNotificationEvent(notification);
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getSource().showSourceFeedback(request);
            this.getTarget().showSourceFeedback(request);
        }
        super.showSourceFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getSource().eraseSourceFeedback(request);
            this.getTarget().eraseSourceFeedback(request);
        }
        super.eraseSourceFeedback(request);
    }

    public class MessageSync
    extends UMLEdgeFigure {
        private WrappingLabel fFigureMessageSyncLabelFigure;
        private WrappingLabel fAppliedStereotypeLabel;

        public MessageSync() {
            this.setForegroundColor(ColorConstants.black);
            this.createContents();
            this.setTargetDecoration(this.createTargetDecoration());
        }

        protected void createContents() {
            super.createContents();
            this.fFigureMessageSyncLabelFigure = new WrappingLabel();
            this.fFigureMessageSyncLabelFigure.setText("");
            this.fFigureMessageSyncLabelFigure.setFont(FFIGUREMESSAGESYNCLABELFIGURE_FONT);
            this.fFigureMessageSyncLabelFigure.setBorder((Border)new MarginBorder(MessageEditPart.this.getMapMode().DPtoLP(0), MessageEditPart.this.getMapMode().DPtoLP(0), MessageEditPart.this.getMapMode().DPtoLP(0), MessageEditPart.this.getMapMode().DPtoLP(0)));
            this.add((IFigure)this.fFigureMessageSyncLabelFigure);
        }

        private RotatableDecoration createTargetDecoration() {
            PolygonDecoration df = new PolygonDecoration();
            df.setFill(true);
            df.setForegroundColor(ColorConstants.black);
            df.setBackgroundColor(ColorConstants.black);
            PointList pl = new PointList();
            pl.addPoint(MessageEditPart.this.getMapMode().DPtoLP(-2), MessageEditPart.this.getMapMode().DPtoLP(2));
            pl.addPoint(MessageEditPart.this.getMapMode().DPtoLP(0), MessageEditPart.this.getMapMode().DPtoLP(0));
            pl.addPoint(MessageEditPart.this.getMapMode().DPtoLP(-2), MessageEditPart.this.getMapMode().DPtoLP(-2));
            pl.addPoint(MessageEditPart.this.getMapMode().DPtoLP(-2), MessageEditPart.this.getMapMode().DPtoLP(2));
            df.setTemplate(pl);
            df.setScale((double)MessageEditPart.this.getMapMode().DPtoLP(7), (double)MessageEditPart.this.getMapMode().DPtoLP(3));
            return df;
        }

        public WrappingLabel getFigureMessageSyncLabelFigure() {
            return this.fFigureMessageSyncLabelFigure;
        }

        public WrappingLabel getAppliedStereotypeLabel() {
            return super.getAppliedStereotypeLabel();
        }
    }
}

