/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.policies;

import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.InteractionFragment;

public class CombinedFragmentCreationEditPolicy
extends CreationEditPolicy {
    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        if (CombinedFragmentCreationEditPolicy.isDerivedCombinedFragment(request.getViewAndElementDescriptor().getSemanticHint())) {
            Rectangle selectionRect = this.getSelectionRectangle(request);
            Set<InteractionFragment> coveredInteractionFragments = SequenceUtil.getCoveredInteractionFragments(selectionRect, this.getHost(), null);
            request.getExtendedData().put("Covered InteractionFragments", coveredInteractionFragments);
        }
        return super.getCreateElementAndViewCommand(request);
    }

    private Rectangle getSelectionRectangle(CreateViewAndElementRequest request) {
        Rectangle selectionRect = new Rectangle();
        Point location = request.getLocation();
        Dimension size = request.getSize();
        if (location != null) {
            selectionRect.x = location.x;
            selectionRect.y = location.y;
        } else {
            selectionRect.x = 100;
            selectionRect.y = 100;
        }
        if (size != null) {
            selectionRect.height = size.height;
            selectionRect.width = size.width;
        } else {
            selectionRect.height = 61;
            selectionRect.width = 112;
        }
        return selectionRect;
    }

    private static boolean isDerivedCombinedFragment(String hint) {
        if (((IHintedType)UMLElementTypes.InteractionOperand_3005).getSemanticHint().equals(hint)) {
            return true;
        }
        if (((IHintedType)UMLElementTypes.CombinedFragment_3004).getSemanticHint().equals(hint)) {
            return true;
        }
        return ((IHintedType)UMLElementTypes.ConsiderIgnoreFragment_3007).getSemanticHint().equals(hint);
    }
}

