/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.CommandProxyWithResult;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.diagram.common.editpolicies.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.diagram.common.helper.DurationConstraintHelper;
import org.eclipse.papyrus.diagram.common.helper.DurationObservationHelper;
import org.eclipse.papyrus.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.diagram.sequence.command.CreateLocatedConnectionViewCommand;
import org.eclipse.papyrus.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.diagram.sequence.util.SequenceLinkMappingHelper;
import org.eclipse.papyrus.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.DestructionEvent;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.TimeObservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)SequenceLinkMappingHelper.getInstance());
    }

    protected Set<Integer> getDroppableElementVisualId() {
        HashSet<Integer> elementsVisualId = new HashSet<Integer>();
        elementsVisualId.add(3003);
        elementsVisualId.add(3006);
        elementsVisualId.add(4003);
        elementsVisualId.add(4004);
        elementsVisualId.add(4005);
        elementsVisualId.add(4006);
        elementsVisualId.add(4006);
        elementsVisualId.add(4007);
        elementsVisualId.add(4008);
        elementsVisualId.add(4009);
        elementsVisualId.add(4008);
        elementsVisualId.add(4012);
        elementsVisualId.add(3022);
        elementsVisualId.add(3017);
        elementsVisualId.add(3019);
        elementsVisualId.add(3021);
        elementsVisualId.add(3023);
        elementsVisualId.add(3020);
        elementsVisualId.add(3024);
        elementsVisualId.add(3001);
        elementsVisualId.add(-1);
        return elementsVisualId;
    }

    public IElementType getUMLElementType(int elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    public int getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public int getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID, int linkVISUALID) {
        Point location = dropRequest.getLocation().getCopy();
        Command cmd = this.handleNodeOnMessage(semanticLink, nodeVISUALID, linkVISUALID);
        if (cmd != null) {
            return cmd;
        }
        if (nodeVISUALID != -1) {
            switch (nodeVISUALID) {
                case 3003: 
                case 3006: {
                    return this.dropExecutionSpecification((ExecutionSpecification)semanticLink, nodeVISUALID, location);
                }
                case 3022: {
                    return this.dropDestructionEvent((DestructionEvent)semanticLink, nodeVISUALID, location);
                }
                case 3017: {
                    return this.dropStateInvariant((StateInvariant)semanticLink, nodeVISUALID, location);
                }
                case 3019: 
                case 3021: {
                    return this.dropIntervalConstraintInLifeline((IntervalConstraint)semanticLink, nodeVISUALID);
                }
                case 3020: {
                    return this.dropTimeObservationInLifeline((TimeObservation)semanticLink, nodeVISUALID);
                }
                case 3001: {
                    return this.dropLifeline((Lifeline)semanticLink, nodeVISUALID, location);
                }
            }
            return UnexecutableCommand.INSTANCE;
        }
        if (linkVISUALID != -1) {
            switch (linkVISUALID) {
                case 4003: 
                case 4004: 
                case 4005: 
                case 4006: 
                case 4007: 
                case 4008: 
                case 4009: {
                    return this.dropMessage(dropRequest, semanticLink, linkVISUALID);
                }
                case 4012: {
                    return this.dropGeneralOrdering(dropRequest, semanticLink, linkVISUALID);
                }
            }
            return UnexecutableCommand.INSTANCE;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropLifeline(Lifeline lifeline, int nodeVISUALID, Point location) {
        if (this.getHostObject().equals(lifeline.getOwner())) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)lifeline));
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command handleNodeOnMessage(Element semanticElement, int nodeVISUALID, int linkVISUALID) {
        EList events;
        if (nodeVISUALID == -1 && linkVISUALID == -1 && semanticElement instanceof DurationObservation && (events = ((DurationObservation)semanticElement).getEvents()).size() >= 2) {
            return this.dropMessageNodeBetweenEvents(semanticElement, (Element)events.get(0), (Element)events.get(1));
        }
        if (this.isDurationConstraintHint(nodeVISUALID, linkVISUALID) && semanticElement instanceof DurationConstraint && (events = ((DurationConstraint)semanticElement).getConstrainedElements()).size() >= 2) {
            return this.dropMessageNodeBetweenEvents(semanticElement, (Element)events.get(0), (Element)events.get(1));
        }
        return null;
    }

    private Command dropMessageNodeBetweenEvents(Element droppedElement, Element event1, Element event2) {
        if (event1 instanceof MessageOccurrenceSpecification && event2 instanceof MessageOccurrenceSpecification && !event1.equals(event2)) {
            boolean endsOfSameMessage = false;
            int visualId = -1;
            if (droppedElement instanceof DurationConstraint) {
                visualId = 3023;
                endsOfSameMessage = DurationConstraintHelper.endsOfSameMessage((OccurrenceSpecification)((OccurrenceSpecification)event1), (OccurrenceSpecification)((OccurrenceSpecification)event2));
            } else if (droppedElement instanceof DurationObservation) {
                visualId = 3024;
                endsOfSameMessage = DurationObservationHelper.endsOfSameMessage((OccurrenceSpecification)((OccurrenceSpecification)event1), (OccurrenceSpecification)((OccurrenceSpecification)event2));
            }
            if (endsOfSameMessage) {
                Message message = ((MessageOccurrenceSpecification)event1).getMessage();
                DiagramEditPart diag = DiagramEditPartsUtil.getDiagramEditPart((EditPart)this.getHost());
                for (Object conn : diag.getConnections()) {
                    EObject connElt;
                    if (!(conn instanceof ConnectionNodeEditPart) || !message.equals(connElt = ((ConnectionNodeEditPart)conn).resolveSemanticElement())) continue;
                    for (Object child : ((ConnectionNodeEditPart)conn).getChildren()) {
                        EObject childElt;
                        if (!(child instanceof GraphicalEditPart) || !droppedElement.equals(childElt = ((GraphicalEditPart)child).resolveSemanticElement())) continue;
                        return null;
                    }
                    return this.dropNodeOnMessage((PackageableElement)droppedElement, (ConnectionNodeEditPart)conn, visualId);
                }
            }
        }
        return null;
    }

    private boolean isDurationConstraintHint(int nodeVISUALID, int linkVISUALID) {
        if (linkVISUALID != -1) {
            return false;
        }
        return nodeVISUALID == -1 || nodeVISUALID == 3008 || nodeVISUALID == 3021 || nodeVISUALID == 3023;
    }

    private Command dropNodeOnMessage(PackageableElement durationLabelElement, ConnectionNodeEditPart messageEditPart, int nodeVISUALID) {
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)durationLabelElement);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, false, this.getDiagramPreferencesHint());
        return messageEditPart.getCommand((Request)new CreateViewRequest(descriptor));
    }

    private Command dropTimeObservationInLifeline(TimeObservation observation, int nodeVISUALID) {
        Point middlePoint;
        NamedElement occ1;
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)observation);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, false, this.getDiagramPreferencesHint());
        cc.add(this.getHost().getCommand((Request)new CreateViewRequest(descriptor)));
        LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart(this.getHost());
        if (lifelinePart != null && (occ1 = observation.getEvent()) instanceof OccurrenceSpecification && (middlePoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ1))) != null) {
            int height = this.getDefaultDropHeight(nodeVISUALID);
            Point startPoint = middlePoint.getCopy();
            if (height > 0) {
                startPoint.translate(0, -height / 2);
            }
            Rectangle newBounds = new Rectangle(startPoint, new Dimension(-1, height));
            lifelinePart.getFigure().translateToRelative((Translatable)newBounds);
            Point parentLoc = lifelinePart.getLocation();
            newBounds.translate(parentLoc.getNegated());
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
            cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
            return cc;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropIntervalConstraintInLifeline(IntervalConstraint constraint, int nodeVISUALID) {
        Point middlePoint;
        Element occ1;
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)constraint);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, false, this.getDiagramPreferencesHint());
        cc.add(this.getHost().getCommand((Request)new CreateViewRequest(descriptor)));
        LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart(this.getHost());
        if (lifelinePart != null && constraint.getConstrainedElements().size() >= 2) {
            Element occ12 = (Element)constraint.getConstrainedElements().get(0);
            Element occ2 = (Element)constraint.getConstrainedElements().get(1);
            if (occ12 instanceof OccurrenceSpecification && occ2 instanceof OccurrenceSpecification) {
                Point startPoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ12));
                Point endPoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ2));
                if (startPoint != null && endPoint != null) {
                    int height = endPoint.y - startPoint.y;
                    Rectangle newBounds = null;
                    newBounds = height < 0 ? new Rectangle(endPoint, new Dimension(-1, -height)) : new Rectangle(startPoint, new Dimension(-1, height));
                    lifelinePart.getFigure().translateToRelative((Translatable)newBounds);
                    Point parentLoc = lifelinePart.getLocation();
                    newBounds.translate(parentLoc.getNegated());
                    SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
                    cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
                    return cc;
                }
            }
        } else if (lifelinePart != null && constraint.getConstrainedElements().size() == 1 && (occ1 = (Element)constraint.getConstrainedElements().get(0)) instanceof OccurrenceSpecification && (middlePoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ1))) != null) {
            int height = this.getDefaultDropHeight(nodeVISUALID);
            Point startPoint = middlePoint.getCopy();
            if (height > 0) {
                startPoint.translate(0, -height / 2);
            }
            Rectangle newBounds = new Rectangle(startPoint, new Dimension(-1, height));
            lifelinePart.getFigure().translateToRelative((Translatable)newBounds);
            Point parentLoc = lifelinePart.getLocation();
            newBounds.translate(parentLoc.getNegated());
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
            cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
            return cc;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private int getDefaultDropHeight(int nodeVISUALID) {
        if (3019 == nodeVISUALID || 3020 == nodeVISUALID) {
            return 40;
        }
        return -1;
    }

    private Command dropStateInvariant(StateInvariant stateInvariant, int nodeVISUALID, Point location) {
        Lifeline lifeline = (Lifeline)stateInvariant.getCovereds().get(0);
        if (lifeline.equals(this.getHostObject())) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)stateInvariant));
        }
        return UnexecutableCommand.INSTANCE;
    }

    private List<Lifeline> getLifelines(List<View> existingViews) {
        ArrayList<Lifeline> lifelines = new ArrayList<Lifeline>();
        for (View view : existingViews) {
            EObject eObject = ViewUtil.resolveSemanticElement((View)((View)view.eContainer()));
            if (!(eObject instanceof Lifeline)) continue;
            lifelines.add((Lifeline)eObject);
        }
        return lifelines;
    }

    private Command dropDestructionEvent(DestructionEvent destructionEvent, int nodeVISUALID, Point location) {
        List existingViews = DiagramEditPartsUtil.findViews((EObject)destructionEvent, (EditPartViewer)this.getViewer());
        List<Lifeline> lifelines = this.getLifelines(existingViews);
        if (!lifelines.contains(this.getHostObject())) {
            Lifeline lifeline = (Lifeline)this.getHostObject();
            for (InteractionFragment ift : lifeline.getCoveredBys()) {
                OccurrenceSpecification occurrenceSpecification;
                if (!(ift instanceof OccurrenceSpecification) || !destructionEvent.equals((occurrenceSpecification = (OccurrenceSpecification)ift).getEvent())) continue;
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)destructionEvent));
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropExecutionSpecification(ExecutionSpecification es, int nodeVISUALID, Point location) {
        Lifeline lifeline;
        List existingViews = DiagramEditPartsUtil.findViews((EObject)es, (EditPartViewer)this.getViewer());
        if (existingViews.isEmpty() && es.getStart() != null && !es.getStart().getCovereds().isEmpty() && (lifeline = (Lifeline)es.getStart().getCovereds().get(0)).equals(this.getHostObject())) {
            IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
            String semanticHint = null;
            if (type != null) {
                semanticHint = type.getSemanticHint();
            }
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)es);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, false, this.getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            Rectangle bounds = this.getExecutionSpecificationBounds(es);
            if (bounds != null) {
                createViewRequest.setLocation(bounds.getLocation());
                createViewRequest.setSize(bounds.getSize());
            } else {
                createViewRequest.setLocation(location);
            }
            Command command = this.getHost().getCommand((Request)createViewRequest);
            return new ICommandProxy((ICommand)new CommandProxyWithResult(command, (Object)descriptor));
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Rectangle getExecutionSpecificationBounds(ExecutionSpecification es) {
        Point startLocation = null;
        Point finishLocation = null;
        Rectangle possibleStartLocations = null;
        Rectangle possibleFinishLocations = null;
        OccurrenceSpecification startEvent = es.getStart();
        OccurrenceSpecification finishEvent = es.getFinish();
        if (startEvent != null && finishEvent != null && this.getHost() instanceof LifelineEditPart) {
            int bottom;
            int top;
            LifelineEditPart hostLifeline = (LifelineEditPart)this.getHost();
            startLocation = SequenceUtil.findLocationOfEvent((LifelineEditPart)this.getHost(), (InteractionFragment)startEvent);
            if (startLocation == null) {
                possibleStartLocations = SequenceUtil.findPossibleLocationsForEvent(hostLifeline, startEvent);
            }
            if ((finishLocation = SequenceUtil.findLocationOfEvent(hostLifeline, (InteractionFragment)finishEvent)) == null) {
                possibleFinishLocations = SequenceUtil.findPossibleLocationsForEvent(hostLifeline, finishEvent);
            }
            if (startLocation == null) {
                if (finishLocation != null) {
                    top = possibleStartLocations.x;
                    bottom = possibleStartLocations.bottom();
                    if (top > finishLocation.y) {
                        return null;
                    }
                    startLocation = possibleStartLocations.getTop();
                    startLocation.y = (top + Math.min(bottom, finishLocation.y)) / 2;
                } else {
                    int topS = possibleStartLocations.y;
                    int bottomS = possibleStartLocations.bottom();
                    int topF = possibleFinishLocations.y;
                    int bottomF = possibleFinishLocations.bottom();
                    if (topS > bottomF) {
                        return null;
                    }
                    startLocation = possibleStartLocations.getTop();
                    finishLocation = possibleFinishLocations.getBottom();
                    if (bottomS < topF) {
                        startLocation.y = (topS + bottomS) / 2;
                        finishLocation.y = (topF + bottomF) / 2;
                    } else {
                        startLocation.y = (topS + bottomS + topS + topF) / 4;
                        finishLocation.y = (bottomF + topF + bottomF + bottomS) / 4;
                    }
                }
            }
            if (finishLocation == null) {
                top = possibleFinishLocations.y;
                bottom = possibleFinishLocations.bottom();
                if (bottom < startLocation.y) {
                    return null;
                }
                finishLocation = possibleFinishLocations.getBottom();
                finishLocation.y = (bottom + Math.max(top, startLocation.y)) / 2;
            }
            Rectangle result = new Rectangle(startLocation, finishLocation);
            result.width = 16;
            return result;
        }
        return null;
    }

    private Command dropMessage(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sources = SequenceLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = SequenceLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (!sources.isEmpty() && !targets.isEmpty()) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return this.getDropLocatedLinkCommand(dropRequest, source, target, linkVISUALID, semanticLink);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getDropLocatedLinkCommand(DropObjectsRequest dropRequest, Element source, Element target, int linkVISUALID, Element semanticLink) {
        ICommand createCommand;
        GraphicalEditPart sourceEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)source);
        GraphicalEditPart targetEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)target);
        CompositeCommand cc = new CompositeCommand("Drop");
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)this.getUMLElementType(linkVISUALID), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), this.getDiagramPreferencesHint());
        SemanticAdapter sourceAdapter = null;
        SemanticAdapter targetAdapter = null;
        if (sourceEditPart == null) {
            createCommand = this.getDefaultDropNodeCommand(this.getLinkSourceDropLocation(dropRequest.getLocation(), source, target), (EObject)source);
            cc.add((IUndoableOperation)createCommand);
            sourceAdapter = (IAdaptable)createCommand.getCommandResult().getReturnValue();
        } else {
            sourceAdapter = new SemanticAdapter(null, sourceEditPart.getModel());
        }
        if (targetEditPart == null) {
            createCommand = this.getDefaultDropNodeCommand(this.getLinkTargetDropLocation(dropRequest.getLocation(), source, target), (EObject)target);
            cc.add((IUndoableOperation)createCommand);
            targetAdapter = (IAdaptable)createCommand.getCommandResult().getReturnValue();
        } else {
            targetAdapter = new SemanticAdapter(null, targetEditPart.getModel());
        }
        CreateLocatedConnectionViewCommand aLinkCommand = new CreateLocatedConnectionViewCommand(this.getEditingDomain(), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), (IAdaptable)sourceAdapter, (IAdaptable)targetAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        aLinkCommand.setElement((EObject)semanticLink);
        Point[] sourceAndTarget = this.getLinkSourceAndTargetLocations(semanticLink, sourceEditPart, targetEditPart);
        aLinkCommand.setLocations(sourceAndTarget[0], sourceAndTarget[1]);
        cc.compose((IUndoableOperation)aLinkCommand);
        return new ICommandProxy((ICommand)cc);
    }

    private Point[] getLinkSourceAndTargetLocations(Element semanticLink, GraphicalEditPart sourceEditPart, GraphicalEditPart targetEditPart) {
        Point[] sourceAndTarget = new Point[2];
        OccurrenceSpecification sourceEvent = null;
        OccurrenceSpecification targetEvent = null;
        if (semanticLink instanceof Message) {
            MessageEnd rcvEvent;
            MessageEnd sendEvent = ((Message)semanticLink).getSendEvent();
            if (sendEvent instanceof OccurrenceSpecification) {
                sourceEvent = (OccurrenceSpecification)sendEvent;
            }
            if ((rcvEvent = ((Message)semanticLink).getReceiveEvent()) instanceof OccurrenceSpecification) {
                targetEvent = (OccurrenceSpecification)rcvEvent;
            }
        } else if (semanticLink instanceof GeneralOrdering) {
            sourceEvent = ((GeneralOrdering)semanticLink).getBefore();
            targetEvent = ((GeneralOrdering)semanticLink).getAfter();
        }
        if (sourceEvent != null || targetEvent != null) {
            int bottomTarget;
            int centerTarget;
            Rectangle possibleSourceLocations = null;
            Rectangle possibleTargetLocations = null;
            if (sourceEvent != null && sourceEditPart instanceof LifelineEditPart) {
                sourceAndTarget[0] = SequenceUtil.findLocationOfEvent((LifelineEditPart)sourceEditPart, (InteractionFragment)sourceEvent);
                if (sourceAndTarget[0] == null) {
                    possibleSourceLocations = SequenceUtil.findPossibleLocationsForEvent((LifelineEditPart)sourceEditPart, sourceEvent);
                }
            }
            if (targetEvent != null && targetEditPart instanceof LifelineEditPart) {
                sourceAndTarget[1] = SequenceUtil.findLocationOfEvent((LifelineEditPart)targetEditPart, (InteractionFragment)targetEvent);
                if (sourceAndTarget[1] == null) {
                    possibleTargetLocations = SequenceUtil.findPossibleLocationsForEvent((LifelineEditPart)targetEditPart, targetEvent);
                }
            }
            if (sourceAndTarget[0] == null && possibleSourceLocations != null) {
                if (sourceAndTarget[1] == null && possibleTargetLocations == null) {
                    sourceAndTarget[0] = possibleSourceLocations.getCenter();
                } else if (sourceAndTarget[1] != null) {
                    int topSource = possibleSourceLocations.y;
                    int centerSource = possibleSourceLocations.getCenter().y;
                    if (sourceAndTarget[1].y < topSource) {
                        sourceAndTarget[0] = possibleSourceLocations.getTop();
                    } else if (centerSource <= sourceAndTarget[1].y) {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                    } else {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[0].y = sourceAndTarget[1].y;
                    }
                } else {
                    centerTarget = possibleTargetLocations.getCenter().y;
                    bottomTarget = possibleTargetLocations.bottom();
                    int topSource = possibleSourceLocations.y;
                    int centerSource = possibleSourceLocations.getCenter().y;
                    if (bottomTarget < topSource) {
                        sourceAndTarget[0] = possibleSourceLocations.getTop();
                        sourceAndTarget[1] = possibleTargetLocations.getBottom();
                    } else if (centerSource <= centerTarget) {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[1] = possibleTargetLocations.getCenter();
                    } else {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[0].y = (topSource + bottomTarget) / 2;
                        sourceAndTarget[1] = possibleTargetLocations.getCenter();
                        sourceAndTarget[1].y = (topSource + bottomTarget) / 2;
                    }
                }
            }
            if (sourceAndTarget[1] == null && possibleTargetLocations != null) {
                centerTarget = possibleTargetLocations.getCenter().y;
                bottomTarget = possibleTargetLocations.bottom();
                if (sourceAndTarget[0] == null) {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                } else if (bottomTarget < sourceAndTarget[0].y) {
                    sourceAndTarget[1] = possibleTargetLocations.getBottom();
                } else if (sourceAndTarget[0].y <= centerTarget) {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                } else {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                    sourceAndTarget[1].y = sourceAndTarget[0].y;
                }
            }
        }
        return sourceAndTarget;
    }

    private Command dropGeneralOrdering(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sources = SequenceLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = SequenceLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (!sources.isEmpty() && !targets.isEmpty()) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return this.getDropLocatedLinkCommand(dropRequest, source, target, linkVISUALID, semanticLink);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

