/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.policies;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.papyrus.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.diagram.sequence.edit.policies.InteractionCompartmentXYLayoutEditPolicy;
import org.eclipse.papyrus.diagram.sequence.providers.UMLElementTypes;

public class InteractionOperandLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        EditPolicy result = super.createChildEditPolicy(child);
        if (result == null) {
            return new ResizableShapeEditPolicy();
        }
        return result;
    }

    public Command getCommand(Request request) {
        EditPart combinedFragmentCompartment = this.getHost().getParent();
        EditPart combinedFragment = combinedFragmentCompartment.getParent();
        EditPart interactionCompartment = combinedFragment.getParent();
        if ("create child".equals(request.getType()) && request instanceof CreateUnspecifiedTypeRequest) {
            if (UMLElementTypes.InteractionOperand_3005.equals(((CreateUnspecifiedTypeRequest)request).getElementTypes().get(0))) {
                return combinedFragmentCompartment.getCommand(request);
            }
            if (UMLElementTypes.CombinedFragment_3004.equals(((CreateUnspecifiedTypeRequest)request).getElementTypes().get(0))) {
                return interactionCompartment.getCommand(request);
            }
            if (UMLElementTypes.Lifeline_3001.equals(((CreateUnspecifiedTypeRequest)request).getElementTypes().get(0))) {
                return interactionCompartment.getCommand(request);
            }
        } else if (request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)request;
            if (this.getHost().equals(createConnectionRequest.getSourceEditPart())) {
                createConnectionRequest.setSourceEditPart(combinedFragment);
            }
            if (this.getHost().equals(createConnectionRequest.getTargetEditPart())) {
                createConnectionRequest.setTargetEditPart(combinedFragment);
            }
            return combinedFragment.getCommand(request);
        }
        return super.getCommand(request);
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand compoundCmd = new CompoundCommand();
        compoundCmd.setLabel("Move or Resize");
        for (Object o : request.getEditParts()) {
            Command resizeChildrenCommand;
            GraphicalEditPart child = (GraphicalEditPart)o;
            Object constraintFor = this.getConstraintFor(request, child);
            if (constraintFor == null) continue;
            if (child instanceof CombinedFragmentEditPart && (resizeChildrenCommand = InteractionCompartmentXYLayoutEditPolicy.getCombinedFragmentResizeChildrenCommand(request, (CombinedFragmentEditPart)child)) != null && resizeChildrenCommand.canExecute()) {
                compoundCmd.add(resizeChildrenCommand);
            }
            Command changeConstraintCommand = this.createChangeConstraintCommand(request, (EditPart)child, this.translateToModelConstraint(constraintFor));
            compoundCmd.add(changeConstraintCommand);
        }
        if (compoundCmd.isEmpty()) {
            return null;
        }
        return compoundCmd.unwrap();
    }
}

