/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.policies;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.diagram.sequence.edit.policies.LifelineXYLayoutEditPolicy;
import org.junit.Assert;
import org.junit.Test;

public class LifelineXYLayoutEditPolicyTest {
    @Test
    public void testAdaptSizeDeltaToMaxHeight() {
        Figure figure = new Figure();
        figure.setBounds(new Rectangle(1, 2, 10, 20));
        figure.setMaximumSize(new Dimension(100, 200));
        figure.setMinimumSize(new Dimension(0, 30));
        Dimension sizeDelta = new Dimension(30, 40);
        Dimension newSizeDelta = LifelineXYLayoutEditPolicy.adaptSizeDeltaToMaxHeight((IFigure)figure, sizeDelta);
        Assert.assertFalse((String)"Original dimension modified", (sizeDelta == newSizeDelta ? 1 : 0) != 0);
        Assert.assertEquals((String)"Width can't change", (long)30L, (long)newSizeDelta.width);
        Assert.assertEquals((String)"Height change", (long)40L, (long)newSizeDelta.height);
        sizeDelta = new Dimension(30, 190);
        newSizeDelta = LifelineXYLayoutEditPolicy.adaptSizeDeltaToMaxHeight((IFigure)figure, sizeDelta);
        Assert.assertFalse((String)"Original dimension modified", (sizeDelta == newSizeDelta ? 1 : 0) != 0);
        Assert.assertEquals((String)"Width can't change", (long)30L, (long)newSizeDelta.width);
        Assert.assertEquals((String)"Height don't change", (long)180L, (long)newSizeDelta.height);
        sizeDelta = new Dimension(30, 0);
        newSizeDelta = LifelineXYLayoutEditPolicy.adaptSizeDeltaToMaxHeight((IFigure)figure, sizeDelta);
        Assert.assertFalse((String)"Original dimension modified", (sizeDelta == newSizeDelta ? 1 : 0) != 0);
        Assert.assertEquals((String)"Width can't change", (long)30L, (long)newSizeDelta.width);
        Assert.assertEquals((String)"Height don't change", (long)10L, (long)newSizeDelta.height);
    }

    @Test
    public void testIsAffixedToRight() {
        Rectangle leftFigure = new Rectangle(10, 10, 10, 10);
        Rectangle rightFigure = new Rectangle(15, 15, 10, 10);
        Assert.assertTrue((String)"Left figure is not on the left of the right figure", (boolean)LifelineXYLayoutEditPolicy.isAffixedToRight(leftFigure, rightFigure));
        Assert.assertFalse((String)"Right figure is on the left of the left figure", (boolean)LifelineXYLayoutEditPolicy.isAffixedToRight(rightFigure, leftFigure));
    }

    @Test
    public void testGetRealMoveDelta() {
        Rectangle oldRelativeBounds = new Rectangle(10, 10, 10, 10);
        Rectangle newRelativeBounds = new Rectangle(15, 20, 25, 30);
        Rectangle absoluteBounds = LifelineXYLayoutEditPolicy.getRealMoveDelta(oldRelativeBounds, newRelativeBounds);
        Assert.assertEquals((String)"Wrong x", (long)5L, (long)absoluteBounds.x);
        Assert.assertEquals((String)"Wrong y", (long)10L, (long)absoluteBounds.y);
        Assert.assertEquals((String)"Wrong width", (long)15L, (long)absoluteBounds.width);
        Assert.assertEquals((String)"Wrong height", (long)20L, (long)absoluteBounds.height);
    }

    @Test
    public void testGetRelativeBounds() {
        Figure parentFigure = new Figure();
        parentFigure.setBounds(new Rectangle(10, 20, 100, 100));
        Figure childFigure = new Figure();
        childFigure.setBounds(new Rectangle(20, 30, 50, 50));
        childFigure.setParent((IFigure)parentFigure);
        Rectangle absoluteChild = LifelineXYLayoutEditPolicy.getRelativeBounds((IFigure)childFigure);
        Assert.assertEquals((String)"Wrong x", (long)10L, (long)absoluteChild.x);
        Assert.assertEquals((String)"Wrong y", (long)10L, (long)absoluteChild.y);
        Assert.assertEquals((String)"Wrong width", (long)50L, (long)absoluteChild.width);
        Assert.assertEquals((String)"Wrong height", (long)50L, (long)absoluteChild.height);
    }
}

