/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.diagram.sequence.edit.parts.CombinedFragment2EditPart;
import org.eclipse.papyrus.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.diagram.sequence.part.Messages;
import org.eclipse.papyrus.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class SequenceGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    private static final int MARGIN = 2;

    protected Command getConnectionAndRelationshipCreateCommand(CreateConnectionViewAndElementRequest request) {
        LifelineEditPart lifelinePart;
        Map extendedData = request.getExtendedData();
        String requestHint = request.getConnectionViewAndElementDescriptor().getSemanticHint();
        if (this.isCreatedNearOccurrenceSpecification(requestHint) && (lifelinePart = SequenceUtil.getParentLifelinePart(this.getHost())) != null) {
            Map.Entry<Point, List<OccurrenceSpecification>> eventAndLocation = SequenceUtil.findNearestEvent(request.getLocation(), lifelinePart);
            List<Object> events = Collections.emptyList();
            Point location = null;
            if (eventAndLocation != null) {
                location = eventAndLocation.getKey();
                events = eventAndLocation.getValue();
            }
            extendedData.put("Nearest occurrence specification", events);
            extendedData.put("Nearest occurrence specification location", location);
            if (location != null) {
                request.setLocation(location);
            }
        }
        return super.getConnectionAndRelationshipCreateCommand(request);
    }

    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        LifelineEditPart lifelinePart;
        Map extendedData = request.getExtendedData();
        String requestHint = request.getConnectionViewAndElementDescriptor().getSemanticHint();
        if (this.isCreatedNearOccurrenceSpecification(requestHint) && (lifelinePart = SequenceUtil.getParentLifelinePart(this.getHost())) != null) {
            Map.Entry<Point, List<OccurrenceSpecification>> eventAndLocation = SequenceUtil.findNearestEvent(request.getLocation(), lifelinePart);
            List<Object> events = Collections.emptyList();
            Point location = null;
            if (eventAndLocation != null) {
                location = eventAndLocation.getKey();
                events = eventAndLocation.getValue();
            }
            extendedData.put("Nearest occurrence specification (end)", events);
            extendedData.put("Nearest occurrence specification location (end)", location);
            if (location != null) {
                request.setLocation(location);
            }
        }
        return super.getConnectionAndRelationshipCompleteCommand(request);
    }

    private boolean isCreatedNearOccurrenceSpecification(String requestHint) {
        String generalOrderingHint = ((IHintedType)UMLElementTypes.GeneralOrdering_4012).getSemanticHint();
        return generalOrderingHint.equals(requestHint);
    }

    private boolean isMessageHint(String requestHint) {
        ArrayList<String> messageHints = new ArrayList<String>(7);
        String messageHint = ((IHintedType)UMLElementTypes.Message_4003).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4004).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4005).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4006).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4007).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4008).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4009).getSemanticHint();
        messageHints.add(messageHint);
        return messageHints.contains(requestHint);
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        request.getExtendedData().put("Location of connection source point", request.getLocation());
        return super.getConnectionCreateCommand(request);
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        String requestHint;
        Command command = super.getConnectionCompleteCommand(request);
        if (command == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (request instanceof CreateConnectionViewRequest && !this.isMessageHint(requestHint = ((CreateConnectionViewRequest)request).getConnectionViewDescriptor().getSemanticHint())) {
            return command;
        }
        Point sourcePoint = (Point)request.getExtendedData().get("Location of connection source point");
        Point targetPoint = request.getLocation();
        if (sourcePoint.y >= targetPoint.y + 2) {
            return UnexecutableCommand.INSTANCE;
        }
        if (request.getSourceEditPart().equals(request.getTargetEditPart()) && sourcePoint.y >= targetPoint.y) {
            return UnexecutableCommand.INSTANCE;
        }
        if (request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor desc = ((CreateConnectionViewAndElementRequest)request).getConnectionViewAndElementDescriptor();
            String replyHint = ((IHintedType)UMLElementTypes.Message_4005).getSemanticHint();
            if (replyHint.equals(desc.getSemanticHint()) && request.getSourceEditPart() instanceof IGraphicalEditPart) {
                Rectangle srcBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)request.getSourceEditPart());
                int bottom = srcBounds.getBottom().y;
                if (bottom >= targetPoint.y) {
                    return UnexecutableCommand.INSTANCE;
                }
            }
        }
        request.getExtendedData().put("Source model container", SequenceUtil.findInteractionFragmentContainerAt(sourcePoint, this.getHost()));
        request.getExtendedData().put("Target model container", SequenceUtil.findInteractionFragmentContainerAt(targetPoint, this.getHost()));
        EditPart targetEditPart = this.getTargetEditPart((Request)request);
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            request.getExtendedData().put("Lifeline graphical container", ((CombinedFragment2EditPart)targetEditPart).getAttachedLifeline());
        }
        return command;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        if (this.isUphillMessage(request)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getReconnectSourceCommand(request);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        if (this.isUphillMessage(request)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getReconnectTargetCommand(request);
    }

    protected boolean isUphillMessage(ReconnectRequest request) {
        Edge edge;
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        if (connectionEditPart.getModel() instanceof Edge && (edge = (Edge)connectionEditPart.getModel()).getElement() instanceof Message && connectionEditPart.getFigure() instanceof Polyline) {
            Polyline polyline = (Polyline)connectionEditPart.getFigure();
            Point end = polyline.getEnd().getCopy();
            Point start = polyline.getStart().getCopy();
            polyline.getParent().translateToAbsolute((Translatable)end);
            polyline.getParent().translateToAbsolute((Translatable)start);
            if ("Reconnection source".equals(request.getType())) {
                return request.getLocation().y >= end.y + 2;
            }
            if ("Reconnection target".equals(request.getType())) {
                return start.y >= request.getLocation().y + 2;
            }
            return start.y >= end.y + 2;
        }
        return false;
    }

    protected Connection createDummyConnection(Request req) {
        Connection conn = super.createDummyConnection(req);
        conn.setForegroundColor(ColorConstants.black);
        return conn;
    }

    protected ICommand getPromptAndCreateConnectionCommand(List content, CreateConnectionRequest request) {
        return new SequencePromptAndCreateConnectionCommand(content, request);
    }

    protected class SequencePromptAndCreateConnectionCommand
    extends GraphicalNodeEditPolicy.PromptAndCreateConnectionCommand {
        public SequencePromptAndCreateConnectionCommand(List content, CreateConnectionRequest request) {
            super((GraphicalNodeEditPolicy)SequenceGraphicalNodeEditPolicy.this, content, request);
        }

        protected ILabelProvider getLabelProvider() {
            return new CreateOrSelectElementCommand.LabelProvider(){

                public String getText(Object object) {
                    if (object instanceof IHintedType) {
                        IHintedType elementType = (IHintedType)object;
                        switch (UMLVisualIDRegistry.getVisualID(elementType.getSemanticHint())) {
                            case 4003: {
                                return Messages.createMessageSync1CreationTool_title;
                            }
                            case 4004: {
                                return Messages.createMessageAsync2CreationTool_title;
                            }
                            case 4005: {
                                return Messages.createMessageReply3CreationTool_title;
                            }
                            case 4006: {
                                return Messages.createMessageCreate4CreationTool_title;
                            }
                            case 4007: {
                                return Messages.createMessageDelete5CreationTool_title;
                            }
                            case 4008: {
                                return Messages.createMessageLost6CreationTool_title;
                            }
                            case 4009: {
                                return Messages.createMessageFound7CreationTool_title;
                            }
                        }
                    }
                    return super.getText(object);
                }
            };
        }
    }
}

