/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

public class CoRegionCombinedFragmentFigure
extends RectangleFigure {
    private static final int COREGION_HIT_WIDTH = 6;
    private static final int BRACKET_HEIGHT = 7;
    private static final int BRACKET_LINE_WIDTH = 3;
    private NodeFigure centralVerticalLine = new NodeFigure();

    public CoRegionCombinedFragmentFigure() {
        this.centralVerticalLine.setParent((IFigure)this);
    }

    public void paintFigure(Graphics graphics) {
        Rectangle r = this.getBounds().getCopy();
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.setForegroundColor(this.getForegroundColor());
        graphics.setLineWidth(3);
        graphics.drawLine(r.x, r.y, r.right() - 1, r.y);
        graphics.drawLine(r.x, r.bottom() - 1, r.right() - 1, r.bottom() - 1);
        graphics.drawLine(r.x, r.y, r.x, r.y + 7);
        graphics.drawLine(r.right() - 1, r.y + 7, r.right() - 1, r.y);
        graphics.drawLine(r.right() - 1, r.bottom() - 1, r.right() - 1, r.bottom() - 1 - 7);
        graphics.drawLine(r.x, r.bottom() - 1, r.x, r.bottom() - 1 - 7);
        int endY = r.height + r.x;
        Point pStart = new Point(r.x + r.width / 2, r.y + 1);
        this.centralVerticalLine.setSize(1, endY - pStart.y);
        this.centralVerticalLine.setLocation(pStart);
    }

    public boolean containsPoint(int x, int y) {
        Rectangle rect = this.getBounds();
        if (x > rect.x && x < rect.x + rect.width && y > rect.y - 6 && y < rect.y + 6) {
            return true;
        }
        if (x > rect.x && x < rect.x + rect.width && y > rect.y + rect.height - 6 && y < rect.y + rect.height + 6) {
            return true;
        }
        if (x > rect.x - 6 && x < rect.x + 6 && y > rect.y && y < rect.y + rect.height) {
            return true;
        }
        if (x > rect.x + rect.width - 6 && x < rect.x + rect.width + 6 && y > rect.y && y < rect.y + rect.height) {
            return true;
        }
        for (IFigure child : this.getChildren()) {
            Point local = new Point(x, y);
            this.translateFromParent((Translatable)local);
            if (!child.containsPoint(local)) continue;
            return true;
        }
        return false;
    }

    public NodeFigure getCentralVerticalLine() {
        return this.centralVerticalLine;
    }
}

