/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.diagram.sequence.parsers.MessageFormatParser;
import org.eclipse.papyrus.umlutils.OperationUtil;
import org.eclipse.papyrus.umlutils.SignalUtil;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.UMLPackage;

public class MessageCustomParser
extends MessageFormatParser
implements ISemanticParser {
    public MessageCustomParser(EAttribute[] features) {
        super(features);
    }

    public MessageCustomParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public MessageCustomParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    public String getPrintString(IAdaptable adapter, int flags) {
        Object obj = adapter.getAdapter(EObject.class);
        String result = null;
        if (obj instanceof Message) {
            Message message = (Message)obj;
            NamedElement signature = message.getSignature();
            if (signature instanceof Operation) {
                Operation operation = (Operation)signature;
                result = MessageSort.REPLY_LITERAL.equals((Object)message.getMessageSort()) ? OperationUtil.getCustomLabel((Operation)operation, (int)520) : (MessageSort.SYNCH_CALL_LITERAL.equals((Object)message.getMessageSort()) ? OperationUtil.getCustomLabel((Operation)operation, (int)4360) : OperationUtil.getCustomLabel((Operation)operation, (int)4872));
            } else if (signature instanceof Signal) {
                result = SignalUtil.getCustomLabel((Signal)((Signal)signature), (int)24);
            } else if (signature != null) {
                result = signature.getName();
            }
            if (result == null || result.equals("")) {
                result = message.getName();
            }
        }
        return result;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof Message) {
            Message message = (Message)element;
            semanticElementsBeingParsed.add(message);
            NamedElement signature = message.getSignature();
            semanticElementsBeingParsed.add(signature);
            if (signature instanceof Operation) {
                for (Parameter parameter : ((Operation)signature).getOwnedParameters()) {
                    semanticElementsBeingParsed.add(parameter);
                }
            }
            if (signature instanceof Signal) {
                for (Property property : ((Signal)signature).getOwnedAttributes()) {
                    semanticElementsBeingParsed.add(property);
                }
            }
        }
        return semanticElementsBeingParsed;
    }
}

