/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.providers;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.IClientSelector;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.diagram.sequence.validation.UMLValidationHelper;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;

public class UMLValidationProvider {
    private static boolean constraintsActive = false;

    public static boolean shouldConstraintsBePrivate() {
        return false;
    }

    public static void runWithConstraints(TransactionalEditingDomain editingDomain, Runnable operation) {
        final Runnable op = operation;
        Runnable task = new Runnable(){

            public void run() {
                try {
                    constraintsActive = true;
                    op.run();
                }
                finally {
                    constraintsActive = false;
                }
            }
        };
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(task);
            }
            catch (Exception e) {
                UMLDiagramEditorPlugin.getInstance().logError("Validation failed", e);
            }
        } else {
            task.run();
        }
    }

    static boolean isInDefaultEditorContext(Object object) {
        if (UMLValidationProvider.shouldConstraintsBePrivate() && !constraintsActive) {
            return false;
        }
        if (object instanceof View) {
            return constraintsActive && "PapyrusUMLSequenceDiagram".equals(UMLVisualIDRegistry.getModelID((View)object));
        }
        return true;
    }

    public static ITraversalStrategy getNotationTraversalStrategy(IBatchValidator validator) {
        return new CtxSwitchStrategy(validator);
    }

    static String formatElement(EObject object) {
        return EMFCoreUtil.getQualifiedName((EObject)object, (boolean)true);
    }

    public static class Adapter1
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            Interaction context = (Interaction)ctx.getTarget();
            return UMLValidationHelper.validateFragmentsOrder(context, ctx);
        }
    }

    public static class Adapter2
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            InteractionOperand context = (InteractionOperand)ctx.getTarget();
            return UMLValidationHelper.validateFragmentsOrder(context, ctx);
        }
    }

    public static class Adapter3
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            EObject target = ctx.getTarget();
            return UMLValidationHelper.validateFragmentsOrder(target, ctx);
        }
    }

    private static class CtxSwitchStrategy
    implements ITraversalStrategy {
        private ITraversalStrategy defaultStrategy;
        private int currentSemanticCtxId = -1;
        private boolean ctxChanged = true;
        private EObject currentTarget;
        private EObject preFetchedNextTarget;
        private final int[] contextSwitchingIdentifiers;

        CtxSwitchStrategy(IBatchValidator validator) {
            this.defaultStrategy = validator.getDefaultTraversalStrategy();
            this.contextSwitchingIdentifiers = new int[]{3001};
            Arrays.sort(this.contextSwitchingIdentifiers);
        }

        public void elementValidated(EObject element, IStatus status) {
            this.defaultStrategy.elementValidated(element, status);
        }

        public boolean hasNext() {
            return this.defaultStrategy.hasNext();
        }

        public boolean isClientContextChanged() {
            if (this.preFetchedNextTarget == null) {
                this.preFetchedNextTarget = this.next();
                this.prepareNextClientContext(this.preFetchedNextTarget);
            }
            return this.ctxChanged;
        }

        public EObject next() {
            EObject nextTarget = this.preFetchedNextTarget;
            if (nextTarget == null) {
                nextTarget = this.defaultStrategy.next();
            }
            this.preFetchedNextTarget = null;
            this.currentTarget = nextTarget;
            return this.currentTarget;
        }

        public void startTraversal(Collection traversalRoots, IProgressMonitor monitor) {
            this.defaultStrategy.startTraversal(traversalRoots, monitor);
        }

        private void prepareNextClientContext(EObject nextTarget) {
            if (nextTarget != null && this.currentTarget != null) {
                if (nextTarget instanceof View) {
                    int nextSemanticId;
                    int id = UMLVisualIDRegistry.getVisualID((View)nextTarget);
                    int n = nextSemanticId = id != -1 && Arrays.binarySearch(this.contextSwitchingIdentifiers, id) >= 0 ? id : -1;
                    if (this.currentSemanticCtxId != -1 && this.currentSemanticCtxId != nextSemanticId || nextSemanticId != -1 && nextSemanticId != this.currentSemanticCtxId) {
                        this.ctxChanged = true;
                    }
                    this.currentSemanticCtxId = nextSemanticId;
                } else {
                    this.ctxChanged = this.currentSemanticCtxId != -1;
                    this.currentSemanticCtxId = -1;
                }
            } else {
                this.ctxChanged = false;
            }
        }
    }

    public static class Ctx_3001
    implements IClientSelector {
        public boolean selects(Object object) {
            if (object instanceof Bounds) {
                object = ((Bounds)object).eContainer();
            }
            if (object instanceof View && "PapyrusUMLSequenceDiagram".equals(UMLVisualIDRegistry.getModelID((View)object))) {
                int id = UMLVisualIDRegistry.getVisualID((View)object);
                boolean result = false;
                result = result || id == 3001;
                result = result || id == 3006;
                result = result || id == 3003;
                result = result || id == 3004;
                result = result || id == 3018;
                result = result || id == 3005;
                result = result || id == 4003;
                result = result || id == 4004;
                result = result || id == 4005;
                result = result || id == 4006;
                result = result || id == 4007;
                result = result || id == 4008;
                result = result || id == 4009;
                return result;
            }
            return false;
        }
    }

    public static class DefaultCtx
    implements IClientSelector {
        public boolean selects(Object object) {
            return UMLValidationProvider.isInDefaultEditorContext(object);
        }
    }
}

