/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.diagram.sequence.providers.ElementInitializers;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.CreationEvent;
import org.eclipse.uml2.uml.DestructionEvent;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.ExecutionEvent;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ReceiveOperationEvent;
import org.eclipse.uml2.uml.ReceiveSignalEvent;
import org.eclipse.uml2.uml.SendOperationEvent;
import org.eclipse.uml2.uml.SendSignalEvent;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.UMLPackage;

public class EventHelper {
    public static Event doCreateEvent(Package eventContainer, EClass eClass) {
        Event event = (Event)eventContainer.createPackagedElement(null, eClass);
        ElementInitializers.init_NamedElement((NamedElement)event);
        return event;
    }

    public static CallEvent doCreateCallEvent(Package eventContainer, Operation operation) {
        CallEvent event = (CallEvent)EventHelper.doCreateEvent(eventContainer, UMLPackage.eINSTANCE.getCallEvent());
        event.setOperation(operation);
        return event;
    }

    public static SendOperationEvent doCreateSendOperationEvent(Package eventContainer, Operation operation) {
        SendOperationEvent sendOperationEvent = (SendOperationEvent)EventHelper.doCreateEvent(eventContainer, UMLPackage.eINSTANCE.getSendOperationEvent());
        sendOperationEvent.setOperation(operation);
        return sendOperationEvent;
    }

    public static ReceiveOperationEvent doCreateReceiveOperationEvent(Package eventContainer, Operation operation) {
        ReceiveOperationEvent receiveOperationEvent = (ReceiveOperationEvent)EventHelper.doCreateEvent(eventContainer, UMLPackage.eINSTANCE.getReceiveOperationEvent());
        receiveOperationEvent.setOperation(operation);
        return receiveOperationEvent;
    }

    public static SendSignalEvent doCreateSendSignalEvent(Package eventContainer, Signal signal) {
        SendSignalEvent sendSignalEvent = (SendSignalEvent)EventHelper.doCreateEvent(eventContainer, UMLPackage.eINSTANCE.getSendSignalEvent());
        sendSignalEvent.setSignal(signal);
        return sendSignalEvent;
    }

    public static ReceiveSignalEvent doCreateReceiveSignalEvent(Package eventContainer, Signal signal) {
        ReceiveSignalEvent receiveSignalEvent = (ReceiveSignalEvent)EventHelper.doCreateEvent(eventContainer, UMLPackage.eINSTANCE.getReceiveSignalEvent());
        receiveSignalEvent.setSignal(signal);
        return receiveSignalEvent;
    }

    public static CreationEvent doCreateCreationEvent(Package eventContainer) {
        return (CreationEvent)EventHelper.doCreateEvent(eventContainer, UMLPackage.eINSTANCE.getCreationEvent());
    }

    public static DestructionEvent doCreateDestructionEvent(Package eventContainer) {
        return (DestructionEvent)EventHelper.doCreateEvent(eventContainer, UMLPackage.eINSTANCE.getDestructionEvent());
    }

    public static ExecutionEvent doCreateExecutionEvent(Package eventContainer) {
        return (ExecutionEvent)EventHelper.doCreateEvent(eventContainer, UMLPackage.eINSTANCE.getExecutionEvent());
    }

    public static Event doCreateReceiveEvent(MessageSort messageSort, Interaction interaction, NamedElement signature) {
        Package eventContainer = interaction.getNearestPackage();
        CreationEvent event = null;
        switch (messageSort) {
            case ASYNCH_SIGNAL_LITERAL: {
                event = EventHelper.doCreateReceiveSignalEvent(eventContainer, (Signal)signature);
                break;
            }
            case SYNCH_CALL_LITERAL: 
            case ASYNCH_CALL_LITERAL: 
            case REPLY_LITERAL: {
                event = EventHelper.doCreateReceiveOperationEvent(eventContainer, (Operation)signature);
                break;
            }
            case CREATE_MESSAGE_LITERAL: {
                event = EventHelper.doCreateCreationEvent(eventContainer);
                break;
            }
            case DELETE_MESSAGE_LITERAL: {
                event = EventHelper.doCreateDestructionEvent(eventContainer);
                break;
            }
        }
        return event;
    }

    public static Event doCreateSendEvent(MessageSort messageSort, Interaction interaction, NamedElement signature) {
        Package eventContainer = interaction.getNearestPackage();
        SendSignalEvent event = null;
        switch (messageSort) {
            case ASYNCH_SIGNAL_LITERAL: 
            case CREATE_MESSAGE_LITERAL: 
            case DELETE_MESSAGE_LITERAL: {
                event = EventHelper.doCreateSendSignalEvent(eventContainer, (Signal)signature);
                break;
            }
            case SYNCH_CALL_LITERAL: 
            case ASYNCH_CALL_LITERAL: 
            case REPLY_LITERAL: {
                event = EventHelper.doCreateSendOperationEvent(eventContainer, (Operation)signature);
                break;
            }
        }
        return event;
    }
}

