/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.util;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.diagram.sequence.util.OccurrenceSpecificationMoveHelper;
import org.eclipse.papyrus.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.DestructionEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDeleteHelper {
    public static CompoundCommand completeDeleteDestructionEventViewCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, EditPart destructionEventPart) {
        LifelineEditPart lifelinePart;
        EObject obj;
        if (destructionEventPart instanceof IGraphicalEditPart && (obj = ((IGraphicalEditPart)destructionEventPart).resolveSemanticElement()) instanceof DestructionEvent && (lifelinePart = SequenceUtil.getParentLifelinePart(destructionEventPart)) != null) {
            for (Object lifelineChild : lifelinePart.getChildren()) {
                IBorderItemEditPart timePart;
                boolean isNotLinked;
                if (!(lifelineChild instanceof IBorderItemEditPart) || (isNotLinked = OccurrenceSpecificationMoveHelper.canTimeElementPartBeYMoved(timePart = (IBorderItemEditPart)lifelineChild))) continue;
                ICommandProxy deleteTimeViewCommand = new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)timePart.getModel()));
                deleteViewsCmd.add((Command)deleteTimeViewCommand);
            }
        }
        return deleteViewsCmd;
    }

    public static CompoundCommand completeDeleteMessageViewCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, EditPart messagePart) {
        EObject obj;
        if (messagePart instanceof IGraphicalEditPart && (obj = ((IGraphicalEditPart)messagePart).resolveSemanticElement()) instanceof Message) {
            Message message = (Message)obj;
            LifelineEditPart srcLifelinePart = SequenceUtil.getParentLifelinePart(((ConnectionNodeEditPart)messagePart).getSource());
            MessageEnd send = message.getSendEvent();
            SequenceDeleteHelper.addDeleteRelatedTimePartsToCommand(deleteViewsCmd, editingDomain, srcLifelinePart, send);
            LifelineEditPart tgtLifelinePart = SequenceUtil.getParentLifelinePart(((ConnectionNodeEditPart)messagePart).getTarget());
            MessageEnd receive = message.getReceiveEvent();
            SequenceDeleteHelper.addDeleteRelatedTimePartsToCommand(deleteViewsCmd, editingDomain, tgtLifelinePart, receive);
        }
        return deleteViewsCmd;
    }

    private static void addDeleteRelatedTimePartsToCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, LifelineEditPart lifelineEP, MessageEnd messageEnd) {
        if (lifelineEP != null && messageEnd instanceof OccurrenceSpecification) {
            for (Object lifelineChild : lifelineEP.getChildren()) {
                IBorderItemEditPart timePart;
                int positionForEvent;
                if (!(lifelineChild instanceof IBorderItemEditPart) || (positionForEvent = SequenceUtil.positionWhereEventIsLinkedToPart((OccurrenceSpecification)messageEnd, timePart = (IBorderItemEditPart)lifelineChild)) == 0) continue;
                ICommandProxy deleteTimeViewCommand = new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)timePart.getModel()));
                deleteViewsCmd.add((Command)deleteTimeViewCommand);
            }
        }
    }

    public static CompoundCommand completeDeleteExecutionSpecificationViewCommand(CompoundCommand deleteViewsCmd, TransactionalEditingDomain editingDomain, EditPart executionPart) {
        EObject obj;
        if (executionPart instanceof IGraphicalEditPart && (obj = ((IGraphicalEditPart)executionPart).resolveSemanticElement()) instanceof ExecutionSpecification) {
            ExecutionSpecification execution = (ExecutionSpecification)obj;
            LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart(executionPart);
            if (lifelinePart != null) {
                for (Object lifelineChild : lifelinePart.getChildren()) {
                    if (!(lifelineChild instanceof IBorderItemEditPart)) continue;
                    IBorderItemEditPart timePart = (IBorderItemEditPart)lifelineChild;
                    OccurrenceSpecification start = execution.getStart();
                    OccurrenceSpecification finish = execution.getStart();
                    int positionForStart = SequenceUtil.positionWhereEventIsLinkedToPart(start, timePart);
                    int positionForFinish = SequenceUtil.positionWhereEventIsLinkedToPart(finish, timePart);
                    if (positionForStart == 0 && positionForFinish == 0) continue;
                    ICommandProxy deleteTimeViewCommand = new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)timePart.getModel()));
                    deleteViewsCmd.add((Command)deleteTimeViewCommand);
                }
            }
        }
        return deleteViewsCmd;
    }

    public static void deleteView(CompositeTransactionalCommand cmd, List<Element> elements, TransactionalEditingDomain editingDomain) {
        for (Element element : elements) {
            SequenceDeleteHelper.deleteView(cmd, element, editingDomain);
        }
    }

    public static void deleteView(CompositeTransactionalCommand cmd, Element element, TransactionalEditingDomain editingDomain) {
        List views = DiagramEditPartsUtil.getEObjectViews((EObject)element);
        for (Object object : views) {
            if (!(object instanceof View)) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(editingDomain, (View)object));
        }
    }
}

